/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.client.gui.me.common.FinishedJobToast;
import appeng.client.gui.me.common.MEStorageScreen;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.sync.packets.CraftingJobStatusPacket;
import appeng.items.tools.powered.WirelessTerminalItem;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class PendingCraftingJobs {
    private static final Map<String, PendingJob> jobs = new HashMap<String, PendingJob>();

    private PendingCraftingJobs() {
    }

    public static boolean hasPendingJob(AEKey what) {
        return jobs.entrySet().stream().anyMatch(s -> ((PendingJob)s.getValue()).what.equals(what));
    }

    public static void jobStatus(String id, AEKey what, long requestedAmount, long remainingAmount, CraftingJobStatusPacket.Status status) {
        AELog.debug("Crafting job " + id + " for " + requestedAmount + "x" + AEStackRendering.getDisplayName(what).getString() + ". State=" + status, new Object[0]);
        PendingJob existing = jobs.get(id);
        switch (status) {
            case STARTED: {
                if (existing != null) break;
                jobs.put(id, new PendingJob(id, what, requestedAmount, remainingAmount));
                break;
            }
            case CANCELLED: {
                jobs.remove(id);
                break;
            }
            case FINISHED: {
                jobs.remove(id);
                class_310 minecraft = class_310.method_1551();
                if (!AEConfig.instance().isNotifyForFinishedCraftingJobs() || minecraft.field_1755 instanceof MEStorageScreen || minecraft.field_1724 == null || !PendingCraftingJobs.hasNotificationEnablingItem(minecraft.field_1724)) break;
                minecraft.method_1566().method_1999((class_368)new FinishedJobToast(what, requestedAmount));
            }
        }
    }

    private static boolean hasNotificationEnablingItem(class_746 player) {
        class_1661 playerInv = player.method_31548();
        for (int i = 0; i < playerInv.method_5439(); ++i) {
            WirelessTerminalItem wirelessTerminal;
            class_1792 class_17922;
            class_1799 stack = playerInv.method_5438(i);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof WirelessTerminalItem) || !((wirelessTerminal = (WirelessTerminalItem)class_17922).getAECurrentPower(stack) > 0.0) || !wirelessTerminal.getGridKey(stack).isPresent()) continue;
            return true;
        }
        return false;
    }

    record PendingJob(String jobId, AEKey what, long requestedAmount, long remainingAmount) {
    }
}

