/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.crafting.AbstractTableRenderer;
import appeng.client.gui.me.crafting.CraftConfirmTableRenderer;
import appeng.client.gui.me.crafting.CraftErrorScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.GuiText;
import appeng.menu.me.crafting.CraftConfirmMenu;
import appeng.menu.me.crafting.CraftingPlanSummary;
import java.text.NumberFormat;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class CraftConfirmScreen
extends AEBaseScreen<CraftConfirmMenu> {
    private final CraftConfirmTableRenderer table = new CraftConfirmTableRenderer(this, 9, 19);
    private final class_4185 start;
    private final class_4185 selectCPU;
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");

    public CraftConfirmScreen(CraftConfirmMenu menu, class_1661 playerInventory, class_2561 title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.start = this.widgets.addButton("start", (class_2561)GuiText.Start.text(), this::start);
        this.start.field_22763 = false;
        this.selectCPU = this.widgets.addButton("selectCpu", this.getNextCpuButtonLabel(), this::selectNextCpu);
        this.selectCPU.field_22763 = false;
        this.widgets.addButton("cancel", (class_2561)GuiText.Cancel.text(), menu::goBack);
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        ICraftingSubmitResult errorResult = ((CraftConfirmMenu)this.field_2797).submitError.result();
        if (errorResult != null && errorResult.errorCode() != null) {
            this.switchToScreen(new CraftErrorScreen(this, errorResult.errorCode(), errorResult.errorDetail()));
            return;
        }
        this.selectCPU.method_25355(this.getNextCpuButtonLabel());
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.field_2797).getPlan();
        boolean planIsStartable = plan != null && !plan.isSimulation();
        this.start.field_22763 = !((CraftConfirmMenu)this.field_2797).hasNoCPU() && planIsStartable;
        this.selectCPU.field_22763 = planIsStartable;
        class_5250 planDetails = GuiText.CalculatingWait.text();
        class_2561 cpuDetails = class_2585.field_24366;
        if (plan != null) {
            String byteUsed = NumberFormat.getInstance().format(plan.getUsedBytes());
            planDetails = GuiText.BytesUsed.text(byteUsed);
            cpuDetails = plan.isSimulation() ? GuiText.PartialPlan.text() : (((CraftConfirmMenu)this.field_2797).getCpuAvailableBytes() > 0L ? GuiText.ConfirmCraftCpuStatus.text(((CraftConfirmMenu)this.field_2797).getCpuAvailableBytes(), ((CraftConfirmMenu)this.field_2797).getCpuCoProcessors()) : GuiText.ConfirmCraftNoCpu.text());
        }
        this.setTextContent("dialog_title", (class_2561)GuiText.CraftingPlan.text(planDetails));
        this.setTextContent("cpu_status", cpuDetails);
        int size = plan != null ? plan.getEntries().size() : 0;
        this.scrollbar.setRange(0, AbstractTableRenderer.getScrollableRows(size), 1);
    }

    private class_2561 getNextCpuButtonLabel() {
        if (((CraftConfirmMenu)this.field_2797).hasNoCPU()) {
            return GuiText.NoCraftingCPUs.text();
        }
        Object cpuName = ((CraftConfirmMenu)this.field_2797).cpuName == null ? GuiText.Automatic.text() : ((CraftConfirmMenu)this.field_2797).cpuName;
        return GuiText.SelectedCraftingCPU.text(cpuName);
    }

    @Override
    public void drawFG(class_4587 poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        CraftingPlanSummary plan = ((CraftConfirmMenu)this.field_2797).getPlan();
        if (plan != null) {
            this.table.render(poseStack, mouseX, mouseY, plan.getEntries(), this.scrollbar.getCurrentScroll());
        }
    }

    @Override
    @Nullable
    public GenericStack getStackUnderMouse(double mouseX, double mouseY) {
        GenericStack hovered = this.table.getHoveredStack();
        if (hovered != null) {
            return hovered;
        }
        return super.getStackUnderMouse(mouseX, mouseY);
    }

    public boolean method_25404(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (!(this.checkHotbarKeys(class_3675.method_15985((int)keyCode, (int)scanCode)) || keyCode != 257 && keyCode != 335)) {
            this.start();
            return true;
        }
        return super.method_25404(keyCode, scanCode, p_keyPressed_3_);
    }

    private void selectNextCpu() {
        ((CraftConfirmMenu)this.method_17577()).cycleSelectedCPU(!this.isHandlingRightClick());
    }

    private void start() {
        ((CraftConfirmMenu)this.method_17577()).startJob();
    }
}

