/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.crafting.pattern.StonecuttingPatternEncoding;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_3975;

public class AEStonecuttingPattern
implements IPatternDetails,
IMolecularAssemblerSupportedPattern {
    private static final int CRAFTING_GRID_SLOT = 4;
    private final AEItemKey definition;
    public final boolean canSubstitute;
    private final class_3975 recipe;
    private final class_1263 testFrame;
    private final AEItemKey input;
    private final class_1799 output;
    private final IPatternDetails.IInput[] inputs;
    private final GenericStack[] outputs;
    private final Map<class_1792, Boolean> isValidCache = new IdentityHashMap<class_1792, Boolean>();

    public AEStonecuttingPattern(AEItemKey definition, class_1937 level) {
        this.definition = definition;
        class_2487 tag = Objects.requireNonNull(definition.getTag());
        this.input = StonecuttingPatternEncoding.getInput(tag);
        this.canSubstitute = StonecuttingPatternEncoding.canSubstitute(tag);
        class_2960 recipeId = StonecuttingPatternEncoding.getRecipeId(tag);
        this.recipe = (class_3975)level.method_8433().method_17717(class_3956.field_17641).get(recipeId);
        this.testFrame = new class_1277(1);
        this.testFrame.method_5447(0, this.input.toStack());
        if (!this.recipe.method_8115(this.testFrame, level)) {
            throw new IllegalStateException("The recipe " + recipeId + " no longer matches the encoded input.");
        }
        this.output = this.recipe.method_8116(this.testFrame);
        if (this.output.method_7960()) {
            throw new IllegalStateException("The recipe " + recipeId + " produced an empty item stack result.");
        }
        this.inputs = new IPatternDetails.IInput[]{new Input()};
        this.outputs = new GenericStack[]{GenericStack.fromItemStack(this.output)};
    }

    public class_2960 getRecipeId() {
        return this.recipe.method_8114();
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AEStonecuttingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    private class_1856 getRecipeIngredient() {
        return (class_1856)this.recipe.method_8117().get(0);
    }

    public boolean isItemValid(AEItemKey key, class_1937 level) {
        if (key == null) {
            return false;
        }
        if (!this.canSubstitute) {
            return this.input.equals(key);
        }
        Boolean result = this.getTestResult(key);
        if (result != null) {
            return result;
        }
        class_1799 previousStack = this.testFrame.method_5441(0);
        this.testFrame.method_5447(0, key.toStack());
        boolean newResult = this.recipe.method_8115(this.testFrame, level) && class_1799.method_7973((class_1799)this.output, (class_1799)this.recipe.method_8116(this.testFrame));
        this.setTestResult(key, newResult);
        this.testFrame.method_5447(0, previousStack);
        return newResult;
    }

    @Nullable
    private Boolean getTestResult(AEItemKey what) {
        if (what == null || what.hasTag()) {
            return null;
        }
        return this.isValidCache.get(what.getItem());
    }

    private void setTestResult(AEItemKey what, boolean result) {
        if (what != null && !what.hasTag()) {
            this.isValidCache.put(what.getItem(), result);
        }
    }

    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public class_1799 assemble(class_1263 container, class_1937 level) {
        class_1277 testContainer = new class_1277(2);
        testContainer.method_5447(0, container.method_5438(4));
        if (this.recipe.method_8115((class_1263)testContainer, level)) {
            return this.recipe.method_8116((class_1263)testContainer);
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean isItemValid(int slot, AEItemKey key, class_1937 level) {
        return slot == 4 && this.isItemValid(key, level);
    }

    @Override
    public boolean isSlotEnabled(int slot) {
        return slot == 4;
    }

    @Override
    public void fillCraftingGrid(KeyCounter[] table, IMolecularAssemblerSupportedPattern.CraftingGridAccessor gridAccessor) {
        Object object;
        Object2LongMap.Entry<AEKey> entry = table[0].getFirstEntry();
        if (entry != null && (object = entry.getKey()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)object;
            gridAccessor.set(4, itemKey.toStack());
            table[0].remove((AEKey)entry.getKey(), 1L);
        }
    }

    @Override
    public class_2371<class_1799> getRemainingItems(class_1715 container) {
        return class_2371.method_10213((int)container.method_5439(), (Object)class_1799.field_8037);
    }

    public AEItemKey getInput() {
        return this.input;
    }

    private class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] possibleInputs;

        private Input() {
            if (!AEStonecuttingPattern.this.canSubstitute) {
                this.possibleInputs = new GenericStack[]{new GenericStack(AEStonecuttingPattern.this.input, 1L)};
            } else {
                class_1799[] matchingStacks = AEStonecuttingPattern.this.getRecipeIngredient().method_8105();
                this.possibleInputs = new GenericStack[matchingStacks.length + 1];
                this.possibleInputs[0] = new GenericStack(AEStonecuttingPattern.this.input, 1L);
                for (int i = 0; i < matchingStacks.length; ++i) {
                    this.possibleInputs[i + 1] = GenericStack.fromItemStack(matchingStacks[i]);
                }
            }
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.possibleInputs;
        }

        @Override
        public long getMultiplier() {
            return 1L;
        }

        @Override
        public boolean isValid(AEKey input, class_1937 level) {
            if (input.matches(this.possibleInputs[0])) {
                return true;
            }
            if (AEStonecuttingPattern.this.canSubstitute() && input instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)input;
                return AEStonecuttingPattern.this.isItemValid(itemKey, level);
            }
            return false;
        }

        @Override
        @Nullable
        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

