/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.InvalidPatternHelper;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.misc.WrappedGenericStack;
import appeng.util.InteractionUtil;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;

public abstract class EncodedPatternItem
extends AEBaseItem
implements AEToolItem {
    private static final Map<class_1799, class_1799> SIMPLE_CACHE = new WeakHashMap<class_1799, class_1799>();

    public EncodedPatternItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7850(class_1761 creativeModeTab, class_2371<class_1799> nonNullList) {
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        this.clearPattern(player.method_5998(hand), player);
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)player.method_5998(hand));
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return this.clearPattern(stack, context.method_8036()) ? class_1269.method_29236((boolean)context.method_8045().method_8608()) : class_1269.field_5811;
    }

    private boolean clearPattern(class_1799 stack, class_1657 player) {
        if (InteractionUtil.isInAlternateUseMode(player)) {
            if (player.method_5770().method_8608()) {
                return false;
            }
            class_1661 inv = player.method_31548();
            class_1799 is = AEItems.BLANK_PATTERN.stack(stack.method_7947());
            if (!is.method_7960()) {
                for (int s = 0; s < player.method_31548().method_5439(); ++s) {
                    if (inv.method_5438(s) != stack) continue;
                    inv.method_5447(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        boolean isCrafting;
        if (!stack.method_7985()) {
            return;
        }
        IPatternDetails details = this.decode(stack, level, false);
        if (details == null) {
            stack.method_7977((class_2561)GuiText.InvalidPattern.text().method_27661().method_27692(class_124.field_1061));
            InvalidPatternHelper invalid = new InvalidPatternHelper(stack);
            class_5250 label = (invalid.isCraftable() ? GuiText.Crafts.text() : GuiText.Produces.text()).method_27661().method_27693(": ");
            class_5250 and = new class_2585(" ").method_27661().method_10852((class_2561)GuiText.And.text()).method_27661().method_27693(" ");
            class_5250 with = GuiText.With.text().method_27661().method_27693(": ");
            boolean first = true;
            for (InvalidPatternHelper.PatternIngredient output : invalid.getOutputs()) {
                lines.add((class_2561)(first ? label : and).method_27661().method_10852(output.getFormattedToolTip()));
                first = false;
            }
            first = true;
            for (InvalidPatternHelper.PatternIngredient input : invalid.getInputs()) {
                lines.add((class_2561)(first ? with : and).method_27661().method_10852(input.getFormattedToolTip()));
                first = false;
            }
            if (invalid.isCraftable()) {
                class_5250 substitutionLabel = GuiText.Substitute.text().method_27661().method_27693(" ");
                class_5250 canSubstitute = invalid.canSubstitute() ? GuiText.Yes.text() : GuiText.No.text();
                lines.add((class_2561)substitutionLabel.method_27661().method_10852((class_2561)canSubstitute));
            }
            return;
        }
        if (stack.method_7938()) {
            stack.method_7925();
        }
        boolean substitute = (isCrafting = details instanceof AECraftingPattern) && ((AECraftingPattern)details).canSubstitute;
        IPatternDetails.IInput[] in = details.getInputs();
        GenericStack[] out = details.getOutputs();
        class_5250 label = (isCrafting ? GuiText.Crafts.text() : GuiText.Produces.text()).method_27661().method_27693(": ");
        class_5250 and = new class_2585(" ").method_27661().method_10852((class_2561)GuiText.And.text()).method_27693(" ");
        class_5250 with = GuiText.With.text().method_27661().method_27693(": ");
        boolean first = true;
        for (GenericStack anOut : out) {
            if (anOut == null) continue;
            lines.add((class_2561)(first ? label : and).method_27661().method_10852(EncodedPatternItem.getStackComponent(anOut)));
            first = false;
        }
        first = true;
        for (IPatternDetails.IInput anIn : in) {
            if (anIn == null) continue;
            GenericStack primaryInputTemplate = anIn.getPossibleInputs()[0];
            GenericStack primaryInput = new GenericStack(primaryInputTemplate.what(), primaryInputTemplate.amount() * anIn.getMultiplier());
            lines.add((class_2561)(first ? with : and).method_27661().method_10852(EncodedPatternItem.getStackComponent(primaryInput)));
            first = false;
        }
        if (isCrafting) {
            class_5250 substitutionLabel = GuiText.Substitute.text().method_27661().method_27693(" ");
            class_5250 canSubstitute = substitute ? GuiText.Yes.text() : GuiText.No.text();
            lines.add((class_2561)substitutionLabel.method_27661().method_10852((class_2561)canSubstitute));
        }
    }

    protected static class_2561 getStackComponent(GenericStack stack) {
        String amountInfo = stack.what().formatAmount(stack.amount(), AmountFormat.FULL);
        class_2561 displayName = stack.what().getDisplayName();
        return new class_2585(amountInfo + " x ").method_10852(displayName);
    }

    public class_1799 getOutput(class_1799 item) {
        class_1799 out = SIMPLE_CACHE.get(item);
        if (out != null) {
            return out;
        }
        class_1937 level = AppEng.instance().getClientLevel();
        if (level == null) {
            return class_1799.field_8037;
        }
        IPatternDetails details = this.decode(item, level, false);
        out = class_1799.field_8037;
        if (details != null) {
            GenericStack output = details.getPrimaryOutput();
            AEKey aEKey = output.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                out = itemKey.toStack();
            } else {
                out = WrappedGenericStack.wrap(output.what(), 0L);
            }
        }
        SIMPLE_CACHE.put(item, out);
        return out;
    }

    @Nullable
    public abstract IPatternDetails decode(class_1799 var1, class_1937 var2, boolean var3);

    @Nullable
    public abstract IPatternDetails decode(AEItemKey var1, class_1937 var2);
}

