/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.externalstorage;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.MEStorage;
import appeng.core.AELog;
import appeng.util.ConfigMenuInventory;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Reference2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import org.jetbrains.annotations.Nullable;

public class GenericStackInv
implements MEStorage,
GenericInternalInventory {
    protected final GenericStack[] stacks;
    private final Participant[] participants;
    private final Runnable listener;
    private boolean suppressOnChange;
    private boolean onChangeSuppressed;
    private final Reference2LongMap<AEKeyType> capacities = new Reference2LongArrayMap();
    @Nullable
    private AEKeyFilter filter;
    protected final Mode mode;
    private class_2561 description = class_2585.field_24366;

    public GenericStackInv(@javax.annotation.Nullable Runnable listener, int size) {
        this(listener, Mode.STORAGE, size);
    }

    public GenericStackInv(@javax.annotation.Nullable Runnable listener, Mode mode, int size) {
        this.stacks = new GenericStack[size];
        this.participants = new Participant[size];
        this.listener = listener;
        this.mode = mode;
    }

    protected void setFilter(@javax.annotation.Nullable AEKeyFilter filter) {
        this.filter = filter;
    }

    @javax.annotation.Nullable
    public AEKeyFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean isAllowed(AEKey what) {
        return this.filter == null || this.filter.matches(what);
    }

    public boolean isAllowed(@javax.annotation.Nullable GenericStack stack) {
        return stack == null || this.isAllowed(stack.what());
    }

    @Override
    public int size() {
        return this.stacks.length;
    }

    public boolean isEmpty() {
        for (GenericStack stack : this.stacks) {
            if (stack == null) continue;
            return false;
        }
        return true;
    }

    @Override
    @javax.annotation.Nullable
    public GenericStack getStack(int slot) {
        return this.stacks[slot];
    }

    @Override
    @javax.annotation.Nullable
    public AEKey getKey(int slot) {
        return this.stacks[slot] != null ? this.stacks[slot].what() : null;
    }

    @Override
    public long getAmount(int slot) {
        return this.stacks[slot] != null ? this.stacks[slot].amount() : 0L;
    }

    @Override
    public void setStack(int slot, @javax.annotation.Nullable GenericStack stack) {
        if (stack != null && this.getMaxAmount(stack.what()) < stack.amount()) {
            stack = new GenericStack(stack.what(), this.getMaxAmount(stack.what()));
        }
        if (!Objects.equals(this.stacks[slot], stack)) {
            this.stacks[slot] = stack;
            this.onChange();
        }
    }

    @Override
    public long insert(int slot, AEKey what, long amount, Actionable mode) {
        long newAmount;
        Objects.requireNonNull(what, "what");
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"amount >= 0");
        if (!this.canInsert() || !this.isAllowed(what)) {
            return 0L;
        }
        AEKey currentWhat = this.getKey(slot);
        long currentAmount = this.getAmount(slot);
        if ((currentWhat == null || currentWhat.equals(what)) && (newAmount = Math.min(currentAmount + amount, this.getMaxAmount(what))) > currentAmount) {
            if (mode == Actionable.MODULATE) {
                this.setStack(slot, new GenericStack(what, newAmount));
                newAmount = this.getAmount(slot);
            }
            return newAmount - currentAmount;
        }
        return 0L;
    }

    @Override
    public long extract(int slot, AEKey what, long amount, Actionable mode) {
        Objects.requireNonNull(what, "what");
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"amount >= 0");
        AEKey currentWhat = this.getKey(slot);
        if (!this.canExtract() || currentWhat == null || !currentWhat.equals(what)) {
            return 0L;
        }
        long currentAmount = this.getAmount(slot);
        long canExtract = Math.min(currentAmount, amount);
        if (canExtract > 0L && mode == Actionable.MODULATE) {
            long newAmount = currentAmount - canExtract;
            if (newAmount <= 0L) {
                this.setStack(slot, null);
            } else {
                this.setStack(slot, new GenericStack(what, newAmount));
            }
            long reallyExtracted = Math.max(0L, currentAmount - this.getAmount(slot));
            if (reallyExtracted != canExtract) {
                AELog.warn("GenericStackInv simulation/modulation extraction mismatch: canExtract=%d, reallyExtracted=%d", canExtract, reallyExtracted);
                canExtract = reallyExtracted;
            }
        }
        return canExtract;
    }

    @Override
    public long getCapacity(AEKeyType space) {
        return this.capacities.getOrDefault((Object)space, Long.MAX_VALUE);
    }

    @Override
    public boolean canInsert() {
        return true;
    }

    @Override
    public boolean canExtract() {
        return true;
    }

    public void setCapacity(AEKeyType space, long capacity) {
        this.capacities.put((Object)space, capacity);
    }

    public void useRegisteredCapacities() {
        for (Map.Entry<AEKeyType, Long> entry : GenericSlotCapacities.getMap().entrySet()) {
            this.setCapacity(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long getMaxAmount(AEKey key) {
        if (key instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)key;
            return Math.min((long)itemKey.getItem().method_7882(), this.getCapacity(key.getType()));
        }
        return this.getCapacity(key.getType());
    }

    @Override
    public final void onChange() {
        if (!this.suppressOnChange) {
            this.notifyListener();
        } else {
            this.onChangeSuppressed = true;
        }
    }

    protected void notifyListener() {
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public class_2499 writeToTag() {
        class_2499 tag = new class_2499();
        for (GenericStack stack : this.stacks) {
            tag.add((Object)GenericStack.writeTag(stack));
        }
        for (int i = tag.size() - 1; i >= 0 && tag.method_10602(i).method_33133(); --i) {
            tag.method_10536(i);
        }
        return tag;
    }

    public void writeToChildTag(class_2487 tag, String name) {
        boolean isEmpty = true;
        for (GenericStack stack : this.stacks) {
            if (stack == null) continue;
            isEmpty = false;
            break;
        }
        if (!isEmpty) {
            tag.method_10566(name, (class_2520)this.writeToTag());
        } else {
            tag.method_10551(name);
        }
    }

    public void readFromTag(class_2499 tag) {
        int i;
        boolean changed = false;
        for (i = 0; i < Math.min(this.size(), tag.size()); ++i) {
            GenericStack stack = GenericStack.readTag(tag.method_10602(i));
            if (Objects.equals(stack, this.stacks[i])) continue;
            this.stacks[i] = stack;
            changed = true;
        }
        for (i = tag.size(); i < this.size(); ++i) {
            if (this.stacks[i] == null) continue;
            this.stacks[i] = null;
            changed = true;
        }
        if (changed) {
            this.onChange();
        }
    }

    public void clear() {
        boolean changed = false;
        for (int i = 0; i < this.stacks.length; ++i) {
            changed |= this.stacks[i] != null;
            this.stacks[i] = null;
        }
        if (changed) {
            this.onChange();
        }
    }

    public void readFromChildTag(class_2487 tag, String name) {
        if (tag.method_10573(name, 9)) {
            this.readFromTag(tag.method_10554(name, 10));
        } else {
            this.clear();
        }
    }

    @Override
    public void beginBatch() {
        Preconditions.checkState((!this.suppressOnChange ? 1 : 0) != 0, (Object)"beginBatch was called without endBatch");
        this.suppressOnChange = true;
    }

    @Override
    public void endBatch() {
        Preconditions.checkState((boolean)this.suppressOnChange, (Object)"endBatch was called without beginBatch");
        this.suppressOnChange = false;
        if (this.onChangeSuppressed) {
            this.onChangeSuppressed = false;
            this.onChange();
        }
    }

    @Override
    public void endBatchSuppressed() {
        Preconditions.checkState((boolean)this.suppressOnChange, (Object)"endBatch was called without beginBatch");
        this.suppressOnChange = false;
        this.onChangeSuppressed = false;
    }

    public Mode getMode() {
        return this.mode;
    }

    public ConfigMenuInventory createMenuWrapper() {
        return new ConfigMenuInventory(this);
    }

    @Override
    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        Objects.requireNonNull(what, "what");
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"amount >= 0");
        if (!this.isAllowed(what)) {
            return 0L;
        }
        if (this.mode == Mode.CONFIG_TYPES) {
            int freeSlot = -1;
            for (int i = 0; i < this.stacks.length; ++i) {
                AEKey key = this.getKey(i);
                if (key == what) {
                    return 0L;
                }
                if (key != null || freeSlot != -1) continue;
                freeSlot = i;
            }
            if (freeSlot != -1 && mode == Actionable.MODULATE) {
                this.setStack(freeSlot, new GenericStack(what, 0L));
            }
            return 0L;
        }
        long inserted = 0L;
        for (int i = 0; i < this.stacks.length && inserted < amount; inserted += this.insert(i, what, amount - inserted, mode), ++i) {
        }
        return inserted;
    }

    @Override
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        Objects.requireNonNull(what, "what");
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"amount >= 0");
        long extracted = 0L;
        for (int i = 0; i < this.stacks.length && extracted < amount; extracted += this.extract(i, what, amount - extracted, mode), ++i) {
        }
        return extracted;
    }

    @Override
    public void getAvailableStacks(KeyCounter out) {
        for (GenericStack stack : this.stacks) {
            if (stack == null) continue;
            out.add(stack.what(), stack.amount());
        }
    }

    @Override
    public class_2561 getDescription() {
        return this.description;
    }

    public void setDescription(class_2561 description) {
        this.description = description;
    }

    @Override
    public void updateSnapshots(int slot, TransactionContext transaction) {
        if (this.participants[slot] == null) {
            this.participants[slot] = new Participant(slot);
        }
        this.participants[slot].updateSnapshots(transaction);
    }

    public static enum Mode {
        CONFIG_TYPES,
        CONFIG_STACKS,
        STORAGE;

    }

    private class Participant
    extends SnapshotParticipant<GenericStack> {
        private static final GenericStack EMPTY_STACK = new GenericStack(AEItemKey.of((class_1935)class_1802.field_8162), 0L);
        private final int slotIndex;

        private Participant(int slotIndex) {
            this.slotIndex = slotIndex;
        }

        protected GenericStack createSnapshot() {
            GenericStack stack = GenericStackInv.this.getStack(this.slotIndex);
            return stack != null ? stack : EMPTY_STACK;
        }

        protected void readSnapshot(GenericStack snapshot) {
            GenericStackInv.this.beginBatch();
            if (snapshot == EMPTY_STACK) {
                GenericStackInv.this.setStack(this.slotIndex, null);
            } else {
                GenericStackInv.this.setStack(this.slotIndex, snapshot);
            }
            GenericStackInv.this.endBatchSuppressed();
        }

        protected void onFinalCommit() {
            GenericStackInv.this.onChange();
        }
    }
}

