/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.IConfigManager;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.helpers.iface.PatternProviderReturnInventory;
import appeng.helpers.iface.PatternProviderTarget;
import appeng.helpers.iface.PatternProviderTargetCache;
import appeng.helpers.iface.UnlockCraftingEvent;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.PlayerInternalInventory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1275;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternProviderLogic
implements InternalInventoryHost,
ICraftingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternProviderLogic.class);
    public static final int NUMBER_OF_PATTERN_SLOTS = 9;
    public static final String NBT_MEMORY_CARD_PATTERNS = "patterns";
    public static final String NBT_UNLOCK_EVENT = "unlockEvent";
    public static final String NBT_UNLOCK_STACK = "unlockStack";
    public static final String NBT_PRIORITY = "priority";
    public static final String NBT_SEND_LIST = "sendList";
    public static final String NBT_SEND_DIRECTION = "sendDirection";
    public static final String NBT_RETURN_INV = "returnInv";
    private final PatternProviderLogicHost host;
    private final IManagedGridNode mainNode;
    private final IActionSource actionSource;
    private final ConfigManager configManager = new ConfigManager(this::configChanged);
    private int priority;
    private final AppEngInternalInventory patternInventory = new AppEngInternalInventory(this, 9);
    private final List<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
    private final Set<AEKey> patternInputs = new HashSet<AEKey>();
    private final List<GenericStack> sendList = new ArrayList<GenericStack>();
    private class_2350 sendDirection;
    private final PatternProviderReturnInventory returnInv;
    private final PatternProviderTargetCache[] targetCaches = new PatternProviderTargetCache[6];
    private YesNo redstoneState = YesNo.UNDECIDED;
    @Nullable
    private UnlockCraftingEvent unlockEvent;
    @Nullable
    private GenericStack unlockStack;
    private static final Collection<class_2248> BAD_BLOCKS = new HashSet<class_2248>(100);

    public @Nullable PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host) {
        this.host = host;
        this.mainNode = mainNode.setFlags(GridFlags.REQUIRE_CHANNEL).addService(IGridTickable.class, new Ticker()).addService(ICraftingProvider.class, this);
        this.actionSource = new MachineSource(mainNode::getNode);
        this.configManager.registerSetting(Settings.BLOCKING_MODE, YesNo.NO);
        this.configManager.registerSetting(Settings.PATTERN_ACCESS_TERMINAL, YesNo.YES);
        this.configManager.registerSetting(Settings.LOCK_CRAFTING_MODE, LockCraftingMode.NONE);
        this.returnInv = new PatternProviderReturnInventory(() -> this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node)));
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.host.saveChanges();
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    public void writeToNBT(class_2487 tag) {
        this.configManager.writeToNBT(tag);
        this.patternInventory.writeToNBT(tag, NBT_MEMORY_CARD_PATTERNS);
        tag.method_10569(NBT_PRIORITY, this.priority);
        if (this.unlockEvent == UnlockCraftingEvent.PULSE) {
            tag.method_10567(NBT_UNLOCK_EVENT, (byte)1);
        } else if (this.unlockEvent == UnlockCraftingEvent.RESULT) {
            if (this.unlockStack != null) {
                tag.method_10567(NBT_UNLOCK_EVENT, (byte)2);
                tag.method_10566(NBT_UNLOCK_STACK, (class_2520)GenericStack.writeTag(this.unlockStack));
            } else {
                LOGGER.error("Saving pattern provider {}, locked waiting for stack, but stack is null!", (Object)this.host);
            }
        }
        class_2499 sendListTag = new class_2499();
        for (GenericStack toSend : this.sendList) {
            sendListTag.add((Object)GenericStack.writeTag(toSend));
        }
        tag.method_10566(NBT_SEND_LIST, (class_2520)sendListTag);
        if (this.sendDirection != null) {
            tag.method_10567(NBT_SEND_DIRECTION, (byte)this.sendDirection.method_10146());
        }
        tag.method_10566(NBT_RETURN_INV, (class_2520)this.returnInv.writeToTag());
    }

    public void readFromNBT(class_2487 tag) {
        this.configManager.readFromNBT(tag);
        this.patternInventory.readFromNBT(tag, NBT_MEMORY_CARD_PATTERNS);
        this.priority = tag.method_10550(NBT_PRIORITY);
        byte unlockEventType = tag.method_10571(NBT_UNLOCK_EVENT);
        switch (unlockEventType) {
            case 0: {
                UnlockCraftingEvent unlockCraftingEvent = null;
                break;
            }
            case 1: {
                UnlockCraftingEvent unlockCraftingEvent = UnlockCraftingEvent.PULSE;
                break;
            }
            case 2: {
                UnlockCraftingEvent unlockCraftingEvent = UnlockCraftingEvent.RESULT;
                break;
            }
            default: {
                LOGGER.error("Unknown unlock event type {} in NBT for pattern provider: {}", (Object)unlockEventType, (Object)tag);
                UnlockCraftingEvent unlockCraftingEvent = this.unlockEvent = null;
            }
        }
        if (this.unlockEvent == UnlockCraftingEvent.RESULT) {
            this.unlockStack = GenericStack.readTag(tag.method_10562(NBT_UNLOCK_STACK));
            if (this.unlockStack == null) {
                LOGGER.error("Could not load unlock stack for pattern provider from NBT: {}", (Object)tag);
            }
        } else {
            this.unlockStack = null;
        }
        class_2499 sendListTag = tag.method_10554(NBT_SEND_LIST, 10);
        for (int i = 0; i < sendListTag.size(); ++i) {
            GenericStack stack = GenericStack.readTag(sendListTag.method_10602(i));
            if (stack == null) continue;
            this.addToSendList(stack.what(), stack.amount());
        }
        if (tag.method_10545(NBT_SEND_DIRECTION)) {
            this.sendDirection = class_2350.method_10143((int)tag.method_10571(NBT_SEND_DIRECTION));
        }
        this.returnInv.readFromTag(tag.method_10554(NBT_RETURN_INV, 10));
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public void saveChanges() {
        this.host.saveChanges();
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
        this.updatePatterns();
    }

    @Override
    public boolean isClientSide() {
        class_1937 level = this.host.getBlockEntity().method_10997();
        return level == null || level.method_8608();
    }

    public void updatePatterns() {
        this.patterns.clear();
        this.patternInputs.clear();
        for (class_1799 stack : this.patternInventory) {
            IPatternDetails details = PatternDetailsHelper.decodePattern(stack, this.host.getBlockEntity().method_10997());
            if (details == null) continue;
            this.patterns.add(details);
            for (IPatternDetails.IInput iinput : details.getInputs()) {
                for (GenericStack inputCandidate : iinput.getPossibleInputs()) {
                    this.patternInputs.add(inputCandidate.what().dropSecondary());
                }
            }
        }
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    @Override
    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    @Override
    public int getPatternPriority() {
        return this.priority;
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.sendList.isEmpty() && this.mainNode.isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        class_2586 be = this.host.getBlockEntity();
        class_1937 level = be.method_10997();
        if (this.getCraftingLockedReason() != LockCraftingMode.NONE) {
            return false;
        }
        for (class_2350 direction : this.host.getTargets()) {
            PatternProviderLogicHost adjHost;
            class_2338 adjPos = be.method_11016().method_10093(direction);
            class_2586 adjBe = level.method_8321(adjPos);
            class_2350 adjBeSide = direction.method_10153();
            if (adjBe instanceof PatternProviderLogicHost && (adjHost = (PatternProviderLogicHost)adjBe).getLogic().sameGrid(this.mainNode.getGrid())) continue;
            ICraftingMachine craftingMachine = ICraftingMachine.of(adjBe, adjBeSide);
            if (craftingMachine != null && craftingMachine.acceptsPlans()) {
                if (!craftingMachine.pushPattern(patternDetails, inputHolder, adjBeSide)) continue;
                this.onPushPatternSuccess(patternDetails);
                return true;
            }
            PatternProviderTarget adapter = this.findAdapter(direction);
            if (adapter == null || this.isBlocking() && adapter.containsPatternInput(this.patternInputs) || !this.adapterAcceptsAll(adapter, inputHolder)) continue;
            for (KeyCounter inputList : inputHolder) {
                for (Object2LongMap.Entry<AEKey> input : inputList) {
                    long amount;
                    AEKey what = (AEKey)input.getKey();
                    long inserted = adapter.insert(what, amount = input.getLongValue(), Actionable.MODULATE);
                    if (inserted >= amount) continue;
                    this.addToSendList(what, amount - inserted);
                }
            }
            this.onPushPatternSuccess(patternDetails);
            this.sendDirection = direction;
            this.sendStacksOut();
            return true;
        }
        return false;
    }

    public void resetCraftingLock() {
        if (this.unlockEvent != null) {
            this.unlockEvent = null;
            this.unlockStack = null;
            this.saveChanges();
        }
    }

    private void onPushPatternSuccess(IPatternDetails pattern) {
        this.resetCraftingLock();
        LockCraftingMode lockMode = this.configManager.getSetting(Settings.LOCK_CRAFTING_MODE);
        switch (lockMode) {
            case LOCK_UNTIL_PULSE: {
                this.unlockEvent = UnlockCraftingEvent.PULSE;
                this.saveChanges();
                break;
            }
            case LOCK_UNTIL_RESULT: {
                this.unlockEvent = UnlockCraftingEvent.RESULT;
                this.unlockStack = pattern.getPrimaryOutput();
                this.saveChanges();
            }
        }
    }

    public LockCraftingMode getCraftingLockedReason() {
        LockCraftingMode lockMode = this.configManager.getSetting(Settings.LOCK_CRAFTING_MODE);
        if (lockMode == LockCraftingMode.LOCK_WHILE_LOW && !this.getRedstoneState()) {
            return LockCraftingMode.LOCK_WHILE_LOW;
        }
        if (lockMode == LockCraftingMode.LOCK_WHILE_HIGH && this.getRedstoneState()) {
            return LockCraftingMode.LOCK_WHILE_HIGH;
        }
        if (this.unlockEvent != null) {
            switch (this.unlockEvent) {
                case PULSE: {
                    return LockCraftingMode.LOCK_UNTIL_PULSE;
                }
                case RESULT: {
                    return LockCraftingMode.LOCK_UNTIL_RESULT;
                }
            }
        }
        return LockCraftingMode.NONE;
    }

    @Nullable
    public GenericStack getUnlockStack() {
        return this.unlockStack;
    }

    private boolean sameGrid(@Nullable IGrid grid) {
        return grid != null && grid == this.mainNode.getGrid();
    }

    public boolean isBlocking() {
        return this.configManager.getSetting(Settings.BLOCKING_MODE) == YesNo.YES;
    }

    @Nullable
    private PatternProviderTarget findAdapter(class_2350 side) {
        if (this.targetCaches[side.method_10146()] == null) {
            class_2586 thisBe = this.host.getBlockEntity();
            this.targetCaches[side.method_10146()] = new PatternProviderTargetCache((class_3218)thisBe.method_10997(), thisBe.method_11016().method_10093(side), side.method_10153(), this.actionSource);
        }
        return this.targetCaches[side.method_10146()].find();
    }

    private boolean adapterAcceptsAll(PatternProviderTarget target, KeyCounter[] inputHolder) {
        for (KeyCounter inputList : inputHolder) {
            for (Object2LongMap.Entry<AEKey> input : inputList) {
                long inserted = target.insert((AEKey)input.getKey(), input.getLongValue(), Actionable.SIMULATE);
                if (inserted != 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void addToSendList(AEKey what, long amount) {
        if (amount > 0L) {
            this.sendList.add(new GenericStack(what, amount));
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    private boolean sendStacksOut() {
        if (this.sendDirection == null) {
            if (!this.sendList.isEmpty()) {
                throw new IllegalStateException("Invalid pattern provider state, this is a bug.");
            }
            return false;
        }
        PatternProviderTarget adapter = this.findAdapter(this.sendDirection);
        if (adapter == null) {
            return false;
        }
        boolean didSomething = false;
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            long amount;
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long inserted = adapter.insert(what, amount = stack.amount(), Actionable.MODULATE);
            if (inserted >= amount) {
                it.remove();
                didSomething = true;
                continue;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            didSomething = true;
        }
        if (this.sendList.isEmpty()) {
            this.sendDirection = null;
        }
        return didSomething;
    }

    @Override
    public boolean isBusy() {
        return !this.sendList.isEmpty();
    }

    private boolean hasWorkToDo() {
        return !this.sendList.isEmpty() || !this.returnInv.isEmpty();
    }

    private boolean doWork() {
        return this.returnInv.injectIntoNetwork(this.mainNode.getGrid().getStorageService().getInventory(), this.actionSource, this::onStackReturnedToNetwork) | this.sendStacksOut();
    }

    public InternalInventory getPatternInv() {
        return this.patternInventory;
    }

    public void onMainNodeStateChanged() {
        if (this.mainNode.isActive()) {
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    public void addDrops(List<class_1799> drops) {
        for (class_1799 class_17992 : this.patternInventory) {
            drops.add(class_17992);
        }
        for (GenericStack genericStack : this.sendList) {
            genericStack.what().addDrops(genericStack.amount(), drops, this.host.getBlockEntity().method_10997(), this.host.getBlockEntity().method_11016());
        }
        this.returnInv.addDrops(drops, this.host.getBlockEntity().method_10997(), this.host.getBlockEntity().method_11016());
    }

    public PatternProviderReturnInventory getReturnInv() {
        return this.returnInv;
    }

    public void exportSettings(class_2487 output) {
        this.patternInventory.writeToNBT(output, NBT_MEMORY_CARD_PATTERNS);
    }

    public void importSettings(class_2487 input, @Nullable class_1657 player) {
        if (player != null && input.method_10545(NBT_MEMORY_CARD_PATTERNS) && !player.field_6002.field_9236) {
            this.clearPatternInventory(player);
            AppEngInternalInventory desiredPatterns = new AppEngInternalInventory(this.patternInventory.size());
            desiredPatterns.readFromNBT(input, NBT_MEMORY_CARD_PATTERNS);
            class_1661 playerInv = player.method_31548();
            int blankPatternsAvailable = player.method_31549().field_7477 ? Integer.MAX_VALUE : playerInv.method_18861((class_1792)AEItems.BLANK_PATTERN.method_8389());
            int blankPatternsUsed = 0;
            for (int i = 0; i < desiredPatterns.size(); ++i) {
                IPatternDetails pattern = PatternDetailsHelper.decodePattern(desiredPatterns.getStackInSlot(i), this.host.getBlockEntity().method_10997(), true);
                if (pattern == null || blankPatternsAvailable < ++blankPatternsUsed || this.patternInventory.addItems(pattern.getDefinition().toStack()).method_7960()) continue;
                AELog.warn("Failed to add pattern to pattern provider", new Object[0]);
                --blankPatternsUsed;
            }
            if (blankPatternsUsed > 0 && !player.method_31549().field_7477) {
                new PlayerInternalInventory(playerInv).removeItems(blankPatternsUsed, AEItems.BLANK_PATTERN.stack(), null);
            }
            if (blankPatternsUsed > blankPatternsAvailable) {
                player.method_9203((class_2561)PlayerMessages.MissingBlankPatterns.text(blankPatternsUsed - blankPatternsAvailable), class_156.field_25140);
            }
        }
    }

    private void clearPatternInventory(class_1657 player) {
        if (player.method_31549().field_7477) {
            for (int i = 0; i < this.patternInventory.size(); ++i) {
                this.patternInventory.setItemDirect(i, class_1799.field_8037);
            }
            return;
        }
        class_1661 playerInv = player.method_31548();
        int blankPatternCount = 0;
        for (int i = 0; i < this.patternInventory.size(); ++i) {
            class_1799 pattern = this.patternInventory.getStackInSlot(i);
            if (pattern.method_31574((class_1792)AEItems.CRAFTING_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.PROCESSING_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.SMITHING_TABLE_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.STONECUTTING_PATTERN.method_8389()) || pattern.method_31574((class_1792)AEItems.BLANK_PATTERN.method_8389())) {
                blankPatternCount += pattern.method_7947();
            } else {
                playerInv.method_7398(pattern);
            }
            this.patternInventory.setItemDirect(i, class_1799.field_8037);
        }
        if (blankPatternCount > 0) {
            playerInv.method_32338(AEItems.BLANK_PATTERN.stack(blankPatternCount), false);
        }
    }

    private void onStackReturnedToNetwork(GenericStack genericStack) {
        if (this.unlockEvent != UnlockCraftingEvent.RESULT) {
            return;
        }
        if (this.unlockStack == null) {
            LOGGER.error("pattern provider was waiting for RESULT, but no result was set");
            this.unlockEvent = null;
        } else if (this.unlockStack.what().equals(genericStack.what())) {
            long remainingAmount = this.unlockStack.amount() - genericStack.amount();
            if (remainingAmount <= 0L) {
                this.unlockEvent = null;
                this.unlockStack = null;
            } else {
                this.unlockStack = new GenericStack(this.unlockStack.what(), remainingAmount);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public class_2561 getTermName() {
        class_2248 directedBlock;
        ICustomNameObject customNameObject;
        class_2586 host = this.host.getBlockEntity();
        class_1937 hostWorld = host.method_10997();
        PatternProviderLogicHost patternProviderLogicHost = this.host;
        if (patternProviderLogicHost instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)((Object)patternProviderLogicHost)).hasCustomInventoryName()) {
            return customNameObject.getCustomInventoryName();
        }
        Iterator iterator = this.host.getTargets().iterator();
        while (true) {
            Optional<class_2561> displayName;
            class_1275 nameable;
            PatternProviderLogicHost interfaceHost;
            if (!iterator.hasNext()) {
                return new class_2585("Nothing");
            }
            class_2350 direction = (class_2350)iterator.next();
            class_2338 targ = host.method_11016().method_10093(direction);
            class_2586 directedBlockEntity = hostWorld.method_8321(targ);
            if (directedBlockEntity == null || directedBlockEntity instanceof PatternProviderLogicHost && (interfaceHost = (PatternProviderLogicHost)directedBlockEntity).getLogic().sameGrid(this.mainNode.getGrid())) continue;
            if (directedBlockEntity instanceof class_1275 && (nameable = (class_1275)directedBlockEntity).method_16914()) {
                return nameable.method_5797();
            }
            ICraftingMachine craftingMachine = ICraftingMachine.of(directedBlockEntity, direction.method_10153());
            if (craftingMachine != null && (displayName = craftingMachine.getDisplayName()).isPresent()) {
                return displayName.get();
            }
            ItemTransfer adaptor = InternalInventory.wrapExternal(directedBlockEntity, direction.method_10153());
            if (adaptor == null || !adaptor.mayAllowTransfer()) continue;
            class_2680 directedBlockState = hostWorld.method_8320(targ);
            directedBlock = directedBlockState.method_26204();
            class_1799 what = new class_1799((class_1935)directedBlock, 1);
            try {
                class_243 from = new class_243((double)host.method_11016().method_10263() + 0.5, (double)host.method_11016().method_10264() + 0.5, (double)host.method_11016().method_10260() + 0.5);
                from = from.method_1031((double)direction.method_10148() * 0.501, (double)direction.method_10164() * 0.501, (double)direction.method_10165() * 0.501);
                class_243 to = from.method_1031((double)direction.method_10148(), (double)direction.method_10164(), (double)direction.method_10165());
                Object hit = null;
                if (hit != null && !BAD_BLOCKS.contains(directedBlock) && !hit.method_17777().equals((Object)directedBlockEntity.method_11016())) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.method_7909() != class_1802.field_8162) {
                return new class_2588(what.method_7922());
            }
            class_1792 item = class_1792.method_7867((class_2248)directedBlock);
            if (item == class_1802.field_8162) break;
        }
        return new class_2588(directedBlock.method_9539());
    }

    public long getSortValue() {
        class_2586 te = this.host.getBlockEntity();
        return te.method_11016().method_10260() << 24 ^ te.method_11016().method_10263() << 8 ^ te.method_11016().method_10264();
    }

    @Nullable
    public IGrid getGrid() {
        return this.mainNode.getGrid();
    }

    public void updateRedstoneState() {
        if (this.unlockEvent == UnlockCraftingEvent.PULSE && this.getRedstoneState()) {
            this.unlockEvent = null;
            this.saveChanges();
        } else {
            this.redstoneState = YesNo.UNDECIDED;
        }
    }

    private void configChanged(IConfigManager manager, Setting<?> setting) {
        if (setting == Settings.LOCK_CRAFTING_MODE) {
            this.resetCraftingLock();
        } else {
            this.saveChanges();
        }
    }

    private boolean getRedstoneState() {
        if (this.redstoneState == YesNo.UNDECIDED) {
            class_2586 be = this.host.getBlockEntity();
            this.redstoneState = be.method_10997().method_8479(be.method_11016()) ? YesNo.YES : YesNo.NO;
        }
        return this.redstoneState == YesNo.YES;
    }

    private class Ticker
    implements IGridTickable {
        private Ticker() {
        }

        @Override
        public TickingRequest getTickingRequest(IGridNode node) {
            return new TickingRequest(TickRates.Interface, !PatternProviderLogic.this.hasWorkToDo(), true);
        }

        @Override
        public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
            if (!PatternProviderLogic.this.mainNode.isActive()) {
                return TickRateModulation.SLEEP;
            }
            boolean couldDoWork = PatternProviderLogic.this.doWork();
            return PatternProviderLogic.this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
        }
    }
}

