/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.block.AEBaseBlock;
import appeng.client.render.crafting.MonitorBakedModel;
import appeng.client.render.model.AutoRotatingBakedModel;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.hooks.ModelsReloadCallback;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;

public final class InitAutoRotatingModel {
    private static final Set<BlockDefinition<?>> NO_AUTO_ROTATION = ImmutableSet.of(AEBlocks.CABLE_BUS, AEBlocks.CONTROLLER, AEBlocks.PAINT, AEBlocks.QUANTUM_LINK, AEBlocks.QUANTUM_RING, AEBlocks.CRAFTING_UNIT, (Object[])new BlockDefinition[]{AEBlocks.CRAFTING_ACCELERATOR, AEBlocks.CRAFTING_MONITOR, AEBlocks.CRAFTING_STORAGE_1K, AEBlocks.CRAFTING_STORAGE_4K, AEBlocks.CRAFTING_STORAGE_16K, AEBlocks.CRAFTING_STORAGE_64K, AEBlocks.CRAFTING_STORAGE_256K});
    private static final Map<String, Function<class_1087, class_1087>> CUSTOMIZERS = new HashMap<String, Function<class_1087, class_1087>>();

    private InitAutoRotatingModel() {
    }

    public static void init() {
        InitAutoRotatingModel.register(AEBlocks.CRAFTING_MONITOR, InitAutoRotatingModel::customizeCraftingMonitorModel);
        for (BlockDefinition<?> block : AEBlocks.getBlocks()) {
            if (NO_AUTO_ROTATION.contains(block) || !(block.block() instanceof AEBaseBlock)) continue;
            InitAutoRotatingModel.register(block, AutoRotatingBakedModel::new);
        }
        ModelsReloadCallback.EVENT.register(InitAutoRotatingModel::onModelBake);
    }

    private static void register(BlockDefinition<?> block, Function<class_1087, class_1087> customizer) {
        String path = block.id().method_12832();
        CUSTOMIZERS.put(path, customizer);
    }

    private static class_1087 customizeCraftingMonitorModel(class_1087 model) {
        if (model instanceof MonitorBakedModel) {
            return model;
        }
        return new AutoRotatingBakedModel(model);
    }

    private static void onModelBake(Map<class_2960, class_1087> modelRegistry) {
        HashSet keys = Sets.newHashSet(modelRegistry.keySet());
        class_1087 missingModel = modelRegistry.get(class_1088.field_5374);
        for (class_2960 location : keys) {
            class_1087 newModel;
            Function<class_1087, class_1087> customizer;
            class_1087 orgModel;
            if (!location.method_12836().equals("ae2") || (orgModel = modelRegistry.get(location)) == missingModel || (customizer = CUSTOMIZERS.get(location.method_12832())) == null || (newModel = customizer.apply(orgModel)) == orgModel) continue;
            modelRegistry.put(location, newModel);
        }
    }
}

