/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.worldgen;

import appeng.api.features.AEWorldGen;
import appeng.api.features.AEWorldGenType;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.init.worldgen.WorldgenIds;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public final class InitBiomeModifications {
    private InitBiomeModifications() {
    }

    public static void init() {
        if (AEConfig.instance().isGenerateQuartzOre()) {
            BiomeModifications.addFeature(InitBiomeModifications.shouldGenerateIn(AEWorldGenType.CERTUS_QUARTZ), (class_2893.class_2895)class_2893.class_2895.field_13176, WorldgenIds.PLACED_QUARTZ_ORE_KEY);
        }
    }

    private static Predicate<BiomeSelectionContext> shouldGenerateIn(AEWorldGenType type) {
        return context -> {
            class_2960 id = context.getBiomeKey().method_29177();
            class_1959.class_1961 category = class_1959.method_40136((class_6880)context.getBiomeRegistryEntry());
            if (category == class_1959.class_1961.field_9360 || category == class_1959.class_1961.field_9366 || category == class_1959.class_1961.field_9371) {
                AELog.debug("Not generating %s in %s because it's of category %s", new Object[]{type, id, category});
                return false;
            }
            if (AEWorldGen.isWorldGenDisabledForBiome(type, id)) {
                AELog.debug("Not generating %s in %s because the biome is blacklisted by another mod or the config", new Object[]{type, id});
                return false;
            }
            return true;
        };
    }
}

