/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.blocks;

import appeng.api.client.AEStackRendering;
import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.InGameTooltip;
import appeng.helpers.iface.PatternProviderLogic;
import appeng.helpers.iface.PatternProviderLogicHost;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public final class PatternProviderDataProvider
implements BodyProvider<PatternProviderLogicHost>,
ServerDataProvider<PatternProviderLogicHost> {
    private static final String NBT_LOCK_REASON = "craftingLockReason";

    @Override
    public void buildTooltip(PatternProviderLogicHost host, TooltipContext context, TooltipBuilder tooltip) {
        String lockReason = context.serverData().method_10558(NBT_LOCK_REASON);
        if (!lockReason.isEmpty()) {
            tooltip.addLine((class_2561)class_2561.class_2562.method_10877((String)lockReason));
        }
    }

    @Override
    public void provideServerData(class_3222 player, PatternProviderLogicHost host, class_2487 serverData) {
        PatternProviderLogic logic = host.getLogic();
        class_5250 reason = null;
        switch (logic.getCraftingLockedReason()) {
            case LOCK_UNTIL_PULSE: {
                reason = InGameTooltip.CraftingLockedUntilPulse.text();
                break;
            }
            case LOCK_WHILE_HIGH: {
                reason = InGameTooltip.CraftingLockedByRedstoneSignal.text();
                break;
            }
            case LOCK_WHILE_LOW: {
                reason = InGameTooltip.CraftingLockedByLackOfRedstoneSignal.text();
                break;
            }
            case LOCK_UNTIL_RESULT: {
                class_2585 stackAmount;
                class_2561 stackName;
                GenericStack stack = logic.getUnlockStack();
                if (stack != null) {
                    stackName = AEStackRendering.getDisplayName(stack.what());
                    stackAmount = new class_2585(stack.what().formatAmount(stack.amount(), AmountFormat.FULL));
                } else {
                    stackName = new class_2585("ERROR");
                    stackAmount = new class_2585("ERROR");
                }
                reason = InGameTooltip.CraftingLockedUntilResult.text(stackName, stackAmount);
            }
        }
        if (reason != null) {
            serverData.method_10582(NBT_LOCK_REASON, class_2561.class_2562.method_10867((class_2561)reason.method_27661().method_27692(class_124.field_1061)));
        }
    }
}

