/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.igtooltip.blocks;

import appeng.api.integrations.igtooltip.TooltipBuilder;
import appeng.api.integrations.igtooltip.TooltipContext;
import appeng.api.integrations.igtooltip.providers.BodyProvider;
import appeng.api.integrations.igtooltip.providers.ServerDataProvider;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.core.localization.InGameTooltip;
import appeng.util.Platform;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public final class PowerStorageDataProvider
implements BodyProvider<class_2586>,
ServerDataProvider<class_2586> {
    private static final String TAG_CURRENT_POWER = "currentPower";
    private static final String TAG_MAX_POWER = "maxPower";

    @Override
    public void buildTooltip(class_2586 object, TooltipContext context, TooltipBuilder tooltip) {
        class_2487 tag = context.serverData();
        if (tag.method_10573(TAG_MAX_POWER, 6)) {
            double currentPower = tag.method_10574(TAG_CURRENT_POWER);
            double maxPower = tag.method_10574(TAG_MAX_POWER);
            String formatCurrentPower = Platform.formatPower(currentPower, false);
            String formatMaxPower = Platform.formatPower(maxPower, false);
            tooltip.addLine((class_2561)InGameTooltip.Stored.text(formatCurrentPower, formatMaxPower));
        }
    }

    @Override
    public void provideServerData(class_3222 player, class_2586 object, class_2487 serverData) {
        IAEPowerStorage storage;
        if (object instanceof IAEPowerStorage && (storage = (IAEPowerStorage)object).getAEMaxPower() > 0.0) {
            serverData.method_10549(TAG_CURRENT_POWER, storage.getAECurrentPower());
            serverData.method_10549(TAG_MAX_POWER, storage.getAEMaxPower());
        }
    }
}

