/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.FillCraftingGridFromRecipePacket;
import appeng.integration.modules.jeirei.EncodingHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.util.CraftingRecipeUtil;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public final class CraftingHelper {
    private static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::getStoredAmount);

    private CraftingHelper() {
    }

    public static void performTransfer(CraftingTermMenu menu, class_1860<?> recipe, boolean craftMissing) {
        class_2371<class_1799> templateItems = CraftingHelper.findGoodTemplateItems(recipe, menu);
        class_2960 recipeId = recipe.method_8114();
        if (menu.getPlayer().field_6002.method_8433().method_8130(recipe.method_8114()).isEmpty()) {
            AELog.debug("Cannot send recipe id %s to server because it's transient", recipeId);
            recipeId = null;
        }
        NetworkHandler.instance().sendToServer(new FillCraftingGridFromRecipePacket(recipeId, templateItems, craftMissing));
    }

    private static class_2371<class_1799> findGoodTemplateItems(class_1860<?> recipe, MEStorageMenu menu) {
        Map<AEKey, Integer> ingredientPriorities = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        class_2371 templateItems = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
        class_2371<class_1856> ingredients = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) continue;
            class_1799 stack = ingredientPriorities.entrySet().stream().filter(e -> {
                AEItemKey itemKey;
                Object patt2466$temp = e.getKey();
                return patt2466$temp instanceof AEItemKey && ingredient.method_8093((itemKey = (AEItemKey)patt2466$temp).toStack());
            }).max(Comparator.comparingInt(Map.Entry::getValue)).map(e -> ((AEItemKey)e.getKey()).toStack()).orElse(ingredient.method_8105()[0]);
            templateItems.set(i, (Object)stack);
        }
        return templateItems;
    }
}

