/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.client.gui.style.Blitter;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.rei.EntropyManipulatorDisplay;
import appeng.integration.modules.rei.ReiPlugin;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class EntropyManipulatorCategory
implements DisplayCategory<EntropyManipulatorDisplay> {
    public static final CategoryIdentifier<EntropyManipulatorDisplay> ID = CategoryIdentifier.of((class_2960)AppEng.makeId("entropy"));
    private final Blitter icon = Blitter.texture("item/entropy_manipulator.png", 16, 16).src(0, 0, 16, 16);
    private final Widget blockDestroyOverlay = Widgets.createTexturedWidget((class_2960)ReiPlugin.TEXTURE, (int)0, (int)0, (float)0.0f, (float)52.0f, (int)16, (int)16);
    private final Widget iconHeat = Widgets.createTexturedWidget((class_2960)ReiPlugin.TEXTURE, (int)0, (int)0, (float)0.0f, (float)68.0f, (int)6, (int)6);
    private final Widget iconCool = Widgets.createTexturedWidget((class_2960)ReiPlugin.TEXTURE, (int)0, (int)0, (float)6.0f, (float)68.0f, (int)6, (int)6);
    private final int centerX;

    public EntropyManipulatorCategory() {
        this.centerX = 65;
    }

    private void setFluidOrBlockSlot(Slot slot, class_2248 block, class_3611 fluid) {
        if (fluid != null) {
            if (!fluid.method_15793(fluid.method_15785())) {
                if (fluid instanceof class_3609) {
                    class_3609 flowingFluid = (class_3609)fluid;
                    EntropyManipulatorCategory.addFluidStack(slot, flowingFluid.method_15751());
                } else {
                    EntropyManipulatorCategory.addFluidStack(slot, fluid);
                    AELog.warn("Don't know how to get the source fluid for %s", fluid);
                }
                for (EntryStack entry : slot.getEntries()) {
                    ClientEntryStacks.setTooltipProcessor((EntryStack)entry, (entryStack, tooltip) -> {
                        List entries = tooltip.entries();
                        Stream lines = Streams.concat((Stream[])new Stream[]{Stream.of(Tooltip.entry((class_2561)ItemModText.FLOWING_FLUID_NAME.text(((Tooltip.Entry)entries.get(0)).getAsText()))), entries.stream().skip(1L)});
                        return Tooltip.from((Point)new Point(tooltip.getX(), tooltip.getY()), lines.toList());
                    });
                }
            } else {
                EntropyManipulatorCategory.addFluidStack(slot, fluid);
            }
        } else if (block != null) {
            slot.entry(EntryStacks.of((class_1935)block));
        }
    }

    private static void addFluidStack(Slot slot, class_3611 fluid) {
        slot.entry(EntryStacks.of((class_3611)fluid, (long)81000L));
    }

    public CategoryIdentifier<? extends EntropyManipulatorDisplay> getCategoryIdentifier() {
        return ID;
    }

    public class_2561 getTitle() {
        return AEItems.ENTROPY_MANIPULATOR.method_8389().method_7848();
    }

    public Renderer getIcon() {
        return new AbstractRenderer(){

            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                EntropyManipulatorCategory.this.icon.dest(bounds.x, bounds.y).blit(matrices, this.method_25305());
            }
        };
    }

    public List<Widget> setupDisplay(EntropyManipulatorDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        EntropyRecipe recipe = display.getRecipe();
        Widget icon = switch (recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> this.iconHeat;
            case EntropyMode.COOL -> this.iconCool;
        };
        class_5250 labelText = switch (recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.ENTROPY_MANIPULATOR_HEAT.text(1600);
            case EntropyMode.COOL -> ItemModText.ENTROPY_MANIPULATOR_COOL.text(1600);
        };
        class_5250 interaction = switch (recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.RIGHT_CLICK.text();
            case EntropyMode.COOL -> ItemModText.SHIFT_RIGHT_CLICK.text();
        };
        Label modeLabel = Widgets.createLabel((Point)new Point(this.centerX + 4, 2), (class_2561)labelText).noShadow().color(0x7E7E7E);
        widgets.add((Widget)modeLabel);
        widgets.add((Widget)Widgets.withTranslate((Widget)icon, (double)(modeLabel.getBounds().getX() - 9), (double)3.0, (double)0.0));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(this.centerX - 12, 14)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(this.centerX, 38), (class_2561)interaction).noShadow().color(0x7E7E7E));
        this.setupSlots(widgets, recipe);
        for (int i = 0; i < widgets.size(); ++i) {
            if (i <= 0) continue;
            widgets.set(i, (Widget)Widgets.withTranslate((Widget)widgets.get(i), (double)bounds.x, (double)(bounds.y + 3), (double)0.0));
        }
        return widgets;
    }

    private void setupSlots(ArrayList<Widget> widgets, EntropyRecipe recipe) {
        Slot input = Widgets.createSlot((Point)new Point(this.centerX - 36, 15)).backgroundEnabled(true).markInput();
        widgets.add((Widget)input);
        this.setFluidOrBlockSlot(input, recipe.getInputBlock(), recipe.getInputFluid());
        int x = this.centerX + 20;
        if (recipe.getOutputBlock() == class_2246.field_10124 && (recipe.getOutputFluid() == null || recipe.getOutputFluid() == class_3612.field_15906)) {
            Slot destroyed = Widgets.createSlot((Point)new Point(x, 15)).backgroundEnabled(true).unmarkInputOrOutput();
            widgets.add((Widget)destroyed);
            this.setFluidOrBlockSlot(destroyed, recipe.getInputBlock(), recipe.getInputFluid());
            widgets.add((Widget)Widgets.withTranslate((Widget)this.blockDestroyOverlay, (double)x, (double)15.0, (double)0.0));
            for (EntryStack entry : destroyed.getEntries()) {
                entry.tooltip(new class_2561[]{ItemModText.CONSUMED.text().method_27695(new class_124[]{class_124.field_1061, class_124.field_1067})});
            }
            x += 18;
        } else if (recipe.getOutputBlock() != null || recipe.getOutputFluid() != null) {
            Slot output = Widgets.createSlot((Point)new Point(x, 15)).backgroundEnabled(true).markOutput();
            widgets.add((Widget)output);
            this.setFluidOrBlockSlot(output, recipe.getOutputBlock(), recipe.getOutputFluid());
            x += 18;
        }
        for (class_1799 drop : recipe.getDrops()) {
            Slot output = Widgets.createSlot((Point)new Point(x, 15)).backgroundEnabled(true).markOutput();
            widgets.add((Widget)output);
            output.entry(EntryStacks.of((class_1799)drop));
            x += 18;
        }
    }

    public int getDisplayWidth(EntropyManipulatorDisplay display) {
        return 130;
    }

    public int getDisplayHeight() {
        return 55;
    }
}

