/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.modules.rei.GenericEntryStackHelper;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_437;

class GhostIngredientHandler
implements DraggableStackVisitor<AEBaseScreen> {
    GhostIngredientHandler() {
    }

    public <R extends class_437> boolean isHandingScreen(R screen) {
        return screen instanceof AEBaseScreen;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<AEBaseScreen> context, DraggableStack stack) {
        List<DropTarget> targets = this.getTargets(context, stack);
        return targets.stream().map(target -> DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)target.getArea()));
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<AEBaseScreen> context, DraggableStack stack) {
        List<DropTarget> targets = this.getTargets(context, stack);
        Point pos = context.getCurrentPosition();
        for (DropTarget target : targets) {
            if (!target.getArea().contains(pos) || !target.accept(stack)) continue;
            return DraggedAcceptorResult.ACCEPTED;
        }
        return DraggedAcceptorResult.PASS;
    }

    @Nullable
    private class_1799 wrapDraggedItem(EntryStack<?> entryStack) {
        if (entryStack.getType() == VanillaEntryTypes.ITEM) {
            return (class_1799)entryStack.castValue();
        }
        GenericStack genericStack = GenericEntryStackHelper.ingredientToStack(entryStack);
        if (genericStack != null) {
            return GenericStack.wrapInItemStack(genericStack);
        }
        return null;
    }

    private List<DropTarget> getTargets(DraggingContext<AEBaseScreen> context, DraggableStack stack) {
        class_1799 wrapped = this.wrapDraggedItem(stack.getStack());
        if (wrapped == null) {
            return Collections.emptyList();
        }
        ArrayList<DropTarget> targets = new ArrayList<DropTarget>();
        GhostIngredientHandler.addItemStackTargets((AEBaseScreen)context.getScreen(), targets, wrapped);
        return targets;
    }

    private static void addItemStackTargets(AEBaseScreen<?> gui, List<DropTarget> targets, class_1799 draggedStack) {
        for (class_1735 slot : ((AEBaseMenu)gui.method_17577()).field_7761) {
            FakeSlot fakeSlot;
            if (!slot.method_7682() || !(slot instanceof FakeSlot) || !(fakeSlot = (FakeSlot)slot).canSetFilterTo(draggedStack)) continue;
            targets.add(new ItemSlotTarget(gui, fakeSlot));
        }
    }

    static interface DropTarget {
        public Rectangle getArea();

        public boolean accept(DraggableStack var1);
    }

    private static class ItemSlotTarget
    implements DropTarget {
        private final AppEngSlot slot;
        private final Rectangle area;

        public ItemSlotTarget(AEBaseScreen<?> screen, AppEngSlot slot) {
            this.slot = slot;
            this.area = new Rectangle(screen.getGuiLeft() + slot.field_7873, screen.getGuiTop() + slot.field_7872, 16, 16);
        }

        @Override
        public Rectangle getArea() {
            return this.area;
        }

        @Override
        public boolean accept(DraggableStack ingredient) {
            EntryStack entryStack = ingredient.getStack();
            if (entryStack.getType() == VanillaEntryTypes.ITEM) {
                class_1799 itemStack = (class_1799)entryStack.castValue();
                NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.field_7874, itemStack));
                return true;
            }
            if (entryStack.getType() == VanillaEntryTypes.FLUID) {
                FluidStack fluidStack = (FluidStack)entryStack.castValue();
                class_1799 wrappedFluid = GenericStack.wrapInItemStack(new GenericStack(AEFluidKey.of(fluidStack.getFluid()), fluidStack.getAmount()));
                NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.field_7874, wrappedFluid));
                return true;
            }
            return false;
        }
    }
}

