/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei.transfer;

import appeng.core.AppEng;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jeirei.CraftingHelper;
import appeng.integration.modules.jeirei.TransferHelper;
import appeng.integration.modules.rei.transfer.AbstractTransferHandler;
import appeng.menu.me.items.CraftingTermMenu;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;

public class UseCraftingRecipeTransfer<T extends CraftingTermMenu>
extends AbstractTransferHandler<T> {
    public UseCraftingRecipeTransfer(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    protected TransferHandler.Result transferRecipe(T menu, class_1860<?> recipe, Display display, boolean doTransfer) {
        boolean craftingRecipe = this.isCraftingRecipe(recipe, display);
        if (!craftingRecipe) {
            return TransferHandler.Result.createNotApplicable();
        }
        if (!this.fitsIn3x3Grid(recipe, display)) {
            return TransferHandler.Result.createFailed((class_2561)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (recipe == null) {
            recipe = this.createFakeRecipe(display);
        }
        boolean craftMissing = class_465.method_25441();
        Map<Integer, class_1856> slotToIngredientMap = this.getGuiSlotToIngredientMap(recipe);
        CraftingTermMenu.MissingIngredientSlots missingSlots = ((CraftingTermMenu)menu).findMissingIngredients(this.getGuiSlotToIngredientMap(recipe));
        if (missingSlots.missingSlots().size() == slotToIngredientMap.size()) {
            return TransferHandler.Result.createFailed((class_2561)ItemModText.NO_ITEMS.text()).renderer(UseCraftingRecipeTransfer.createErrorRenderer(missingSlots));
        }
        if (!doTransfer) {
            if (missingSlots.totalSize() != 0) {
                int color = missingSlots.anyMissing() ? -2130729728 : -2142943745;
                TransferHandler.Result result = TransferHandler.Result.createSuccessful().color(color).renderer(UseCraftingRecipeTransfer.createErrorRenderer(missingSlots));
                List<class_2561> tooltip = TransferHelper.createCraftingTooltip(missingSlots, craftMissing);
                result.overrideTooltipRenderer((point, sink) -> sink.accept(Tooltip.create((Collection)tooltip)));
                return result;
            }
        } else {
            CraftingHelper.performTransfer(menu, recipe, craftMissing);
        }
        return TransferHandler.Result.createSuccessful().blocksFurtherHandling();
    }

    private class_1860<?> createFakeRecipe(Display display) {
        class_2371 ingredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        for (int i = 0; i < Math.min(display.getInputEntries().size(), ingredients.size()); ++i) {
            class_1856 ingredient = class_1856.method_26964(((EntryIngredient)display.getInputEntries().get(i)).stream().filter(es -> es.getType() == VanillaEntryTypes.ITEM).map(es -> (class_1799)es.castValue()));
            ingredients.set(i, (Object)ingredient);
        }
        return new class_1869(AppEng.makeId("__fake_recipe"), "", 3, 3, ingredients, class_1799.field_8037);
    }

    private Map<Integer, class_1856> getGuiSlotToIngredientMap(class_1860<?> recipe) {
        int width;
        class_2371 ingredients = recipe.method_8117();
        if (recipe instanceof class_1869) {
            class_1869 shapedRecipe = (class_1869)recipe;
            width = shapedRecipe.method_8150();
        } else {
            width = 3;
        }
        HashMap<Integer, class_1856> result = new HashMap<Integer, class_1856>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            int guiSlot = i / width * 3 + i % width;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8103()) continue;
            result.put(guiSlot, ingredient);
        }
        return result;
    }

    private static TransferHandlerRenderer createErrorRenderer(CraftingTermMenu.MissingIngredientSlots indices) {
        return (matrices, mouseX, mouseY, delta, widgets, bounds, display) -> {
            int i = 0;
            for (Widget widget : widgets) {
                Slot slot;
                if (!(widget instanceof Slot) || (slot = (Slot)widget).getNoticeMark() != 1) continue;
                boolean missing = indices.missingSlots().contains(i);
                boolean craftable = indices.craftableSlots().contains(i);
                ++i;
                if (!missing && !craftable) continue;
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 400.0);
                Rectangle innerBounds = slot.getInnerBounds();
                class_332.method_25294((class_4587)matrices, (int)innerBounds.x, (int)innerBounds.y, (int)innerBounds.getMaxX(), (int)innerBounds.getMaxY(), (int)(missing ? 0x66FF0000 : 0x400000FF));
                matrices.method_22909();
            }
        };
    }
}

