/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.util.DimensionalBlockPos;
import appeng.api.util.INetworkToolAware;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.networktool.NetworkStatusMenu;
import appeng.menu.me.networktool.NetworkToolMenu;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public class NetworkToolItem
extends AEBaseItem
implements IMenuItem,
AEToolItem {
    public NetworkToolItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public NetworkToolMenuHost getMenuHost(class_1657 player, int inventorySlot, class_1799 stack, class_2338 pos) {
        class_1937 level = player.field_6002;
        if (pos == null) {
            return new NetworkToolMenuHost(player, inventorySlot, stack, null);
        }
        IInWorldGridNodeHost host = GridHelper.getNodeHost((class_1936)level, pos);
        return new NetworkToolMenuHost(player, inventorySlot, stack, host);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 p, class_1268 hand) {
        if (!level.method_8608()) {
            MenuOpener.open(NetworkToolMenu.TYPE, p, MenuLocators.forHand(p, hand));
        }
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)p.method_5998(hand));
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        INetworkToolAware toolAgent;
        if (context.method_8046()) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        class_2586 te = level.method_8321(context.method_8037());
        if (te instanceof IPartHost) {
            INetworkToolAware toolAgent2;
            IPart iPart;
            IPartHost partHost = (IPartHost)te;
            SelectedPart part = partHost.selectPartWorld(context.method_17698());
            if ((part.part != null || part.facade != null) && (iPart = part.part) instanceof INetworkToolAware && !(toolAgent2 = (INetworkToolAware)((Object)iPart)).showNetworkInfo(context)) {
                return class_1269.field_5811;
            }
        } else if (te instanceof INetworkToolAware && !(toolAgent = (INetworkToolAware)te).showNetworkInfo(context)) {
            return class_1269.field_5811;
        }
        if (!level.method_8608() && !this.showNetworkToolGui(context)) {
            return class_1269.field_5814;
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private boolean showNetworkToolGui(class_1838 useContext) {
        if (useContext.method_8036() == null) {
            return false;
        }
        class_2338 pos = useContext.method_8037();
        class_1657 p = useContext.method_8036();
        class_1937 level = useContext.method_8045();
        class_1268 hand = useContext.method_20287();
        if (!Platform.hasPermissions(new DimensionalBlockPos(level, pos), p)) {
            return false;
        }
        IInWorldGridNodeHost nodeHost = GridHelper.getNodeHost((class_1936)level, pos);
        if (nodeHost != null) {
            MenuOpener.open(NetworkStatusMenu.NETWORK_TOOL_TYPE, p, MenuLocators.forItemUseContext(useContext));
        } else {
            MenuOpener.open(NetworkToolMenu.TYPE, p, MenuLocators.forHand(p, hand));
        }
        return true;
    }

    @Nullable
    public static NetworkToolMenuHost findNetworkToolInv(class_1657 player) {
        class_1661 pi = player.method_31548();
        for (int x = 0; x < pi.method_5439(); ++x) {
            class_1792 class_17922;
            class_1799 pii = pi.method_5438(x);
            if (pii.method_7960() || !((class_17922 = pii.method_7909()) instanceof NetworkToolItem)) continue;
            NetworkToolItem networkToolItem = (NetworkToolItem)class_17922;
            return networkToolItem.getMenuHost(pi.field_7546, x, pii, null);
        }
        return null;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        NetworkToolMenuHost toolHost = new NetworkToolMenuHost(null, null, stack, null);
        if (toolHost.getInventory().isEmpty()) {
            return Optional.empty();
        }
        LinkedHashMap<AEItemKey, Integer> upgradeCards = new LinkedHashMap<AEItemKey, Integer>();
        for (class_1799 card : toolHost.getInventory()) {
            upgradeCards.merge(AEItemKey.of(card), card.method_7947(), Integer::sum);
        }
        ArrayList<GenericStack> stacks = new ArrayList<GenericStack>(upgradeCards.size());
        for (Map.Entry entry : upgradeCards.entrySet()) {
            stacks.add(new GenericStack((AEKey)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        stacks.sort(Comparator.comparingLong(GenericStack::amount).reversed());
        return Optional.of(new StorageCellTooltipComponent(List.of(), stacks, false));
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        class_1799 other = slot.method_7677();
        if (other.method_7960()) {
            return true;
        }
        this.insertIntoTool(stack, other, player);
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (other.method_7960()) {
            return false;
        }
        this.insertIntoTool(stack, other, player);
        return true;
    }

    private void insertIntoTool(class_1799 tool, class_1799 upgrade, class_1657 player) {
        NetworkToolMenuHost toolHost = new NetworkToolMenuHost(player, null, tool, null);
        int amount = upgrade.method_7947();
        class_1799 overflow = toolHost.getInventory().addItems(upgrade);
        upgrade.method_7934(amount - overflow.method_7947());
        toolHost.saveChanges();
    }
}

