/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import appeng.util.IVariantConversion;
import appeng.util.Platform;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class StorageAdapter<V extends TransferVariant<?>>
implements MEStorage {
    private static final long MAX_REPORTED_AMOUNT = 0x40000000000L;
    private final IVariantConversion<V> conversion;
    private boolean extractableOnly;
    private final Supplier<@Nullable Storage<V>> storageSupplier;

    public StorageAdapter(IVariantConversion<V> conversion, Supplier<@Nullable Storage<V>> storageSupplier) {
        this.conversion = conversion;
        this.storageSupplier = storageSupplier;
    }

    public IVariantConversion<V> getConversion() {
        return this.conversion;
    }

    public void setExtractableOnly(boolean extractableOnly) {
        this.extractableOnly = extractableOnly;
    }

    protected void onInjectOrExtract() {
    }

    @Override
    public long insert(AEKey what, long amount, Actionable type, IActionSource src) {
        Storage<V> storage = this.storageSupplier.get();
        if (storage == null) {
            return 0L;
        }
        V variant = this.conversion.getVariant(what);
        if (variant.isBlank()) {
            return 0L;
        }
        try (Transaction tx = Platform.openOrJoinTx();){
            long inserted = storage.insert(variant, amount, (TransactionContext)tx);
            if (inserted > 0L && type == Actionable.MODULATE) {
                tx.commit();
                this.onInjectOrExtract();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        Storage<V> storage = this.storageSupplier.get();
        if (storage == null) {
            return 0L;
        }
        V variant = this.conversion.getVariant(what);
        if (variant.isBlank()) {
            return 0L;
        }
        try (Transaction tx = Platform.openOrJoinTx();){
            long extracted = storage.extract(variant, amount, (TransactionContext)tx);
            if (extracted > 0L && mode == Actionable.MODULATE) {
                tx.commit();
                this.onInjectOrExtract();
            }
            long l = extracted;
            return l;
        }
    }

    @Override
    public void getAvailableStacks(KeyCounter out) {
        Storage<V> storage = this.storageSupplier.get();
        if (storage != null) {
            try (Transaction tx = Transaction.openOuter();){
                for (StorageView view : storage.iterable((TransactionContext)tx)) {
                    TransferVariant resource = (TransferVariant)view.getResource();
                    if (resource.isBlank()) continue;
                    if (this.extractableOnly) {
                        Transaction innerTx = tx.openNested();
                        try {
                            long extracted = view.extract((Object)resource, 1L, (TransactionContext)innerTx);
                            if (extracted == 0L) {
                                extracted = view.extract((Object)resource, view.getAmount(), (TransactionContext)innerTx);
                            }
                            if (extracted == 0L) {
                                continue;
                            }
                        }
                        finally {
                            if (innerTx == null) continue;
                            innerTx.close();
                            continue;
                        }
                    }
                    long amount = Math.min(view.getAmount(), 0x40000000000L);
                    out.add(this.conversion.getKey(resource), amount);
                }
            }
        }
    }

    @Override
    public class_2561 getDescription() {
        return GuiText.ExternalStorage.text(this.conversion.getKeyType().getDescription());
    }
}

