/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public abstract class AbstractLevelEmitterPart
extends UpgradeablePart {
    private boolean prevState;
    protected long lastReportedValue;
    private long reportingValue;
    private boolean clientSideOn;

    public AbstractLevelEmitterPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getConfigManager().registerSetting(Settings.REDSTONE_EMITTER, RedstoneMode.HIGH_SIGNAL);
    }

    protected abstract void configureWatchers();

    protected abstract boolean hasDirectOutput();

    protected abstract boolean getDirectOutput();

    @Override
    protected final void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (this.getMainNode().hasGridBooted()) {
            this.updateState();
        }
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.prevState);
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        boolean wasOn = this.clientSideOn;
        this.clientSideOn = data.readBoolean();
        return changed || wasOn != this.clientSideOn;
    }

    @Override
    public void writeVisualStateToNBT(class_2487 data) {
        super.writeVisualStateToNBT(data);
        data.method_10556("on", this.isLevelEmitterOn());
    }

    @Override
    public void readVisualStateFromNBT(class_2487 data) {
        super.readVisualStateFromNBT(data);
        this.clientSideOn = data.method_10577("on");
    }

    protected void updateState() {
        boolean isOn = this.isLevelEmitterOn();
        if (this.prevState != isOn) {
            this.getHost().markForUpdate();
            class_2586 te = this.getHost().getBlockEntity();
            this.prevState = isOn;
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016());
            Platform.notifyBlocksOfNeighbors(te.method_10997(), te.method_11016().method_10093(this.getSide()));
        }
    }

    public final long getReportingValue() {
        return this.reportingValue;
    }

    public final void setReportingValue(long v) {
        this.reportingValue = v;
        this.onReportingValueChanged();
        this.updateState();
    }

    protected void onReportingValueChanged() {
    }

    @Override
    public final int isProvidingStrongPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public final int isProvidingWeakPower() {
        return this.prevState ? 15 : 0;
    }

    @Override
    public final void animateTick(class_1937 level, class_2338 pos, Random r) {
        if (this.isLevelEmitterOn()) {
            class_2350 d = this.getSide();
            double d0 = (double)((float)d.method_10148() * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)d.method_10164() * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)d.method_10165() * 0.45f) + (double)(r.nextFloat() - 0.5f) * 0.2;
            level.method_8406((class_2394)class_2390.field_11188, 0.5 + (double)pos.method_10263() + d0, 0.5 + (double)pos.method_10264() + d1, 0.5 + (double)pos.method_10260() + d2, 0.0, 0.0, 0.0);
        }
    }

    protected boolean isLevelEmitterOn() {
        boolean flipState;
        if (this.isClientSide()) {
            return this.clientSideOn;
        }
        if (!this.getMainNode().isActive()) {
            return false;
        }
        if (this.hasDirectOutput()) {
            return this.getDirectOutput();
        }
        boolean bl = flipState = this.getConfigManager().getSetting(Settings.REDSTONE_EMITTER) == RedstoneMode.LOW_SIGNAL;
        return flipState ? this.reportingValue >= this.lastReportedValue + 1L : this.reportingValue < this.lastReportedValue + 1L;
    }

    @Override
    public final boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.lastReportedValue = data.method_10537("lastReportedValue");
        this.reportingValue = data.method_10537("reportingValue");
        this.prevState = data.method_10577("prevState");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10544("lastReportedValue", this.lastReportedValue);
        data.method_10544("reportingValue", this.reportingValue);
        data.method_10556("prevState", this.prevState);
    }

    @Override
    public final float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public final AECableType getDesiredConnectionType() {
        return AECableType.SMART;
    }

    @Override
    public final void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.configureWatchers();
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        this.setReportingValue(input.method_10537("reportingValue"));
    }

    @Override
    public void exportSettings(SettingsFrom mode, class_2487 output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.method_10544("reportingValue", this.reportingValue);
        }
    }

    @Override
    protected boolean shouldSendPowerStateToClient() {
        return false;
    }

    @Override
    protected boolean shouldSendMissingChannelStateToClient() {
        return false;
    }
}

