/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.helpers.IConfigInvHost;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.parts.PartModel;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public abstract class IOBusPart
extends UpgradeablePart
implements IGridTickable,
IConfigInvHost {
    public static final class_2960 MODEL_BASE = new class_2960("ae2", "part/import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new class_2960("ae2", "part/import_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new class_2960("ae2", "part/import_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new class_2960("ae2", "part/import_bus_has_channel"));
    private final ConfigInventory config;
    @Nullable
    private IPartitionList filter;
    private final TickRates tickRates;
    protected final IActionSource source;
    private boolean lastRedstone = false;
    private boolean pendingPulse = false;

    public IOBusPart(TickRates tickRates, IPartItem<?> partItem) {
        super(partItem);
        this.tickRates = tickRates;
        this.source = new MachineSource(this);
        this.config = ConfigInventory.configTypes(StackWorldBehaviors.hasImportStrategyFilter(), 9, this::updateState);
        this.getMainNode().addService(IGridTickable.class, this);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
    }

    @Override
    public RedstoneMode getRSMode() {
        return this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    private boolean isInPulseMode() {
        return this.getRSMode() == RedstoneMode.SIGNAL_PULSE;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    protected abstract class_3917<?> getMenuType();

    @Override
    public void upgradesChanged() {
        this.updateState();
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.config.readFromChildTag(extra, "config");
        this.filter = null;
        this.pendingPulse = this.isInPulseMode() && extra.method_10577("pendingPulse");
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.config.writeToChildTag(extra, "config");
        if (this.isInPulseMode() && this.pendingPulse) {
            extra.method_10556("pendingPulse", true);
        }
    }

    @Override
    public ConfigInventory getConfig() {
        return this.config;
    }

    protected final IPartitionList getFilter() {
        if (this.filter == null) {
            IPartitionList.Builder filterBuilder = IPartitionList.builder();
            filterBuilder.addAll(this.getConfig().keySet());
            if (this.isUpgradedWith(AEItems.FUZZY_CARD)) {
                filterBuilder.fuzzyMode(this.getConfigManager().getSetting(Settings.FUZZY_MODE));
            }
            this.filter = filterBuilder.build();
        }
        return this.filter;
    }

    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (this.isInPulseMode()) {
            boolean hostIsPowered = this.getHost().hasRedstone();
            if (this.lastRedstone != hostIsPowered) {
                this.lastRedstone = hostIsPowered;
                if (this.lastRedstone && !this.pendingPulse) {
                    this.pendingPulse = true;
                    this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
                }
            }
        } else {
            this.updateRedstoneState();
        }
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(AEItems.CAPACITY_CARD) * 4, this.getConfig().size());
    }

    protected int getOperationsPerTick() {
        return switch (this.getInstalledUpgrades(AEItems.SPEED_CARD)) {
            default -> 1;
            case 1 -> 8;
            case 2 -> 32;
            case 3 -> 64;
            case 4 -> 96;
        };
    }

    @Override
    public final TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.pendingPulse = false;
        boolean hasDoneWork = this.doBusWork(node.getGrid());
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        return hasDoneWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }

    protected final boolean canDoBusWork() {
        if (!this.getMainNode().isActive()) {
            return false;
        }
        class_2586 self = this.getHost().getBlockEntity();
        class_2338 targetPos = self.method_11016().method_10093(this.getSide());
        return Platform.areBlockEntitiesTicking(self.method_10997(), targetPos);
    }

    private void updateState() {
        this.filter = null;
        this.updateRedstoneState();
    }

    @Override
    protected void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        super.onSettingChanged(manager, setting);
        this.updateRedstoneState();
        if (this.isInPulseMode()) {
            this.lastRedstone = this.getHost().hasRedstone();
        }
    }

    private void updateRedstoneState() {
        if (!this.isInPulseMode()) {
            this.pendingPulse = false;
        }
        this.getMainNode().ifPresent((grid, node) -> {
            if (!this.isSleeping()) {
                grid.getTickManager().wakeDevice((IGridNode)node);
            } else {
                grid.getTickManager().sleepDevice((IGridNode)node);
            }
        });
    }

    @Override
    public final boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!this.isClientSide()) {
            MenuOpener.open(this.getMenuType(), player, MenuLocators.forPart(this));
        }
        return true;
    }

    @Override
    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(this.tickRates.getMin(), this.tickRates.getMax(), this.isSleeping(), true);
    }

    @Override
    protected boolean isSleeping() {
        if (this.isInPulseMode() && this.pendingPulse) {
            return false;
        }
        return super.isSleeping();
    }

    protected abstract boolean doBusWork(IGrid var1);

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.lastRedstone = this.getHost().hasRedstone();
        if (this.pendingPulse) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }
}

