/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.parts.ICablePart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.pathing.ChannelMode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEParts;
import appeng.items.parts.ColoredPartItem;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.parts.AEBasePart;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.StringUtils;

public class CablePart
extends AEBasePart
implements ICablePart {
    private static final IGridNodeListener<CablePart> NODE_LISTENER = new AEBasePart.NodeListener<CablePart>(){

        @Override
        public void onInWorldConnectionChanged(CablePart nodeOwner, IGridNode node) {
            super.onInWorldConnectionChanged(nodeOwner, node);
            nodeOwner.markForUpdate();
        }
    };
    private final int[] channelsOnSide = new int[]{0, 0, 0, 0, 0, 0};
    private Set<class_2350> connections = Collections.emptySet();

    public CablePart(ColoredPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.PREFERRED).setIdlePowerUsage(0.0).setInWorldNode(true).setExposedOnSides(EnumSet.allOf(class_2350.class));
        this.getMainNode().setGridColor(partItem.getColor());
    }

    @Override
    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, NODE_LISTENER);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.CABLE;
    }

    @Override
    public AEColor getCableColor() {
        IPartItem<?> iPartItem = this.getPartItem();
        if (iPartItem instanceof ColoredPartItem) {
            ColoredPartItem coloredPartItem = (ColoredPartItem)iPartItem;
            return coloredPartItem.getColor();
        }
        return AEColor.TRANSPARENT;
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.GLASS;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        if (cable == this.getCableConnectionType()) {
            return 4.0f;
        }
        if (cable.ordinal() >= this.getCableConnectionType().ordinal()) {
            return -1.0f;
        }
        return 8.0f;
    }

    @Override
    public void onPlacement(class_1657 player) {
        ColorApplicatorItem item;
        AEColor color;
        class_1792 class_17922;
        super.onPlacement(player);
        class_1799 stack = player.method_5998(class_1268.field_5810);
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof ColorApplicatorItem && (color = (item = (ColorApplicatorItem)class_17922).getActiveColor(stack)) != null && color != this.getCableColor() && item.consumeColor(stack, color, true) && this.changeColor(color, player) && !player.method_31549().field_7477) {
            item.consumeColor(stack, color, false);
        }
    }

    @Override
    public boolean changeColor(AEColor newColor, class_1657 who) {
        if (this.getCableColor() != newColor) {
            IPartItem newPart = null;
            if (this.getCableConnectionType() == AECableType.GLASS) {
                newPart = AEParts.GLASS_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.COVERED) {
                newPart = AEParts.COVERED_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.SMART) {
                newPart = AEParts.SMART_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.DENSE_COVERED) {
                newPart = AEParts.COVERED_DENSE_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.DENSE_SMART) {
                newPart = AEParts.SMART_DENSE_CABLE.item(newColor);
            }
            boolean hasPermission = true;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                hasPermission = grid.getSecurityService().hasPermission(who, SecurityPermissions.BUILD);
            }
            if (newPart != null && hasPermission) {
                if (this.isClientSide()) {
                    return true;
                }
                this.setPartItem(newPart);
                this.getMainNode().setGridColor(this.getCableColor());
                this.getHost().markForUpdate();
                this.getHost().markForSave();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setExposedOnSides(EnumSet<class_2350> sides) {
        this.getMainNode().setExposedOnSides(sides);
    }

    @Override
    public boolean isConnected(class_2350 side) {
        return this.getConnections().contains(side);
    }

    public void markForUpdate() {
        this.getHost().markForUpdate();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.updateConnections();
        bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
        IPartHost ph = this.getHost();
        if (ph != null) {
            block16: for (class_2350 dir : class_2350.values()) {
                float dist;
                IPart p = ph.getPart(dir);
                if (p == null || (dist = p.getCableConnectionLength(this.getCableConnectionType())) > 8.0f) continue;
                switch (dir) {
                    case field_11033: {
                        bch.addBox(6.0, dist, 6.0, 10.0, 6.0, 10.0);
                        continue block16;
                    }
                    case field_11034: {
                        bch.addBox(10.0, 6.0, 6.0, 16.0 - (double)dist, 10.0, 10.0);
                        continue block16;
                    }
                    case field_11043: {
                        bch.addBox(6.0, 6.0, dist, 10.0, 10.0, 6.0);
                        continue block16;
                    }
                    case field_11035: {
                        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0 - (double)dist);
                        continue block16;
                    }
                    case field_11036: {
                        bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0 - (double)dist, 10.0);
                        continue block16;
                    }
                    case field_11039: {
                        bch.addBox(dist, 6.0, 6.0, 6.0, 10.0, 10.0);
                        continue block16;
                    }
                }
            }
        }
        for (class_2350 of : this.getConnections()) {
            switch (of) {
                case field_11033: {
                    bch.addBox(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
                    break;
                }
                case field_11034: {
                    bch.addBox(10.0, 6.0, 6.0, 16.0, 10.0, 10.0);
                    break;
                }
                case field_11043: {
                    bch.addBox(6.0, 6.0, 0.0, 10.0, 10.0, 6.0);
                    break;
                }
                case field_11035: {
                    bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
                    break;
                }
                case field_11036: {
                    bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0, 10.0);
                    break;
                }
                case field_11039: {
                    bch.addBox(0.0, 6.0, 6.0, 6.0, 10.0, 10.0);
                    break;
                }
            }
        }
    }

    protected void updateConnections() {
        if (!this.isClientSide()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.setConnections(Collections.emptySet());
            }
        }
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        boolean[] writeChannels = new boolean[class_2350.values().length];
        byte[] channelsPerSide = new byte[class_2350.values().length];
        for (class_2350 thisSide : class_2350.values()) {
            IPart part = this.getHost().getPart(thisSide);
            if (part == null) continue;
            int channels = 0;
            if (part.getGridNode() != null) {
                for (IGridConnection gc : part.getGridNode().getConnections()) {
                    channels = Math.max(channels, gc.getUsedChannels());
                }
            }
            channelsPerSide[thisSide.ordinal()] = this.getVisualChannels(channels);
            writeChannels[thisSide.ordinal()] = true;
        }
        int connectedSidesPacked = 0;
        IGridNode n = this.getGridNode();
        if (n != null) {
            for (Map.Entry<class_2350, IGridConnection> entry : n.getInWorldConnections().entrySet()) {
                int side = entry.getKey().ordinal();
                IGridConnection connection = entry.getValue();
                channelsPerSide[side] = this.getVisualChannels(connection.getUsedChannels());
                writeChannels[side] = true;
                connectedSidesPacked |= 1 << side;
            }
        }
        data.writeByte((int)((byte)connectedSidesPacked));
        for (int i = 0; i < writeChannels.length; ++i) {
            if (!writeChannels[i]) continue;
            data.writeByte((int)channelsPerSide[i]);
        }
    }

    private byte getVisualChannels(int channels) {
        byte visualMaxChannels;
        IGridNode node = this.getGridNode();
        if (node == null) {
            return 0;
        }
        switch (this.getCableConnectionType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                byte by = 0;
                break;
            }
            case GLASS: 
            case SMART: 
            case COVERED: {
                byte by = 8;
                break;
            }
            case DENSE_COVERED: 
            case DENSE_SMART: {
                byte by = visualMaxChannels = 32;
            }
        }
        if (node.getGrid().getPathingService().getChannelMode() == ChannelMode.INFINITE) {
            return channels <= 0 ? (byte)0 : visualMaxChannels;
        }
        int gridMaxChannels = node.getMaxChannels();
        if (visualMaxChannels == 0 || gridMaxChannels == 0) {
            return 0;
        }
        byte result = (byte)Math.min(visualMaxChannels, channels * visualMaxChannels / gridMaxChannels);
        if (result == 0 && channels > 0) {
            return 1;
        }
        return result;
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        byte connectedSidesPacked = data.readByte();
        Set<class_2350> previousConnections = this.getConnections();
        boolean channelsChanged = false;
        EnumSet<class_2350> connections = EnumSet.noneOf(class_2350.class);
        for (class_2350 d : class_2350.values()) {
            boolean conOnSide;
            boolean bl = conOnSide = (connectedSidesPacked & 1 << d.ordinal()) != 0;
            if (conOnSide) {
                connections.add(d);
            }
            int ch = 0;
            if (conOnSide || this.getHost().getPart(d) != null) {
                ch = data.readByte() & 0xFF;
            }
            if (ch == this.channelsOnSide[d.ordinal()]) continue;
            channelsChanged = true;
            this.setChannelsOnSide(d.ordinal(), ch);
        }
        this.setConnections(connections);
        return changed || !previousConnections.equals(this.getConnections()) || channelsChanged;
    }

    @Override
    public void writeVisualStateToNBT(class_2487 data) {
        super.writeVisualStateToNBT(data);
        this.updateConnections();
        for (class_2350 side : class_2350.values()) {
            if (!this.connections.contains(side)) continue;
            String sideName = "channels" + StringUtils.capitalize((String)side.method_15434());
            data.method_10569(sideName, this.channelsOnSide[side.ordinal()]);
        }
        class_2499 connectionsTag = new class_2499();
        for (class_2350 connection : this.connections) {
            connectionsTag.add((Object)class_2519.method_23256((String)connection.method_15434()));
        }
        data.method_10566("connections", (class_2520)connectionsTag);
    }

    @Override
    public void readVisualStateFromNBT(class_2487 data) {
        super.readVisualStateFromNBT(data);
        if (data.method_10545("channels")) {
            Arrays.fill(this.channelsOnSide, data.method_10550("channels"));
        } else {
            for (class_2350 side : class_2350.values()) {
                String sideName = "channels" + StringUtils.capitalize((String)side.method_15434());
                this.channelsOnSide[side.ordinal()] = data.method_10550(sideName);
            }
        }
        EnumSet<class_2350> connections = EnumSet.noneOf(class_2350.class);
        class_2499 connectionsTag = data.method_10554("connections", 8);
        for (class_2520 connectionTag : connectionsTag) {
            class_2350 side = class_2350.method_10168((String)connectionTag.method_10714());
            if (side == null) continue;
            connections.add(side);
        }
        this.setConnections(connections);
    }

    public int getChannelsOnSide(class_2350 side) {
        if (!this.isPowered()) {
            return 0;
        }
        return this.channelsOnSide[side.ordinal()];
    }

    void setChannelsOnSide(int i, int channels) {
        this.channelsOnSide[i] = channels;
    }

    Set<class_2350> getConnections() {
        return this.connections;
    }

    void setConnections(Set<class_2350> connections) {
        this.connections = connections;
    }
}

