/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.parts.IPartItem;
import appeng.hooks.ticking.TickHandler;
import appeng.parts.PartAdjacentApi;
import appeng.parts.p2p.P2PTunnelPart;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public abstract class CapabilityP2PTunnelPart<P extends CapabilityP2PTunnelPart<P, A>, A>
extends P2PTunnelPart<P> {
    private final PartAdjacentApi<A> targetApiCache;
    private boolean inBlockUpdate = false;
    private int accessDepth = 0;
    private final CapabilityGuard capabilityGuard = new CapabilityGuard();
    private final EmptyCapabilityGuard emptyCapabilityGuard = new EmptyCapabilityGuard();
    protected A inputHandler;
    protected A outputHandler;
    protected A emptyHandler;

    public CapabilityP2PTunnelPart(IPartItem<?> partItem, BlockApiLookup<A, class_2350> api) {
        super(partItem);
        this.targetApiCache = new PartAdjacentApi<A>(this, api);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    public A getExposedApi() {
        if (this.isOutput()) {
            return this.outputHandler;
        }
        return this.inputHandler;
    }

    protected final CapabilityGuard getAdjacentCapability() {
        ++this.accessDepth;
        return this.capabilityGuard;
    }

    protected final CapabilityGuard getInputCapability() {
        CapabilityP2PTunnelPart input = (CapabilityP2PTunnelPart)this.getInput();
        return input == null ? this.emptyCapabilityGuard : input.getAdjacentCapability();
    }

    private class_2338 getFacingPos() {
        return this.getHost().getLocation().getPos().method_10093(this.getSide());
    }

    protected void sendBlockUpdate() {
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                class_2586 self = this.getBlockEntity();
                self.method_10997().method_8452(self.method_11016(), class_2246.field_10124);
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        TickHandler.instance().addCallable((class_1936)this.getLevel(), () -> {
            if (this.getMainNode().isReady()) {
                this.sendBlockUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (!this.getFacingPos().equals((Object)neighbor)) {
            return;
        }
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                if (this.isOutput()) {
                    CapabilityP2PTunnelPart input = (CapabilityP2PTunnelPart)this.getInput();
                    if (input != null) {
                        input.sendBlockUpdate();
                    }
                } else {
                    for (CapabilityP2PTunnelPart output : this.getOutputs()) {
                        output.sendBlockUpdate();
                    }
                }
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    protected class CapabilityGuard
    implements AutoCloseable {
        protected CapabilityGuard() {
        }

        public A get() {
            if (CapabilityP2PTunnelPart.this.accessDepth == 0) {
                throw new IllegalStateException("get was called after closing the wrapper");
            }
            if (CapabilityP2PTunnelPart.this.accessDepth == 1) {
                Object result;
                if (CapabilityP2PTunnelPart.this.isActive() && (result = CapabilityP2PTunnelPart.this.targetApiCache.find()) != null) {
                    return result;
                }
                return CapabilityP2PTunnelPart.this.emptyHandler;
            }
            return CapabilityP2PTunnelPart.this.emptyHandler;
        }

        @Override
        public void close() {
            if (--CapabilityP2PTunnelPart.this.accessDepth < 0) {
                throw new IllegalStateException("Close has been called multiple times");
            }
        }
    }

    protected class EmptyCapabilityGuard
    extends CapabilityGuard
    implements AutoCloseable {
        protected EmptyCapabilityGuard() {
        }

        @Override
        public void close() {
        }

        @Override
        public A get() {
            return CapabilityP2PTunnelPart.this.emptyHandler;
        }
    }
}

