/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.server.ISubCommand;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class ChunkLogger
implements ISubCommand {
    private boolean eventsRegistered = false;
    private boolean enabled = false;

    private void displayStack() {
        if (AEConfig.instance().isChunkLoggerTraceEnabled()) {
            boolean output = false;
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                if (output) {
                    AELog.info("\t\t" + e.getClassName() + "." + e.getMethodName() + " (" + e.getLineNumber() + ")", new Object[0]);
                    continue;
                }
                output = e.getClassName().contains("EventBus") && e.getMethodName().contains("post");
            }
        }
    }

    private void onChunkLoadEvent(class_3218 level, class_2818 chunk) {
        if (this.enabled) {
            class_1923 chunkPos = chunk.method_12004();
            String center = ChunkLogger.getCenter(chunk);
            AELog.info("Loaded chunk " + chunkPos.field_9181 + "," + chunkPos.field_9180 + " [center: " + center + "] in " + level.method_27983().method_29177(), new Object[0]);
            this.displayStack();
        }
    }

    private void onChunkUnloadEvent(class_3218 level, class_2818 chunk) {
        if (this.enabled) {
            class_1923 chunkPos = chunk.method_12004();
            String center = ChunkLogger.getCenter(chunk);
            AELog.info("Unloaded chunk " + chunkPos.field_9181 + "," + chunkPos.field_9180 + " [center: " + center + "] in " + level.method_27983().method_29177(), new Object[0]);
            this.displayStack();
        }
    }

    private static String getCenter(class_2818 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        int y = chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1;
        return x + " " + y + " " + z;
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<class_2168> data, class_2168 sender) {
        if (!this.eventsRegistered) {
            ServerChunkEvents.CHUNK_LOAD.register(this::onChunkLoadEvent);
            ServerChunkEvents.CHUNK_UNLOAD.register(this::onChunkUnloadEvent);
        }
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            sender.method_9226((class_2561)new class_2588("commands.ae2.ChunkLoggerOn"), true);
        } else {
            sender.method_9226((class_2561)new class_2588("commands.ae2.ChunkLoggerOff"), true);
        }
    }
}

