/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.core.definitions.AEItems;
import appeng.me.cells.BasicCellInventory;
import appeng.me.helpers.BaseActionSource;
import appeng.util.ConfigInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3611;

public class DriveBuilder {
    private final List<class_1799> cells;

    DriveBuilder(List<class_1799> cells) {
        this.cells = cells;
    }

    public CreativeCellBuilder addCreativeCell() {
        class_1799 cell = AEItems.ITEM_CELL_CREATIVE.stack();
        ConfigInventory configInv = AEItems.ITEM_CELL_CREATIVE.method_8389().getConfigInventory(cell);
        this.cells.add(cell);
        return new CreativeCellBuilder(configInv);
    }

    public ItemCellBuilder addItemCell64k() {
        class_1799 cell = AEItems.ITEM_CELL_64K.stack();
        BasicCellInventory cellInv = BasicCellInventory.createInventory(cell, null);
        this.cells.add(cell);
        return new ItemCellBuilder(cellInv);
    }

    public FluidCellBuilder addFluidCell64k() {
        class_1799 cell = AEItems.FLUID_CELL_64K.stack();
        BasicCellInventory cellInv = BasicCellInventory.createInventory(cell, null);
        this.cells.add(cell);
        return new FluidCellBuilder(cellInv);
    }

    public class CreativeCellBuilder {
        private final ConfigInventory inv;

        public CreativeCellBuilder(ConfigInventory inv) {
            this.inv = inv;
        }

        public CreativeCellBuilder add(class_1935 item) {
            return this.add(AEItemKey.of((class_1935)item.method_8389()));
        }

        public CreativeCellBuilder add(class_3611 fluid) {
            return this.add(AEFluidKey.of(fluid));
        }

        public CreativeCellBuilder add(@Nullable GenericStack stack) {
            if (stack != null) {
                this.add(stack.what());
            }
            return this;
        }

        public CreativeCellBuilder add(AEKey key) {
            this.inv.insert(key, 1L, Actionable.MODULATE, new BaseActionSource());
            return this;
        }

        public DriveBuilder and() {
            return DriveBuilder.this;
        }
    }

    public class ItemCellBuilder
    extends CellBuilder {
        public ItemCellBuilder(BasicCellInventory inv) {
            super(inv);
        }

        public void add(class_1935 what, long amount) {
            this.add(AEItemKey.of((class_1935)what.method_8389()), amount);
        }
    }

    public class FluidCellBuilder
    extends CellBuilder {
        public FluidCellBuilder(BasicCellInventory inv) {
            super(inv);
        }

        public void addBuckets(class_3611 fluid, double buckets) {
            this.add(AEFluidKey.of(fluid), (long)(buckets * 81000.0));
        }
    }

    public class CellBuilder {
        protected final MEStorage inv;

        public CellBuilder(MEStorage inv) {
            this.inv = inv;
        }

        public void add(GenericStack stack) {
            this.add(stack.what(), stack.amount());
        }

        public void add(AEKey what, long amount) {
            if (this.inv.insert(what, amount, Actionable.MODULATE, new BaseActionSource()) != amount) {
                throw new IllegalArgumentException("Couldn't insert " + amount + " of " + what);
            }
        }

        public DriveBuilder and() {
            return DriveBuilder.this;
        }
    }
}

