/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.IGridConnectedBlockEntity;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_4512;
import net.minecraft.class_4516;
import net.minecraft.class_4517;
import org.jetbrains.annotations.Nullable;

public class PlotTestHelper
extends class_4516 {
    private final class_2338 plotTranslation;

    public PlotTestHelper(class_2338 plotTranslation, class_4517 gameTestInfo) {
        super(gameTestInfo);
        this.plotTranslation = plotTranslation;
    }

    public class_2338 method_36052(class_2338 pos) {
        return super.method_36052(pos.method_10081((class_2382)this.plotTranslation).method_10069(0, 1, 0));
    }

    public class_2338 method_36054(class_2338 pos) {
        return super.method_36054(pos).method_10069(-this.plotTranslation.method_10263(), -this.plotTranslation.method_10264(), -this.plotTranslation.method_10260()).method_10069(0, -1, 0);
    }

    public class_243 method_35978(class_243 relativeVec3) {
        return super.method_35978(relativeVec3).method_1031((double)this.plotTranslation.method_10263(), (double)this.plotTranslation.method_10264(), (double)this.plotTranslation.method_10260());
    }

    public <T extends AEBasePart> T getPart(class_2338 pos, @Nullable class_2350 side, Class<T> partClass) {
        class_2586 be = this.method_36014(pos);
        if (!(be instanceof IPartHost)) {
            this.method_35997("not a part host", pos);
            return null;
        }
        IPartHost partHost = (IPartHost)be;
        IPart part = partHost.getPart(side);
        if (part == null) {
            this.method_35997("part missing", pos);
        }
        if (!partClass.isInstance(part)) {
            this.method_35997("wrong part", pos);
        }
        return (T)((AEBasePart)partClass.cast(part));
    }

    public IGrid getGrid(class_2338 pos) {
        this.checkAllInitialized();
        class_2586 be = this.method_36014(pos);
        if (be instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity gridConnectedBlockEntity = (IGridConnectedBlockEntity)be;
            return gridConnectedBlockEntity.getMainNode().getGrid();
        }
        IInWorldGridNodeHost nodeHost = GridHelper.getNodeHost((class_1936)this.method_35943(), this.method_36052(pos));
        if (nodeHost != null) {
            for (class_2350 side : class_2350.values()) {
                IGridNode node = nodeHost.getGridNode(side);
                if (node == null) continue;
                return node.getGrid();
            }
        }
        throw new class_4512("No grid @ " + pos);
    }

    public void checkAllInitialized() {
        this.method_35998(blockPos -> {
            class_2586 be = this.method_36014((class_2338)blockPos);
            if (be instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity gridConnectedBlockEntity = (IGridConnectedBlockEntity)be;
                this.check(gridConnectedBlockEntity.getMainNode().isReady(), "BE " + be + " is not ready");
            } else if (be instanceof IPartHost) {
                IPartHost partHost = (IPartHost)be;
                for (class_2350 side : Platform.DIRECTIONS_WITH_NULL) {
                    IPart part = partHost.getPart(side);
                    if (!(part instanceof AEBasePart)) continue;
                    AEBasePart basePart = (AEBasePart)part;
                    IManagedGridNode mainNode = basePart.getMainNode();
                    this.check(mainNode.isReady(), "Part " + part + " is not ready");
                }
            }
        });
    }

    public void assertContains(IGrid grid, class_1792 item) {
        MEStorage storage = grid.getStorageService().getInventory();
        this.assertContains(storage, AEItemKey.of((class_1935)item));
    }

    public void assertContains(MEStorage storage, AEKey key) {
        long count = storage.getAvailableStacks().get(key);
        if (count <= 0L) {
            throw new class_4512("Network storage does not contain " + key + ". Available keys: " + storage.getAvailableStacks().keySet());
        }
    }

    public void assertContainsNot(MEStorage storage, AEKey key) {
        long count = storage.getAvailableStacks().get(key);
        if (count > 0L) {
            throw new class_4512("Network storage does contains " + key + ".");
        }
    }

    public void clearStorage(IGrid grid) {
        this.clearStorage(grid.getStorageService().getInventory());
    }

    public void clearStorage(MEStorage storage) {
        KeyCounter counter = storage.getAvailableStacks();
        for (AEKey key : counter.keySet()) {
            storage.extract(key, Long.MAX_VALUE, Actionable.MODULATE, new BaseActionSource());
        }
    }

    public void assertEquals(class_2338 ref, Object expected, Object actual) {
        if (!Objects.equals(expected, actual)) {
            String message = actual + " was not " + expected;
            this.method_35997(message, ref);
        }
    }

    public void check(boolean test, String errorMessage) throws class_4512 {
        if (!test) {
            throw new class_4512(errorMessage);
        }
    }

    public KeyCounter countContainerContentAt(class_2338 pos) {
        KeyCounter counter = new KeyCounter();
        this.countContainerContentAt(pos, counter);
        return counter;
    }

    public void countContainerContentAt(class_2338 pos, KeyCounter counter) {
        class_2624 container = (class_2624)this.method_36014(pos);
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 item = container.method_5438(i);
            if (item.method_7960()) continue;
            counter.add(AEItemKey.of(item), item.method_7947());
        }
    }
}

