/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.server.services.compass.CompassService;
import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.MeteoritePlacer;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6625;

public class MeteoriteStructurePiece
extends class_3443 {
    public static final class_3773 TYPE = class_3773.method_16813(MeteoriteStructurePiece::new, (String)"ae2mtrt");
    private final PlacedMeteoriteSettings settings;

    public static void register() {
    }

    protected MeteoriteStructurePiece(class_2338 center, float coreRadius, CraterType craterType, FalloutMode fallout, boolean pureCrater, boolean craterLake) {
        super(TYPE, 0, MeteoriteStructurePiece.createBoundingBox(center));
        this.settings = new PlacedMeteoriteSettings(center, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    private static class_3341 createBoundingBox(class_2338 origin) {
        int range = 64;
        class_1923 chunkPos = new class_1923(origin);
        return new class_3341(chunkPos.method_8326() - range, origin.method_10264(), chunkPos.method_8328() - range, chunkPos.method_8327() + range, origin.method_10264(), chunkPos.method_8329() + range);
    }

    public MeteoriteStructurePiece(class_2487 tag) {
        super(TYPE, tag);
        class_2338 center = class_2338.method_10092((long)tag.method_10537("c"));
        float coreRadius = tag.method_10583("r");
        CraterType craterType = CraterType.values()[tag.method_10571("t")];
        FalloutMode fallout = FalloutMode.values()[tag.method_10571("f")];
        boolean pureCrater = tag.method_10577("p");
        boolean craterLake = tag.method_10577("l");
        this.settings = new PlacedMeteoriteSettings(center, coreRadius, craterType, fallout, pureCrater, craterLake);
    }

    public boolean isFinalized() {
        return this.settings.getCraterType() != null;
    }

    public PlacedMeteoriteSettings getSettings() {
        return this.settings;
    }

    protected void method_14943(class_6625 context, class_2487 tag) {
        tag.method_10548("r", this.settings.getMeteoriteRadius());
        tag.method_10544("c", this.settings.getPos().method_10063());
        tag.method_10567("t", (byte)this.settings.getCraterType().ordinal());
        tag.method_10567("f", (byte)this.settings.getFallout().ordinal());
        tag.method_10556("p", this.settings.isPureCrater());
        tag.method_10556("l", this.settings.isCraterLake());
    }

    public void method_14931(class_5281 level, class_5138 featureManager, class_2794 chunkGeneratorIn, Random rand, class_3341 bounds, class_1923 chunkPos, class_2338 centerPos) {
        MeteoritePlacer placer = new MeteoritePlacer((class_1936)level, this.settings, bounds, rand);
        placer.place();
        CompassService.updateArea(level.method_8410(), level.method_8392(chunkPos.field_9181, chunkPos.field_9180));
    }
}

