/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.DeathEffectConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.core.ModTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.lizardofoz.inventorio.api.InventorioAPI;
import me.lizardofoz.inventorio.player.PlayerInventoryAddon;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class InventorioCompat
implements YigdApi {
    @Override
    public String getModName() {
        return "inventorio";
    }

    @Override
    public Object getInventory(class_1657 player, boolean onDeath, @Nullable DeathEffectConfig onDeathHandling) {
        class_2371 inventories = class_2371.method_10211();
        PlayerInventoryAddon inventoryAddon = InventorioAPI.getInventoryAddon((class_1657)player);
        List<String> soulboundEnchantments = YigdConfig.getConfig().graveSettings.soulboundEnchantments;
        List<String> deleteEnchantments = YigdConfig.getConfig().graveSettings.deleteEnchantments;
        if (inventoryAddon == null) {
            return inventories;
        }
        for (int i = 0; i < inventoryAddon.method_5439(); ++i) {
            class_1799 stack = inventoryAddon.method_5438(i);
            inventories.add((Object)stack);
        }
        if (onDeath) {
            class_2371<class_1799> soulboundItems = GraveHelper.getEnchantedItems((class_2371<class_1799>)inventories, soulboundEnchantments);
            for (class_1799 stack : soulboundItems) {
                GraveHelper.removeEnchantmentLevel(stack, soulboundEnchantments);
            }
            GraveHelper.removeFromList((class_2371<class_1799>)inventories, soulboundItems);
            for (int i = 0; i < inventories.size(); ++i) {
                class_1799 stack;
                stack = (class_1799)inventories.get(i);
                if (!stack.method_31573(ModTags.SOULBOUND_ITEM) && onDeathHandling != DeathEffectConfig.KEEP_ITEMS && !GraveHelper.hasBotaniaKeepIvy(stack, true)) continue;
                soulboundItems.set(i, (Object)stack);
            }
            class_2371<class_1799> deletedItems = GraveHelper.getEnchantedItems((class_2371<class_1799>)inventories, deleteEnchantments);
            GraveHelper.removeFromList((class_2371<class_1799>)inventories, deletedItems);
            DeadPlayerData.Soulbound.addModdedSoulbound(player.method_5667(), soulboundItems.stream().toList());
        }
        return inventories.stream().toList();
    }

    @Override
    public class_2371<class_1799> setInventory(Object inventory, class_1657 player) {
        class_2371 extraItems = class_2371.method_10211();
        if (!(inventory instanceof List)) {
            return extraItems;
        }
        List inventories = (List)inventory;
        PlayerInventoryAddon inventoryAddon = InventorioAPI.getInventoryAddon((class_1657)player);
        if (inventoryAddon == null) {
            return extraItems;
        }
        inventoryAddon.setSelectedUtility(4);
        for (int i = 0; i < inventories.size(); ++i) {
            class_1799 stack = (class_1799)inventories.get(i);
            if (inventoryAddon.method_5438(i).method_7960()) {
                inventoryAddon.method_5447(i, stack);
                continue;
            }
            extraItems.add((Object)stack);
        }
        return extraItems;
    }

    @Override
    public int getInventorySize(Object inventory) {
        if (!(inventory instanceof List)) {
            return 0;
        }
        List modInv = (List)inventory;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1799 stack : modInv) {
            if (stack == null || stack.method_7960()) continue;
            items.add(stack);
        }
        return items.size();
    }

    @Override
    public void dropAll(class_1657 player) {
        PlayerInventoryAddon inventoryAddon = InventorioAPI.getInventoryAddon((class_1657)player);
        if (inventoryAddon == null) {
            return;
        }
        inventoryAddon.method_5448();
    }

    @Override
    public List<class_1799> toStackList(Object inventory) {
        if (!(inventory instanceof List)) {
            return new ArrayList<class_1799>(0);
        }
        List stacks = (List)inventory;
        ArrayList<class_1799> newList = new ArrayList<class_1799>();
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            newList.add(stack);
        }
        return newList;
    }

    @Override
    public class_2487 writeNbt(Object o) {
        if (!(o instanceof List)) {
            return new class_2487();
        }
        List items = (List)o;
        class_2371 stacks = class_2371.method_10211();
        stacks.addAll((Collection)items);
        class_2487 nbt = class_1262.method_5426((class_2487)new class_2487(), (class_2371)stacks);
        nbt.method_10569("size", stacks.size());
        return nbt;
    }

    @Override
    public Object readNbt(class_2487 nbt) {
        int size = nbt.method_10550("size");
        class_2371 items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, (class_2371)items);
        return items.stream().toList();
    }
}

