/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.item;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.GraveKeySpecificationConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public class KeyItem
extends class_1792 {
    public KeyItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1));
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        KeyItem.linkToPlayer(player.method_5667(), stack);
        super.method_7843(stack, world, player);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return super.method_7836(world, user, hand);
        }
        YigdConfig.GraveKeySettings keySettings = YigdConfig.getConfig().utilitySettings.graveKeySettings;
        if (keySettings.rebindable && user.method_5715()) {
            class_1799 stack = user.method_5998(hand);
            boolean setNbt = KeyItem.linkToPlayer(user.method_5667(), stack);
            if (setNbt) {
                return class_1271.method_22427((Object)stack);
            }
        }
        return super.method_7836(world, user, hand);
    }

    public static boolean linkToPlayer(UUID playerId, class_1799 stack) {
        DeadPlayerData graveData;
        List<DeadPlayerData> data = DeathInfoManager.INSTANCE.data.get(playerId);
        if (data == null || data.size() <= 0) {
            return false;
        }
        int i = data.size();
        while ((graveData = data.get(--i)) != null && graveData.availability != 1) {
        }
        if (graveData == null) {
            return false;
        }
        return KeyItem.linkToPlayer(playerId, stack, graveData.id);
    }

    public static boolean linkToPlayer(UUID playerId, class_1799 stack, UUID graveId) {
        class_2487 nbt = new class_2487();
        nbt.method_25927("user", playerId);
        nbt.method_25927("grave", graveId);
        class_2487 stackNbt = stack.method_7969();
        if (stackNbt != null) {
            stackNbt.method_10543(nbt);
        } else {
            stack.method_7980(nbt);
        }
        return true;
    }

    public static boolean isKeyForGrave(class_1799 keyStack, GraveBlockEntity grave) {
        YigdConfig.GraveKeySettings graveKeySettings = YigdConfig.getConfig().utilitySettings.graveKeySettings;
        if (graveKeySettings.enableKeys && keyStack.method_7909().equals(Yigd.KEY_ITEM)) {
            class_2487 keyNbt = keyStack.method_7969();
            boolean matching = switch (graveKeySettings.graveKeySpecification) {
                case GraveKeySpecificationConfig.ALL -> true;
                case GraveKeySpecificationConfig.PLAYER -> keyNbt != null && grave.getGraveOwner().getId().equals(keyNbt.method_25926("user"));
                case GraveKeySpecificationConfig.GRAVE -> keyNbt != null && grave.getGraveId().equals(keyNbt.method_25926("grave"));
                default -> false;
            };
            if (matching) {
                keyStack.method_7934(1);
            }
            return matching;
        }
        return false;
    }

    public static void giveStackToPlayer(class_1657 player, UUID graveId) {
        KeyItem.giveStackToPlayer(player, player.method_5667(), graveId);
    }

    public static void giveStackToPlayer(class_1657 player, UUID playerId, UUID graveId) {
        if (!YigdConfig.getConfig().utilitySettings.graveKeySettings.enableKeys) {
            return;
        }
        class_1799 stack = Yigd.KEY_ITEM.method_7854();
        boolean linked = KeyItem.linkToPlayer(playerId, stack, graveId);
        if (linked) {
            player.method_7270(stack);
        }
    }
}

