/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.gui.BetterAdvancementTab;
import betteradvancements.gui.BetterAdvancementWidget;
import betteradvancements.platform.Services;
import betteradvancements.reference.Resources;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2859;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_632;
import net.minecraft.class_634;
import net.minecraft.class_757;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BetterAdvancementsScreen
extends class_437
implements class_632.class_633 {
    private static final class_2561 VERY_SAD_LABEL = new class_2588("advancements.sad_label");
    private static final class_2561 NO_ADVANCEMENTS_LABEL = new class_2588("advancements.empty");
    private static final class_2561 TITLE = new class_2588("gui.advancements");
    private static final int WIDTH = 252;
    private static final int HEIGHT = 140;
    private static final int CORNER_SIZE = 30;
    private static final int SIDE = 30;
    private static final int TOP = 40;
    private static final int BOTTOM = 30;
    private static final int PADDING = 9;
    private static final float MIN_ZOOM = 1.0f;
    private static final float MAX_ZOOM = 2.0f;
    private static final float ZOOM_STEP = 0.2f;
    private final class_632 clientAdvancements;
    private final Map<class_161, BetterAdvancementTab> tabs = Maps.newLinkedHashMap();
    private BetterAdvancementTab selectedTab;
    private float zoom = 1.0f;
    private boolean isScrolling;
    protected int internalWidth;
    protected int internalHeight;
    public static int uiScaling = 100;
    public static boolean showDebugCoordinates = false;
    public static boolean orderTabsAlphabetically = false;
    private BetterAdvancementWidget advConnectedToMouse = null;

    public BetterAdvancementsScreen(class_632 clientAdvancements) {
        super(class_333.field_18967);
        this.clientAdvancements = clientAdvancements;
    }

    protected void method_25426() {
        this.internalHeight = this.field_22790 * uiScaling / 100;
        this.internalWidth = this.field_22789 * uiScaling / 100;
        this.tabs.clear();
        this.selectedTab = null;
        this.clientAdvancements.method_2862((class_632.class_633)this);
        if (this.selectedTab == null && !this.tabs.isEmpty()) {
            this.clientAdvancements.method_2864(this.tabs.values().iterator().next().getAdvancement(), true);
        } else {
            this.clientAdvancements.method_2864(this.selectedTab == null ? null : this.selectedTab.getAdvancement(), true);
        }
    }

    public void method_25419() {
        this.clientAdvancements.method_2862(null);
        class_634 clientpacketlistener = this.field_22787.method_1562();
        if (clientpacketlistener != null) {
            clientpacketlistener.method_2883((class_2596)class_2859.method_12414());
        }
        super.method_25419();
    }

    public boolean method_25402(double mouseX, double mouseY, int modifiers) {
        if (modifiers == 0) {
            int left = 30 + (this.field_22789 - this.internalWidth) / 2;
            int top = 40 + (this.field_22790 - this.internalHeight) / 2;
            for (BetterAdvancementTab betterAdvancementTabGui : this.tabs.values()) {
                if (!betterAdvancementTabGui.isMouseOver(left, top, this.internalWidth - 60, this.internalHeight - top - 30, mouseX, mouseY)) continue;
                this.clientAdvancements.method_2864(betterAdvancementTabGui.getAdvancement(), true);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        int wheel = (int)scroll;
        if (wheel < 0 && this.zoom > 1.0f) {
            this.zoom -= 0.2f;
        } else if (wheel > 0 && this.zoom < 2.0f) {
            this.zoom += 0.2f;
        }
        return super.method_25401(mouseX, mouseY, scroll);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1844.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507(null);
            this.field_22787.field_1729.method_1612();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDeltaX, double mouseDeltaY) {
        int left = 30 + (this.field_22789 - this.internalWidth) / 2;
        int top = 40 + (this.field_22790 - this.internalHeight) / 2;
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            if (this.advConnectedToMouse == null) {
                boolean inGui;
                boolean bl = inGui = mouseX < (double)(left + this.internalWidth - 60 - 9) && mouseX > (double)(left + 9) && mouseY < (double)(top + this.internalHeight - 40 + 1) && mouseY > (double)(top + 18);
                if (this.selectedTab != null && inGui) {
                    for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.guis.values()) {
                        if (!betterAdvancementEntryScreen.isMouseOver(this.selectedTab.scrollX, this.selectedTab.scrollY, mouseX - (double)left - 9.0, mouseY - (double)top - 18.0) || !betterAdvancementEntryScreen.betterDisplayInfo.allowDragging()) continue;
                        this.advConnectedToMouse = betterAdvancementEntryScreen;
                        break;
                    }
                }
            } else {
                this.advConnectedToMouse.x = (int)Math.round((double)this.advConnectedToMouse.x + mouseDeltaX);
                this.advConnectedToMouse.y = (int)Math.round((double)this.advConnectedToMouse.y + mouseDeltaY);
            }
        } else {
            if (this.advConnectedToMouse != null) {
                Services.PLATFORM.getEventHelper().postAdvancementMovementEvent(this.advConnectedToMouse);
            }
            this.advConnectedToMouse = null;
        }
        if (this.advConnectedToMouse == null) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else if (this.selectedTab != null) {
                this.selectedTab.scroll(mouseDeltaX, mouseDeltaY, this.internalWidth - 60 - 27, this.internalHeight - 40 - 30 - 27);
            }
        }
        return true;
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        int left = 30 + (this.field_22789 - this.internalWidth) / 2;
        int top = 40 + (this.field_22790 - this.internalHeight) / 2;
        int right = this.internalWidth - 30 + (this.field_22789 - this.internalWidth) / 2;
        int bottom = this.internalHeight - 30 + (this.field_22790 - this.internalHeight) / 2;
        this.method_25420(poseStack);
        this.renderInside(poseStack, mouseX, mouseY, left, top, right, bottom);
        this.renderWindow(poseStack, left, top, right, bottom);
        if (this.advConnectedToMouse == null) {
            this.renderToolTips(poseStack, mouseX, mouseY, left, top, right, bottom);
        }
        if (this.advConnectedToMouse != null) {
            for (BetterAdvancementWidget betterAdvancementEntryScreen : this.selectedTab.guis.values()) {
                if (betterAdvancementEntryScreen == this.advConnectedToMouse) continue;
                int x1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3;
                int x2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3;
                int y1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY;
                int y2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                int centerX1 = betterAdvancementEntryScreen.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerX2 = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 13;
                int centerY1 = betterAdvancementEntryScreen.y + top + 18 + this.selectedTab.scrollY + 13;
                int centerY2 = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY + 13;
                double degrees = Math.toDegrees(Math.atan2(centerX1 - centerX2, centerY1 - centerY2));
                if (degrees < 0.0) {
                    degrees += 360.0;
                }
                if (betterAdvancementEntryScreen.x == this.advConnectedToMouse.x) {
                    if (y1 > y2) {
                        RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x1, y2 + 26 - 1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2, x2, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2, y1 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x2, y1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y2 + 26 - 1, x2 + 26 - 1, y1, 1.0, 65280);
                    }
                }
                if (betterAdvancementEntryScreen.y == this.advConnectedToMouse.y) {
                    if (x1 > x2) {
                        RenderUtil.drawRect(x2, y1, x1 + 26 - 1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1 + 26 - 1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                    } else {
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x1, y2, 1.0, 65280);
                        RenderUtil.drawRect(x2, y1, x2, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1, y1, x1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                        RenderUtil.drawRect(x2 + 26 - 1, y1 + 26 - 1, x1, y2 + 26 - 1, 1.0, 65280);
                    }
                }
                if (degrees != 45.0 && degrees != 135.0 && degrees != 225.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x1 + 26 - 1, y1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1 + 26 - 1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1, y1, x1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1, x1 + 26 - 1, y1 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2 + 26 - 1, y2, 1.0, 65280);
                RenderUtil.drawRect(x2, y2 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2, y2, x2, y2 + 26 - 1, 1.0, 65280);
                RenderUtil.drawRect(x2 + 26 - 1, y2, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
                if (degrees == 45.0 || degrees == 225.0) {
                    RenderUtil.drawRect(x1, y1 + 26 - 1, x2, y2 + 26 - 1, 1.0, 65280);
                    RenderUtil.drawRect(x1 + 26 - 1, y1, x2 + 26 - 1, y2, 1.0, 65280);
                    continue;
                }
                if (degrees != 135.0 && degrees != 315.0) continue;
                RenderUtil.drawRect(x1, y1, x2, y2, 1.0, 65280);
                RenderUtil.drawRect(x1 + 26 - 1, y1 + 26 - 1, x2 + 26 - 1, y2 + 26 - 1, 1.0, 65280);
            }
        }
        if (showDebugCoordinates && this.selectedTab != null && mouseX < this.internalWidth - 30 - 9 && mouseX > 39 && mouseY < this.internalHeight - top + 1 && mouseY > top + 18) {
            if (this.advConnectedToMouse != null) {
                int currentX = this.advConnectedToMouse.x + left + 9 + this.selectedTab.scrollX + 3 + 1;
                int n = this.advConnectedToMouse.y + top + 18 + this.selectedTab.scrollY;
                Objects.requireNonNull(this.field_22793);
                int currentY = n - 9 + 1;
                this.field_22793.method_1729(poseStack, this.advConnectedToMouse.x + "," + this.advConnectedToMouse.y, (float)currentX, (float)currentY, 0);
            } else {
                int xMouse = mouseX - left - 9;
                int yMouse = mouseY - top - 18;
                int currentX = xMouse - this.selectedTab.scrollX - 3 - 1;
                int currentY = yMouse - this.selectedTab.scrollY - 1;
                String string = currentX + "," + currentY;
                float f = mouseX;
                Objects.requireNonNull(this.field_22793);
                this.field_22793.method_1729(poseStack, string, f, (float)(mouseY - 9), 0);
            }
        }
    }

    private void renderInside(class_4587 poseStack, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        BetterAdvancementTab betterAdvancementTab = this.selectedTab;
        int boxLeft = left + 9;
        int boxTop = top + 18;
        int boxRight = right - 9;
        int boxBottom = bottom - 9;
        int width = boxRight - boxLeft;
        int height = boxBottom - boxTop;
        if (betterAdvancementTab == null) {
            BetterAdvancementsScreen.method_25294((class_4587)poseStack, (int)boxLeft, (int)boxTop, (int)boxRight, (int)boxBottom, (int)-16777216);
            float f = boxLeft + (width - this.field_22793.method_27525((class_5348)NO_ADVANCEMENTS_LABEL)) / 2;
            int n = boxTop + height / 2;
            Objects.requireNonNull(this.field_22793);
            this.field_22793.method_30883(poseStack, NO_ADVANCEMENTS_LABEL, f, (float)(n - 9), -1);
            float f2 = boxLeft + (width - this.field_22793.method_27525((class_5348)VERY_SAD_LABEL)) / 2;
            int n2 = boxTop + height / 2;
            Objects.requireNonNull(this.field_22793);
            this.field_22793.method_30883(poseStack, VERY_SAD_LABEL, f2, (float)(n2 + 9), -1);
        } else {
            class_4587 viewMatrixPoseStack = RenderSystem.getModelViewStack();
            viewMatrixPoseStack.method_22903();
            viewMatrixPoseStack.method_22904((double)boxLeft, (double)boxTop, 0.0);
            RenderSystem.applyModelViewMatrix();
            betterAdvancementTab.drawContents(poseStack, width, height);
            viewMatrixPoseStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        }
    }

    public void renderWindow(class_4587 poseStack, int left, int top, int right, int bottom) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)Resources.Gui.WINDOW);
        this.method_25302(poseStack, left, top, 0, 0, 30, 30);
        RenderUtil.renderRepeating((class_332)this, poseStack, left + 30, top, this.internalWidth - 30 - 60 - 30, 30, 30, 0, 192, 30);
        this.method_25302(poseStack, right - 30, top, 222, 0, 30, 30);
        RenderUtil.renderRepeating((class_332)this, poseStack, left, top + 30, 30, bottom - top - 60, 0, 30, 30, 80);
        RenderUtil.renderRepeating((class_332)this, poseStack, right - 30, top + 30, 30, bottom - top - 60, 222, 30, 30, 80);
        this.method_25302(poseStack, left, bottom - 30, 0, 110, 30, 30);
        RenderUtil.renderRepeating((class_332)this, poseStack, left + 30, bottom - 30, this.internalWidth - 30 - 60 - 30, 30, 30, 110, 192, 30);
        this.method_25302(poseStack, right - 30, bottom - 30, 222, 110, 30, 30);
        if (this.tabs.size() > 1) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)Resources.Gui.TABS);
            int width = right - left;
            int height = bottom - top;
            for (BetterAdvancementTab tab : this.tabs.values()) {
                tab.drawTab(poseStack, left, top, width, height, tab == this.selectedTab);
            }
            RenderSystem.defaultBlendFunc();
            for (BetterAdvancementTab tab : this.tabs.values()) {
                tab.drawIcon(poseStack, left, top, width, height, this.field_22788);
            }
            RenderSystem.disableBlend();
        }
        class_5481 windowTitle = TITLE.method_30937();
        if (this.selectedTab != null) {
            windowTitle = class_5481.method_34909((class_5481[])new class_5481[]{windowTitle, new class_2585(" - ").method_30937(), this.selectedTab.getTitle().method_30937()});
        }
        this.field_22793.method_27528(poseStack, windowTitle, (float)(left + 8), (float)(top + 6), 0x404040);
    }

    private void renderToolTips(class_4587 poseStack, int mouseX, int mouseY, int left, int top, int right, int bottom) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            class_4587 viewMatrixPoseStack = RenderSystem.getModelViewStack();
            viewMatrixPoseStack.method_22903();
            viewMatrixPoseStack.method_22904((double)(left + 9), (double)(top + 18), 400.0);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.enableDepthTest();
            this.selectedTab.drawToolTips(poseStack, mouseX - left - 9, mouseY - top - 18, left, top, right - left - 18, bottom - top - 27);
            RenderSystem.disableDepthTest();
            viewMatrixPoseStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
        int width = right - left;
        int height = bottom - top;
        if (this.tabs.size() > 1) {
            for (BetterAdvancementTab tab : this.tabs.values()) {
                if (!tab.isMouseOver(left, top, width, height, mouseX, mouseY)) continue;
                this.method_25424(poseStack, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void method_723(@Nonnull class_161 advancement) {
        BetterAdvancementTab betterAdvancementTabGui = BetterAdvancementTab.create(this.field_22787, this, this.tabs.size(), advancement, this.internalWidth - 60, this.internalHeight - 40 - 30);
        if (betterAdvancementTabGui != null) {
            this.tabs.put(advancement, betterAdvancementTabGui);
        }
    }

    public void method_720(@Nonnull class_161 advancement) {
    }

    public void method_721(@Nonnull class_161 advancement) {
        BetterAdvancementTab betterAdvancementTabGui = this.getTab(advancement);
        if (betterAdvancementTabGui != null) {
            betterAdvancementTabGui.addAdvancement(advancement);
        }
    }

    public void method_719(@Nonnull class_161 advancement) {
    }

    public void method_2865(@Nonnull class_161 advancement, @Nonnull class_167 advancementProgress) {
        BetterAdvancementWidget betterAdvancementEntryScreen = this.getAdvancementGui(advancement);
        if (betterAdvancementEntryScreen != null) {
            betterAdvancementEntryScreen.getAdvancementProgress(advancementProgress);
        }
    }

    public void method_2866(@Nullable class_161 advancement) {
        if (this.selectedTab != null) {
            this.selectedTab.storeScroll();
        }
        this.selectedTab = this.tabs.get(advancement);
        if (this.selectedTab != null) {
            this.selectedTab.loadScroll();
        }
    }

    public void method_722() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public BetterAdvancementWidget getAdvancementGui(class_161 advancement) {
        BetterAdvancementTab betterAdvancementTab = this.getTab(advancement);
        return betterAdvancementTab == null ? null : betterAdvancementTab.getWidget(advancement);
    }

    @Nullable
    private BetterAdvancementTab getTab(@Nonnull class_161 advancement) {
        while (advancement.method_687() != null) {
            advancement = advancement.method_687();
        }
        return this.tabs.get(advancement);
    }
}

