/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.util;

import betteradvancements.util.CriteriaDetail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_178;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_5250;

public class CriterionGrid {
    public static CriteriaDetail detailLevel = CriteriaDetail.DEFAULT;
    public static boolean requiresShift = false;
    private static final CriterionGrid empty = new CriterionGrid();
    private final List<String> cellContents;
    private final int[] cellWidths;
    private final int fontHeight;
    private final int numColumns;
    public final int numRows;
    public List<Column> columns;
    public int width;
    public int height;

    private CriterionGrid() {
        this.cellContents = Collections.emptyList();
        this.cellWidths = new int[0];
        this.fontHeight = 0;
        this.numColumns = 0;
        this.numRows = 0;
        this.columns = Collections.emptyList();
        this.width = 0;
        this.height = 0;
    }

    public CriterionGrid(List<String> cellContents, int[] cellWidths, int fontHeight, int numColumns) {
        this.cellContents = cellContents;
        this.cellWidths = cellWidths;
        this.fontHeight = fontHeight;
        this.numColumns = numColumns;
        this.numRows = (int)Math.ceil((double)cellContents.size() / (double)numColumns);
    }

    public void init() {
        this.columns = new ArrayList<Column>();
        this.width = 0;
        for (int c = 0; c < this.numColumns; ++c) {
            int cellIndex;
            ArrayList<String> column = new ArrayList<String>();
            int columnWidth = 0;
            for (int r = 0; r < this.numRows && (cellIndex = c * this.numRows + r) < this.cellContents.size(); ++r) {
                String str = this.cellContents.get(cellIndex);
                column.add(str);
                columnWidth = Math.max(columnWidth, this.cellWidths[cellIndex]);
            }
            this.columns.add(new Column(column, columnWidth));
            this.width += columnWidth;
        }
        this.height = this.numRows * this.fontHeight;
    }

    public static CriterionGrid findOptimalCriterionGrid(class_161 advancement, class_167 progress, int maxWidth, class_327 font) {
        if (progress == null || progress.method_740() || detailLevel.equals((Object)CriteriaDetail.OFF)) {
            return empty;
        }
        Map criteria = advancement.method_682();
        if (criteria.size() <= 1) {
            return empty;
        }
        int numUnobtained = 0;
        ArrayList<String> cellContents = new ArrayList<String>();
        for (String criterion : criteria.keySet()) {
            class_5250 text2;
            class_5250 text;
            class_178 criterionProgress = progress.method_737(criterion);
            if (criterionProgress != null && criterionProgress.method_784()) {
                if (!detailLevel.showObtained()) continue;
                text = new class_2585(" + ").method_27692(class_124.field_1060);
                text2 = new class_2585(criterion).method_27692(class_124.field_1068);
                text.method_10852((class_2561)text2);
                cellContents.add(text.getString());
                continue;
            }
            if (detailLevel.showUnobtained()) {
                text = new class_2585(" x ").method_27692(class_124.field_1079);
                text2 = new class_2585(criterion).method_27692(class_124.field_1068);
                text.method_10852((class_2561)text2);
                cellContents.add(text.getString());
            }
            ++numUnobtained;
        }
        if (!detailLevel.showUnobtained()) {
            class_5250 text = new class_2585(" x ").method_27692(class_124.field_1079);
            class_5250 text2 = new class_2585(numUnobtained + " remaining").method_27695(new class_124[]{class_124.field_1068, class_124.field_1056});
            text.method_10852((class_2561)text2);
            cellContents.add(text.getString());
        }
        int[] cellWidths = new int[cellContents.size()];
        for (int i = 0; i < cellWidths.length; ++i) {
            cellWidths[i] = font.method_1727((String)cellContents.get(i));
        }
        int numCols = 0;
        CriterionGrid prevGrid = null;
        CriterionGrid currGrid = null;
        do {
            Objects.requireNonNull(font);
            CriterionGrid newGrid = new CriterionGrid(cellContents, cellWidths, 9, ++numCols);
            if (prevGrid != null && newGrid.numRows == prevGrid.numRows) continue;
            newGrid.init();
            prevGrid = currGrid;
            currGrid = newGrid;
        } while (numCols <= cellContents.size() && currGrid.width <= maxWidth);
        return prevGrid != null ? prevGrid : currGrid;
    }

    public class Column {
        public final List<String> cells;
        public final int width;

        public Column(List<String> cells, int width) {
            this.cells = cells;
            this.width = width;
        }
    }
}

