/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.architectury.fluid.FluidStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ui.fabric.SelectFluidScreenImpl;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.ButtonListBaseScreen;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class SelectFluidScreen
extends ButtonListBaseScreen {
    private final FluidConfig config;
    private final ConfigCallback callback;

    public SelectFluidScreen(FluidConfig c, ConfigCallback cb) {
        this.setTitle((class_2561)new class_2588("ftblibrary.select_fluid.gui"));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = cb;
    }

    @Override
    public void addButtons(Panel panel) {
        if (this.config.allowEmpty) {
            FluidStack fluidStack = FluidStack.create((class_3611)class_3612.field_15906, (long)FluidStack.bucketAmount());
            panel.add(new SimpleTextButton(panel, fluidStack.getName(), ItemIcon.getItemIcon(class_1802.field_8550)){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    SelectFluidScreen.this.config.setCurrentValue(class_3612.field_15906);
                    SelectFluidScreen.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return FluidStack.create((class_3611)class_3612.field_15906, (long)FluidStack.bucketAmount());
                }
            });
        }
        for (final class_3611 fluid : class_2378.field_11154) {
            if (fluid == class_3612.field_15906 || fluid.method_15785().method_15771()) continue;
            FluidStack fluidStack = FluidStack.create((class_3611)fluid, (long)FluidStack.bucketAmount());
            panel.add(new SimpleTextButton(panel, fluidStack.getName(), Icon.getIcon(SelectFluidScreen.getStillTexture(fluidStack)).withTint(Color4I.rgb(SelectFluidScreen.getColor(fluidStack)))){

                @Override
                public void onClicked(MouseButton button) {
                    this.playClickSound();
                    SelectFluidScreen.this.config.setCurrentValue(fluid);
                    SelectFluidScreen.this.callback.save(true);
                }

                @Override
                public Object getIngredientUnderMouse() {
                    return FluidStack.create((class_3611)fluid, (long)FluidStack.bucketAmount());
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static class_2960 getStillTexture(FluidStack stack) {
        return SelectFluidScreenImpl.getStillTexture(stack);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static int getColor(FluidStack stack) {
        return SelectFluidScreenImpl.getColor(stack);
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }
}

