/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.client;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.bases.McdwCrossbow;
import chronosacaria.mcdw.bases.McdwLongbow;
import chronosacaria.mcdw.bases.McdwShield;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.enchants.EnchantsRegistry;
import chronosacaria.mcdw.enchants.summons.registry.SummonedEntityRegistry;
import chronosacaria.mcdw.enchants.summons.render.SummonedBeeRenderer;
import chronosacaria.mcdw.enums.BowsID;
import chronosacaria.mcdw.enums.CrossbowsID;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.LongbowsID;
import chronosacaria.mcdw.enums.ShieldsID;
import chronosacaria.mcdw.enums.ShortbowsID;
import chronosacaria.mcdw.particles.ParticlesInit;
import chronosacaria.mcdw.statuseffects.StatusEffectsRegistry;
import java.util.Arrays;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5272;

@Environment(value=EnvType.CLIENT)
public class McdwClient
implements ClientModInitializer {
    public void onInitializeClient() {
        EntityRendererRegistry.register(SummonedEntityRegistry.SUMMONED_BEE_ENTITY, SummonedBeeRenderer::new);
        ParticlesInit.initializeOnClient();
        Arrays.stream(BowsID.values()).forEach(bowsID -> McdwClient.registerBowPredicates(bowsID.getItem()));
        Arrays.stream(ShortbowsID.values()).forEach(shortBowsID -> McdwClient.registerShortBowPredicates(shortBowsID.getItem()));
        Arrays.stream(LongbowsID.values()).forEach(longBowsID -> McdwClient.registerLongBowPredicates(longBowsID.getItem()));
        Arrays.stream(CrossbowsID.values()).forEach(crossbowsID -> McdwClient.registerCrossbowPredicates(crossbowsID.getItem()));
        Arrays.stream(ShieldsID.values()).forEach(shieldsID -> McdwClient.registerShieldPredicates(shieldsID.getItem()));
    }

    public static void registerBowPredicates(McdwBow bow) {
        class_5272.method_27879((class_1792)bow, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
            int overchargeLevel;
            int accelerateLevel;
            if (livingEntity == null) {
                return 0.0f;
            }
            int useTicks = itemStack.method_7935() - livingEntity.method_6014();
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.ACCELERATE).booleanValue() && (accelerateLevel = class_1890.method_8225((class_1887)EnchantsRegistry.ACCELERATE, (class_1799)itemStack)) > 0) {
                class_1293 accelerateInstance = livingEntity.method_6112(StatusEffectsRegistry.ACCELERATE);
                int consecutiveShots = accelerateInstance != null ? accelerateInstance.method_5578() + 1 : 0;
                useTicks = (int)((float)useTicks * (1.0f + class_3532.method_15363((float)((float)consecutiveShots * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f));
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.OVERCHARGE).booleanValue() && (overchargeLevel = class_1890.method_8225((class_1887)EnchantsRegistry.OVERCHARGE, (class_1799)itemStack)) > 0) {
                int overcharge = (int)Math.min((float)useTicks / bow.getDrawSpeed() - 1.0f, (float)overchargeLevel);
                useTicks = overcharge == overchargeLevel ? useTicks : (int)((float)useTicks % bow.getDrawSpeed());
            }
            return livingEntity.method_6030() != itemStack ? 0.0f : (float)useTicks / bow.getDrawSpeed();
        });
        class_5272.method_27879((class_1792)bow, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerShortBowPredicates(McdwShortbow bow) {
        class_5272.method_27879((class_1792)bow, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
            int overchargeLevel;
            int accelerateLevel;
            if (livingEntity == null) {
                return 0.0f;
            }
            int useTicks = itemStack.method_7935() - livingEntity.method_6014();
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.ACCELERATE).booleanValue() && (accelerateLevel = class_1890.method_8225((class_1887)EnchantsRegistry.ACCELERATE, (class_1799)itemStack)) > 0) {
                class_1293 accelerateInstance = livingEntity.method_6112(StatusEffectsRegistry.ACCELERATE);
                int consecutiveShots = accelerateInstance != null ? accelerateInstance.method_5578() + 1 : 0;
                useTicks = (int)((float)useTicks * (1.0f + class_3532.method_15363((float)((float)consecutiveShots * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f));
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.OVERCHARGE).booleanValue() && (overchargeLevel = class_1890.method_8225((class_1887)EnchantsRegistry.OVERCHARGE, (class_1799)itemStack)) > 0) {
                int overcharge = (int)Math.min((float)useTicks / bow.getDrawSpeed() - 1.0f, (float)overchargeLevel);
                useTicks = overcharge == overchargeLevel ? useTicks : (int)((float)useTicks % bow.getDrawSpeed());
            }
            return livingEntity.method_6030() != itemStack ? 0.0f : (float)useTicks / bow.getDrawSpeed();
        });
        class_5272.method_27879((class_1792)bow, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerLongBowPredicates(McdwLongbow bow) {
        class_5272.method_27879((class_1792)bow, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
            int overchargeLevel;
            int accelerateLevel;
            if (livingEntity == null) {
                return 0.0f;
            }
            int useTicks = itemStack.method_7935() - livingEntity.method_6014();
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.ACCELERATE).booleanValue() && (accelerateLevel = class_1890.method_8225((class_1887)EnchantsRegistry.ACCELERATE, (class_1799)itemStack)) > 0) {
                class_1293 accelerateInstance = livingEntity.method_6112(StatusEffectsRegistry.ACCELERATE);
                int consecutiveShots = accelerateInstance != null ? accelerateInstance.method_5578() + 1 : 0;
                useTicks = (int)((float)useTicks * (1.0f + class_3532.method_15363((float)((float)consecutiveShots * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f));
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.OVERCHARGE).booleanValue() && (overchargeLevel = class_1890.method_8225((class_1887)EnchantsRegistry.OVERCHARGE, (class_1799)itemStack)) > 0) {
                int overcharge = (int)Math.min((float)useTicks / bow.getDrawSpeed() - 1.0f, (float)overchargeLevel);
                useTicks = overcharge == overchargeLevel ? useTicks : (int)((float)useTicks % bow.getDrawSpeed());
            }
            return livingEntity.method_6030() != itemStack ? 0.0f : (float)useTicks / bow.getDrawSpeed();
        });
        class_5272.method_27879((class_1792)bow, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    public static void registerCrossbowPredicates(McdwCrossbow crossbow) {
        class_5272.method_27879((class_1792)crossbow, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
            int accelerateLevel;
            if (livingEntity == null) {
                return 0.0f;
            }
            int useTicks = itemStack.method_7935() - livingEntity.method_6014();
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENABLE_ENCHANTMENTS.get((Object)EnchantmentsID.ACCELERATE).booleanValue() && (accelerateLevel = class_1890.method_8225((class_1887)EnchantsRegistry.ACCELERATE, (class_1799)itemStack)) > 0) {
                class_1293 accelerateInstance = livingEntity.method_6112(StatusEffectsRegistry.ACCELERATE);
                int consecutiveShots = accelerateInstance != null ? accelerateInstance.method_5578() + 1 : 0;
                useTicks = (int)((float)useTicks * (1.0f + class_3532.method_15363((float)((float)consecutiveShots * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f));
            }
            return McdwCrossbow.method_7781((class_1799)itemStack) ? 0.0f : (float)useTicks / (float)McdwCrossbow.method_7775((class_1799)itemStack);
        });
        class_5272.method_27879((class_1792)crossbow, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.method_6115() && livingEntity.method_6030() == itemStack && !McdwCrossbow.method_7781((class_1799)itemStack) ? 1.0f : 0.0f;
        });
        class_5272.method_27879((class_1792)crossbow, (class_2960)new class_2960("charged"), (itemStack, clientWorld, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return McdwCrossbow.method_7781((class_1799)itemStack) ? 1.0f : 0.0f;
        });
        class_5272.method_27879((class_1792)crossbow, (class_2960)new class_2960("firework"), (itemStack, clientWorld, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return McdwCrossbow.method_7781((class_1799)itemStack) && McdwCrossbow.method_7772((class_1799)itemStack, (class_1792)class_1802.field_8639) ? 1.0f : 0.0f;
        });
    }

    public static void registerShieldPredicates(McdwShield shield) {
        class_5272.method_27879((class_1792)shield, (class_2960)new class_2960("blocking"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }
}

