/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwSoulDagger;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMcdwWeaponID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.items.ItemsInit;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum SoulDaggersID implements IMcdwWeaponID,
IMeleeWeaponID
{
    DAGGER_ETERNAL_KNIFE((class_1832)class_1834.field_22033, 4, -2.8f, "minecraft:netherite_scrap"),
    DAGGER_SOUL_KNIFE((class_1832)class_1834.field_8923, 4, -2.8f, "minecraft:iron_ingot"),
    SWORD_TRUTHSEEKER((class_1832)class_1834.field_22033, 3, -2.8f, "minecraft:netherite_scrap");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SoulDaggersID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<SoulDaggersID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SOUL_DAGGERS_ENABLED;
    }

    public static EnumMap<SoulDaggersID, McdwSoulDagger> getItemsEnum() {
        return ItemsInit.SOUL_DAGGER_ITEMS;
    }

    public static HashMap<SoulDaggersID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SOUL_DAGGER_SPAWN_RATES;
    }

    public static HashMap<SoulDaggersID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.soulDaggerStats;
    }

    @Override
    public Boolean isEnabled() {
        return SoulDaggersID.getEnabledItems().get(this);
    }

    public McdwSoulDagger getItem() {
        return SoulDaggersID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SoulDaggersID.getSpawnRates().get(this);
    }

    public HashMap<SoulDaggersID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.soulDaggerStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SoulDaggersID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.soulDaggerStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwSoulDagger makeWeapon() {
        McdwSoulDagger mcdwSoulDagger = new McdwSoulDagger(ItemsInit.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SoulDaggersID.getItemsEnum().put(this, mcdwSoulDagger);
        return mcdwSoulDagger;
    }
}

