/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.settings.SettingsManager;
import carpet.utils.Messenger;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2247;
import net.minecraft.class_2248;
import net.minecraft.class_2252;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public class DrawCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"draw").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandDraw))).then(class_2170.method_9247((String)"sphere").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawSphere((CommandContext<class_2168>)c, false)))))))).then(class_2170.method_9247((String)"ball").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawSphere((CommandContext<class_2168>)c, true)))))))).then(class_2170.method_9247((String)"diamond").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawDiamond((CommandContext<class_2168>)c, true)))))))).then(class_2170.method_9247((String)"pyramid").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"pointing", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"up", "down"}, (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawPyramid((CommandContext<class_2168>)c, "square", true))))))))))).then(class_2170.method_9247((String)"cone").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"pointing", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"up", "down"}, (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawPyramid((CommandContext<class_2168>)c, "circle", true))))))))))).then(class_2170.method_9247((String)"cylinder").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawPrism((CommandContext<class_2168>)c, "circle")))))))))).then(class_2170.method_9247((String)"cuboid").then(class_2170.method_9244((String)"center", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"orientation", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"y", "x", "z"}, (SuggestionsBuilder)b)).then(DrawCommand.drawShape((Command<class_2168>)((Command)c -> DrawCommand.drawPrism((CommandContext<class_2168>)c, "square")))))))));
        dispatcher.register(command);
    }

    private static RequiredArgumentBuilder<class_2168, class_2247> drawShape(Command<class_2168> drawer) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653()).executes(drawer)).then(class_2170.method_9247((String)"replace").then(class_2170.method_9244((String)"filter", (ArgumentType)class_2252.method_9645()).executes(drawer)));
    }

    private static <T> T getArg(CommandContext<class_2168> ctx, ArgumentExtractor<T> extract, String hwat) throws CommandSyntaxException {
        return DrawCommand.getArg(ctx, extract, hwat, false);
    }

    private static <T> T getArg(CommandContext<class_2168> ctx, ArgumentExtractor<T> extract, String hwat, boolean optional) throws CommandSyntaxException {
        T arg = null;
        try {
            arg = extract.apply(ctx, hwat);
        }
        catch (IllegalArgumentException e) {
            if (optional) {
                return null;
            }
            Messenger.m((class_2168)ctx.getSource(), "rb Missing " + hwat);
            throw new ErrorHandled();
        }
        return arg;
    }

    private static double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    private static int setBlock(class_3218 world, class_2338.class_2339 mbpos, int x, int y, int z, class_2247 block, Predicate<class_2694> replacement, List<class_2338> list) {
        mbpos.method_10103(x, y, z);
        int success = 0;
        if (replacement == null || replacement.test(new class_2694((class_4538)world, (class_2338)mbpos, true))) {
            class_2586 tileentity = world.method_8321((class_2338)mbpos);
            if (tileentity instanceof class_1263) {
                ((class_1263)tileentity).method_5448();
            }
            if (block.method_9495(world, (class_2338)mbpos, 2)) {
                list.add(mbpos.method_10062());
                ++success;
            }
        }
        return success;
    }

    private static int drawSphere(CommandContext<class_2168> ctx, boolean solid) throws CommandSyntaxException {
        Predicate replacement;
        class_2247 block;
        int radius;
        class_2338 pos;
        try {
            pos = DrawCommand.getArg(ctx, class_2262::method_9697, "center");
            radius = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius");
            block = DrawCommand.getArg(ctx, class_2257::method_9655, "block");
            replacement = DrawCommand.getArg(ctx, class_2252::method_9644, "filter", true);
        }
        catch (ErrorHandled ignored) {
            return 0;
        }
        int affected = 0;
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        double radiusX = (double)radius + 0.5;
        double radiusY = (double)radius + 0.5;
        double radiusZ = (double)radius + 0.5;
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        class_2338.class_2339 mbpos = pos.method_25503();
        ArrayList list = Lists.newArrayList();
        double nextXn = 0.0;
        block2: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextYn = 0.0;
            block3: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double distanceSq = DrawCommand.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block3;
                        if (y != 0) continue block2;
                        break block2;
                    }
                    if (!solid && DrawCommand.lengthSq(nextXn, yn, zn) <= 1.0 && DrawCommand.lengthSq(xn, nextYn, zn) <= 1.0 && DrawCommand.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
                    for (int xmod = -1; xmod < 2; xmod += 2) {
                        for (int ymod = -1; ymod < 2; ymod += 2) {
                            for (int zmod = -1; zmod < 2; zmod += 2) {
                                affected += DrawCommand.setBlock(world, mbpos, pos.method_10263() + xmod * x, pos.method_10264() + ymod * y, pos.method_10260() + zmod * z, block, replacement, list);
                            }
                        }
                    }
                    CarpetSettings.impendingFillSkipUpdates.set(false);
                }
            }
        }
        if (CarpetSettings.fillUpdates) {
            list.forEach(blockpos1 -> world.method_8408(blockpos1, world.method_8320(blockpos1).method_26204()));
        }
        Messenger.m((class_2168)ctx.getSource(), "gi Filled " + affected + " blocks");
        return affected;
    }

    private static int drawDiamond(CommandContext<class_2168> ctx, boolean solid) throws CommandSyntaxException {
        Predicate replacement;
        class_2247 block;
        int radius;
        class_2338 pos;
        try {
            pos = DrawCommand.getArg(ctx, class_2262::method_9697, "center");
            radius = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius");
            block = DrawCommand.getArg(ctx, class_2257::method_9655, "block");
            replacement = DrawCommand.getArg(ctx, class_2252::method_9644, "filter", true);
        }
        catch (ErrorHandled ignored) {
            return 0;
        }
        class_2168 source = (class_2168)ctx.getSource();
        int affected = 0;
        class_2338.class_2339 mbpos = pos.method_25503();
        ArrayList list = Lists.newArrayList();
        class_3218 world = source.method_9225();
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        for (int r = 0; r < radius; ++r) {
            int y = r - radius + 1;
            for (int x = -r; x <= r; ++x) {
                int z = r - Math.abs(x);
                affected += DrawCommand.setBlock(world, mbpos, pos.method_10263() + x, pos.method_10264() - y, pos.method_10260() + z, block, replacement, list);
                affected += DrawCommand.setBlock(world, mbpos, pos.method_10263() + x, pos.method_10264() - y, pos.method_10260() - z, block, replacement, list);
                affected += DrawCommand.setBlock(world, mbpos, pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z, block, replacement, list);
                affected += DrawCommand.setBlock(world, mbpos, pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() - z, block, replacement, list);
            }
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates) {
            list.forEach(p -> world.method_8408(p, world.method_8320(p).method_26204()));
        }
        Messenger.m(source, "gi Filled " + affected + " blocks");
        return affected;
    }

    private static int fillFlat(class_3218 world, class_2338 pos, int offset, double dr, boolean rectangle, String orientation, class_2247 block, Predicate<class_2694> replacement, List<class_2338> list, class_2338.class_2339 mbpos) {
        int successes = 0;
        int r = class_3532.method_15357((double)dr);
        double drsq = dr * dr;
        if (orientation.equalsIgnoreCase("x")) {
            for (int a = -r; a <= r; ++a) {
                for (int b = -r; b <= r; ++b) {
                    if (!rectangle && !((double)(a * a + b * b) <= drsq)) continue;
                    successes += DrawCommand.setBlock(world, mbpos, pos.method_10263() + offset, pos.method_10264() + a, pos.method_10260() + b, block, replacement, list);
                }
            }
            return successes;
        }
        if (orientation.equalsIgnoreCase("y")) {
            for (int a = -r; a <= r; ++a) {
                for (int b = -r; b <= r; ++b) {
                    if (!rectangle && !((double)(a * a + b * b) <= drsq)) continue;
                    successes += DrawCommand.setBlock(world, mbpos, pos.method_10263() + a, pos.method_10264() + offset, pos.method_10260() + b, block, replacement, list);
                }
            }
            return successes;
        }
        if (orientation.equalsIgnoreCase("z")) {
            for (int a = -r; a <= r; ++a) {
                for (int b = -r; b <= r; ++b) {
                    if (!rectangle && !((double)(a * a + b * b) <= drsq)) continue;
                    successes += DrawCommand.setBlock(world, mbpos, pos.method_10263() + b, pos.method_10264() + a, pos.method_10260() + offset, block, replacement, list);
                }
            }
            return successes;
        }
        return 0;
    }

    private static int drawPyramid(CommandContext<class_2168> ctx, String base, boolean solid) throws CommandSyntaxException {
        Predicate replacement;
        class_2247 block;
        String orientation;
        boolean pointup;
        int height;
        double radius;
        class_2338 pos;
        try {
            pos = DrawCommand.getArg(ctx, class_2262::method_9697, "center");
            radius = (double)DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius").intValue() + 0.5;
            height = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "height");
            pointup = DrawCommand.getArg(ctx, StringArgumentType::getString, "pointing").equalsIgnoreCase("up");
            orientation = DrawCommand.getArg(ctx, StringArgumentType::getString, "orientation");
            block = DrawCommand.getArg(ctx, class_2257::method_9655, "block");
            replacement = DrawCommand.getArg(ctx, class_2252::method_9644, "filter", true);
        }
        catch (ErrorHandled ignored) {
            return 0;
        }
        class_2168 source = (class_2168)ctx.getSource();
        int affected = 0;
        class_2338.class_2339 mbpos = pos.method_25503();
        ArrayList list = Lists.newArrayList();
        class_3218 world = source.method_9225();
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        boolean isSquare = base.equalsIgnoreCase("square");
        for (int i = 0; i < height; ++i) {
            double r = pointup ? radius - radius * (double)i / (double)height - 1.0 : radius * (double)i / (double)height;
            affected += DrawCommand.fillFlat(world, pos, i, r, isSquare, orientation, block, replacement, list, mbpos);
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates) {
            for (class_2338 blockpos1 : list) {
                class_2248 blokc = world.method_8320(blockpos1).method_26204();
                world.method_8408(blockpos1, blokc);
            }
        }
        Messenger.m(source, "gi Filled " + affected + " blocks");
        return affected;
    }

    private static int drawPrism(CommandContext<class_2168> ctx, String base) {
        Predicate replacement;
        class_2247 block;
        String orientation;
        int height;
        double radius;
        class_2338 pos;
        try {
            pos = DrawCommand.getArg(ctx, class_2262::method_9697, "center");
            radius = (double)DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "radius").intValue() + 0.5;
            height = DrawCommand.getArg(ctx, IntegerArgumentType::getInteger, "height");
            orientation = DrawCommand.getArg(ctx, StringArgumentType::getString, "orientation");
            block = DrawCommand.getArg(ctx, class_2257::method_9655, "block");
            replacement = DrawCommand.getArg(ctx, class_2252::method_9644, "filter", true);
        }
        catch (ErrorHandled | CommandSyntaxException ignored) {
            return 0;
        }
        class_2168 source = (class_2168)ctx.getSource();
        int affected = 0;
        class_2338.class_2339 mbpos = pos.method_25503();
        ArrayList list = Lists.newArrayList();
        class_3218 world = source.method_9225();
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        boolean isSquare = base.equalsIgnoreCase("square");
        for (int i = 0; i < height; ++i) {
            affected += DrawCommand.fillFlat(world, pos, i, radius, isSquare, orientation, block, replacement, list, mbpos);
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates) {
            for (class_2338 blockpos1 : list) {
                class_2248 blokc = world.method_8320(blockpos1).method_26204();
                world.method_8408(blockpos1, blokc);
            }
        }
        Messenger.m(source, "gi Filled " + affected + " blocks");
        return affected;
    }

    @FunctionalInterface
    private static interface ArgumentExtractor<T> {
        public T apply(CommandContext<class_2168> var1, String var2) throws CommandSyntaxException;
    }

    private static class ErrorHandled
    extends RuntimeException {
        private ErrorHandled() {
        }
    }
}

