/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging.logHelpers;

import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1927;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2554;

public class ExplosionLogHelper {
    private final boolean createFire;
    private final class_1927.class_4179 blockDestructionType;
    public final class_243 pos;
    public final class_1297 entity;
    private final float power;
    private boolean affectBlocks = false;
    private Object2IntMap<EntityChangedStatusWithCount> impactedEntities = new Object2IntOpenHashMap();
    private static long lastGametime = 0L;
    private static int explosionCountInCurretGT = 0;
    private static boolean newTick;

    public ExplosionLogHelper(class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 blockDestructionType) {
        this.entity = entity;
        this.power = power;
        this.pos = new class_243(x, y, z);
        this.createFire = createFire;
        this.blockDestructionType = blockDestructionType;
    }

    public void setAffectBlocks(boolean b) {
        this.affectBlocks = b;
    }

    public void onExplosionDone(long gametime) {
        newTick = false;
        if (lastGametime != gametime) {
            explosionCountInCurretGT = 0;
            lastGametime = gametime;
            newTick = true;
        }
        ++explosionCountInCurretGT;
        LoggerRegistry.getLogger("explosions").log(option -> {
            ArrayList<class_2554> messages = new ArrayList<class_2554>();
            if (newTick) {
                messages.add(Messenger.c("wb tick : ", "d " + gametime));
            }
            if ("brief".equals(option)) {
                messages.add(Messenger.c("d #" + explosionCountInCurretGT, "gb ->", Messenger.dblt("l", this.pos.field_1352, this.pos.field_1351, this.pos.field_1350), this.affectBlocks ? "m  (affects blocks)" : "m  (doesn't affect blocks)"));
            }
            if ("full".equals(option)) {
                messages.add(Messenger.c("d #" + explosionCountInCurretGT, "gb ->", Messenger.dblt("l", this.pos.field_1352, this.pos.field_1351, this.pos.field_1350)));
                messages.add(Messenger.c("w   affects blocks: ", "m " + this.affectBlocks));
                messages.add(Messenger.c("w   creates fire: ", "m " + this.createFire));
                messages.add(Messenger.c("w   power: ", "c " + this.power));
                messages.add(Messenger.c("w   destruction: ", "c " + this.blockDestructionType.name()));
                if (this.impactedEntities.isEmpty()) {
                    messages.add(Messenger.c("w   affected entities: ", "m None"));
                } else {
                    messages.add(Messenger.c("w   affected entities:"));
                    this.impactedEntities.forEach((k, v) -> messages.add(Messenger.c(k.pos.equals((Object)this.pos) ? "r   - TNT" : "w   - ", Messenger.dblt(k.pos.equals((Object)this.pos) ? "r" : "y", k.pos.field_1352, k.pos.field_1351, k.pos.field_1350), "w  dV", Messenger.dblt("d", k.accel.field_1352, k.accel.field_1351, k.accel.field_1350), "w  " + class_2378.field_11145.method_10221(k.type).method_12832(), v > 1 ? "l (" + v + ")" : "")));
                }
            }
            return messages.toArray(new class_2554[0]);
        });
    }

    public void onEntityImpacted(class_1297 entity, class_243 accel) {
        EntityChangedStatusWithCount ent = new EntityChangedStatusWithCount(entity, accel);
        this.impactedEntities.put((Object)ent, this.impactedEntities.getOrDefault((Object)ent, 0) + 1);
    }

    public record EntityChangedStatusWithCount(class_243 pos, class_1299<?> type, class_243 accel) {
        public EntityChangedStatusWithCount(class_1297 e, class_243 accel) {
            this(e.method_19538(), e.method_5864(), accel);
        }
    }
}

