/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.argument.FunctionArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.server.MinecraftServer;

public class Entities {
    private static ListValue getPlayersFromWorldMatching(Context c, Predicate<class_3222> condition) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (class_3222 player : ((CarpetContext)c).s.method_9225().method_18456()) {
            if (!condition.test(player)) continue;
            ret.add(new EntityValue((class_1297)player));
        }
        return ListValue.wrap(ret);
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("player", -1, (c, t, lv) -> {
            String playerName;
            if (lv.size() == 0) {
                CarpetContext cc = (CarpetContext)c;
                if (cc.host.user != null) {
                    class_3222 player = cc.s.method_9211().method_3760().method_14566(cc.host.user);
                    return EntityValue.of((class_1297)player);
                }
                class_1297 callingEntity = cc.s.method_9228();
                if (callingEntity instanceof class_1657) {
                    return EntityValue.of(callingEntity);
                }
                class_243 pos = ((CarpetContext)c).s.method_9222();
                class_1657 closestPlayer = ((CarpetContext)c).s.method_9225().method_8604(pos.field_1352, pos.field_1351, pos.field_1350, -1.0, class_1301.field_6154);
                return EntityValue.of((class_1297)closestPlayer);
            }
            return switch (playerName = ((Value)lv.get(0)).getString()) {
                case "all" -> {
                    ArrayList<Value> ret = new ArrayList<Value>();
                    for (class_3222 player : ((CarpetContext)c).s.method_9211().method_3760().method_14571()) {
                        ret.add(new EntityValue((class_1297)player));
                    }
                    yield ListValue.wrap(ret);
                }
                case "*" -> Entities.getPlayersFromWorldMatching(c, p -> true);
                case "survival" -> Entities.getPlayersFromWorldMatching(c, p -> p.field_13974.method_14267());
                case "creative" -> Entities.getPlayersFromWorldMatching(c, class_3222::method_7337);
                case "spectating" -> Entities.getPlayersFromWorldMatching(c, class_3222::method_7325);
                case "!spectating" -> Entities.getPlayersFromWorldMatching(c, p -> !p.method_7325());
                default -> {
                    class_3222 player = ((CarpetContext)c).s.method_9211().method_3760().method_14566(playerName);
                    if (player != null) {
                        yield new EntityValue((class_1297)player);
                    }
                    yield Value.NULL;
                }
            };
        });
        expression.addContextFunction("spawn", -1, (c, t, lv) -> {
            class_2960 entityId;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'spawn' function takes mob name, and position to spawn");
            }
            String entityString = ((Value)lv.get(0)).getString();
            try {
                entityId = class_2960.method_12835((StringReader)new StringReader(entityString));
                class_1299 type = class_2378.field_11145.method_17966(entityId).orElse(null);
                if (type == null || !type.method_5896()) {
                    return Value.NULL;
                }
            }
            catch (CommandSyntaxException exception) {
                return Value.NULL;
            }
            Vector3Argument position = Vector3Argument.findIn(lv, 1);
            if (position.fromBlock) {
                position.vec = position.vec.method_1023(0.0, 0.5, 0.0);
            }
            class_2487 tag = new class_2487();
            boolean hasTag = false;
            if (lv.size() > position.offset) {
                Value nbt = (Value)lv.get(position.offset);
                NBTSerializableValue v = nbt instanceof NBTSerializableValue ? (NBTSerializableValue)nbt : NBTSerializableValue.parseString(nbt.getString(), true);
                hasTag = true;
                tag = v.getCompoundTag();
            }
            tag.method_10582("id", entityId.toString());
            class_243 vec3d = position.vec;
            class_3218 serverWorld = cc.s.method_9225();
            class_1297 entity_1 = class_1299.method_17842((class_2487)tag, (class_1937)serverWorld, entity_1x -> {
                entity_1x.method_5808(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, entity_1x.method_36454(), entity_1x.method_36455());
                return !serverWorld.method_18768(entity_1x) ? null : entity_1x;
            });
            if (entity_1 == null) {
                return Value.NULL;
            }
            if (!hasTag && entity_1 instanceof class_1308) {
                ((class_1308)entity_1).method_5943((class_5425)serverWorld, serverWorld.method_8404(entity_1.method_24515()), class_3730.field_16462, null, null);
            }
            return new EntityValue(entity_1);
        });
        expression.addContextFunction("entity_id", 1, (c, t, lv) -> {
            Value who = (Value)lv.get(0);
            if (who instanceof NumericValue) {
                return EntityValue.of(((CarpetContext)c).s.method_9225().method_8469((int)((NumericValue)who).getLong()));
            }
            return EntityValue.of(((CarpetContext)c).s.method_9225().method_14190(UUID.fromString(who.getString())));
        });
        expression.addContextFunction("entity_list", 1, (c, t, lv) -> {
            String who = ((Value)lv.get(0)).getString();
            class_2168 source = ((CarpetContext)c).s;
            EntityValue.EntityClassDescriptor eDesc = EntityValue.getEntityDescriptor(who, source.method_9211());
            List entityList = source.method_9225().method_18198(eDesc.directType, eDesc.filteringPredicate);
            return ListValue.wrap(entityList.stream().map(EntityValue::new).collect(Collectors.toList()));
        });
        expression.addContextFunction("entity_area", -1, (c, t, lv) -> {
            class_238 centerBox;
            if (lv.size() < 3) {
                throw new InternalExpressionException("'entity_area' requires entity type, center and range arguments");
            }
            String who = ((Value)lv.get(0)).getString();
            CarpetContext cc = (CarpetContext)c;
            Vector3Argument centerLocator = Vector3Argument.findIn(lv, 1, false, true);
            if (centerLocator.entity != null) {
                centerBox = centerLocator.entity.method_5829();
            } else {
                class_243 center = centerLocator.vec;
                if (centerLocator.fromBlock) {
                    center.method_1031(0.5, 0.5, 0.5);
                }
                centerBox = new class_238(center, center);
            }
            Vector3Argument rangeLocator = Vector3Argument.findIn(lv, centerLocator.offset);
            if (rangeLocator.fromBlock) {
                throw new InternalExpressionException("Range of 'entity_area' cannot come from a block argument");
            }
            class_243 range = rangeLocator.vec;
            class_238 area = centerBox.method_1009(range.field_1352, range.field_1351, range.field_1350);
            EntityValue.EntityClassDescriptor eDesc = EntityValue.getEntityDescriptor(who, cc.s.method_9211());
            List entityList = cc.s.method_9225().method_18023(eDesc.directType, area, eDesc.filteringPredicate);
            return ListValue.wrap(entityList.stream().map(EntityValue::new).collect(Collectors.toList()));
        });
        expression.addContextFunction("entity_selector", -1, (c, t, lv) -> {
            String selector = ((Value)lv.get(0)).getString();
            ArrayList<Value> retlist = new ArrayList<Value>();
            for (class_1297 class_12972 : EntityValue.getEntitiesFromSelector(((CarpetContext)c).s, selector)) {
                retlist.add(new EntityValue(class_12972));
            }
            return ListValue.wrap(retlist);
        });
        expression.addContextFunction("query", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'query' takes entity as a first argument, and queried feature as a second");
            }
            Value v = (Value)lv.get(0);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to query should be an entity");
            }
            String what = ((Value)lv.get(1)).getString().toLowerCase(Locale.ROOT);
            if (what.equals("tags")) {
                c.host.issueDeprecation("'tags' for entity querying");
            }
            Value retval = lv.size() == 2 ? ((EntityValue)v).get(what, null) : (lv.size() == 3 ? ((EntityValue)v).get(what, (Value)lv.get(2)) : ((EntityValue)v).get(what, ListValue.wrap(lv.subList(2, lv.size()))));
            return retval;
        });
        expression.addContextFunction("modify", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'modify' takes entity as a first argument, and queried feature as a second");
            }
            Value v = (Value)lv.get(0);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to modify should be an entity");
            }
            String what = ((Value)lv.get(1)).getString();
            if (lv.size() == 2) {
                ((EntityValue)v).set(what, null);
            } else if (lv.size() == 3) {
                ((EntityValue)v).set(what, (Value)lv.get(2));
            } else {
                ((EntityValue)v).set(what, ListValue.wrap(lv.subList(2, lv.size())));
            }
            return v;
        });
        expression.addContextFunction("entity_types", -1, (c, t, lv) -> {
            if (lv.size() > 1) {
                throw new InternalExpressionException("'entity_types' requires one or no arguments");
            }
            String desc = lv.size() == 1 ? ((Value)lv.get(0)).getString() : "*";
            return EntityValue.getEntityDescriptor((String)desc, (MinecraftServer)((CarpetContext)c).s.method_9211()).listValue;
        });
        expression.addContextFunction("entity_load_handler", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'entity_load_handler' required the entity type, and a function to call");
            }
            Value entityValue = (Value)lv.get(0);
            List<String> descriptors = entityValue instanceof ListValue ? ((ListValue)entityValue).getItems().stream().map(Value::getString).collect(Collectors.toList()) : Collections.singletonList(entityValue.getString());
            HashSet types = new HashSet();
            descriptors.forEach(s -> types.addAll(EntityValue.getEntityDescriptor((String)s, (MinecraftServer)((CarpetContext)c).s.method_9211()).typeList));
            FunctionArgument funArg = FunctionArgument.findIn(c, expression.module, lv, 1, true, false);
            CarpetEventServer events = ((CarpetScriptHost)c.host).getScriptServer().events;
            if (funArg.function == null) {
                types.forEach(et -> events.removeBuiltInEvent(CarpetEventServer.Event.getEntityLoadEventName((class_1299<? extends class_1297>)et), (CarpetScriptHost)c.host));
                types.forEach(et -> events.removeBuiltInEvent(CarpetEventServer.Event.getEntityHandlerEventName((class_1299<? extends class_1297>)et), (CarpetScriptHost)c.host));
            } else {
                int argno = funArg.function.getArguments().size() - funArg.args.size();
                if (argno == 1) {
                    c.host.issueDeprecation("entity_load_handler() with single argument callback");
                    types.forEach(et -> events.addBuiltInEvent(CarpetEventServer.Event.getEntityLoadEventName((class_1299<? extends class_1297>)et), c.host, funArg.function, funArg.args));
                } else {
                    types.forEach(et -> events.addBuiltInEvent(CarpetEventServer.Event.getEntityHandlerEventName((class_1299<? extends class_1297>)et), c.host, funArg.function, funArg.args));
                }
            }
            return new NumericValue(types.size());
        });
        expression.addContextFunction("entity_event", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'entity_event' requires at least 3 arguments, entity, event to be handled, and function name, with optional arguments");
            }
            Value v = (Value)lv.get(0);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to entity_event should be an entity");
            }
            String what = ((Value)lv.get(1)).getString();
            FunctionArgument funArg = FunctionArgument.findIn(c, expression.module, lv, 2, true, false);
            ((EntityValue)v).setEvent((CarpetContext)c, what, funArg.function, funArg.args);
            return Value.NULL;
        });
    }
}

