/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.fakes.ChunkGeneratorInterface;
import carpet.fakes.ChunkTicketManagerInterface;
import carpet.fakes.ServerChunkManagerInterface;
import carpet.fakes.ServerWorldInterface;
import carpet.fakes.SpawnHelperInnerInterface;
import carpet.fakes.ThreadedAnvilChunkStorageInterface;
import carpet.helpers.FeatureGenerator;
import carpet.mixins.PoiRecord_scarpetMixin;
import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.annotation.Locator;
import carpet.script.annotation.ScarpetFunction;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.utils.BiomeInfo;
import carpet.script.utils.InputValidator;
import carpet.script.utils.WorldTools;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import carpet.utils.BlockInfo;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2290;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3341;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_4538;
import net.minecraft.class_4706;
import net.minecraft.class_4766;
import net.minecraft.class_5268;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class WorldAccess {
    private static final Map<String, class_2350> DIRECTION_MAP = Arrays.stream(class_2350.values()).collect(Collectors.toMap(class_2350::method_10151, direction -> direction));
    private static final Map<String, class_3230<?>> ticketTypes;
    private static class_1540 DUMMY_ENTITY;

    private static Value booleanStateTest(Context c, String name, List<Value> params, BiPredicate<class_2680, class_2338> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.size() == 0) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value v0 = params.get(0);
        if (v0 instanceof BlockValue) {
            return BooleanValue.of(test.test(((BlockValue)v0).getBlockState(), ((BlockValue)v0).getPos()));
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return BooleanValue.of(test.test(block.getBlockState(), block.getPos()));
    }

    private static Value stateStringQuery(Context c, String name, List<Value> params, BiFunction<class_2680, class_2338, String> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.size() == 0) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value v0 = params.get(0);
        if (v0 instanceof BlockValue) {
            String strVal = test.apply(((BlockValue)v0).getBlockState(), ((BlockValue)v0).getPos());
            return StringValue.of(strVal);
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return StringValue.of(test.apply(block.getBlockState(), block.getPos()));
    }

    private static Value genericStateTest(Context c, String name, List<Value> params, Fluff.TriFunction<class_2680, class_2338, class_1937, Value> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.size() == 0) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value v0 = params.get(0);
        if (v0 instanceof BlockValue) {
            try {
                return test.apply(((BlockValue)v0).getBlockState(), ((BlockValue)v0).getPos(), (class_1937)cc.s.method_9225());
            }
            catch (NullPointerException ignored) {
                throw new InternalExpressionException("'" + name + "' function requires a block that is positioned in the world");
            }
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return test.apply(block.getBlockState(), block.getPos(), (class_1937)cc.s.method_9225());
    }

    private static <T extends Comparable<T>> class_2680 setProperty(class_2769<T> property, String name, String value, class_2680 bs) {
        Optional optional = property.method_11900(value);
        if (!optional.isPresent()) {
            throw new InternalExpressionException(value + " is not a valid value for property " + name);
        }
        bs = (class_2680)bs.method_11657(property, (Comparable)optional.get());
        return bs;
    }

    private static void nullCheck(Value v, String name) {
        if (v.isNull()) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private static float numberGetOrThrow(Value v) {
        double num = v.readDoubleNumber();
        if (Double.isNaN(num)) {
            throw new IllegalArgumentException(v.getString() + " needs to be a numeric value");
        }
        return (float)num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void BooYah(class_2794 generator) {
        class_2794 class_27942 = generator;
        synchronized (class_27942) {
            ((ChunkGeneratorInterface)generator).initStrongholds();
        }
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("block", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            BlockValue retval = BlockArgument.findIn((CarpetContext)cc, (List<Value>)lv, (int)0, (boolean)true).block;
            retval.getBlockState();
            retval.getData();
            return retval;
        });
        expression.addContextFunction("block_data", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            class_2487 tag = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0, (boolean)true).block.getData();
            return NBTSerializableValue.of((class_2520)tag);
        });
        expression.addContextFunction("poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            class_2338 pos = locator.block.getPos();
            class_4153 store = cc.s.method_9225().method_19494();
            if (lv.size() == locator.offset) {
                class_4158 poiType = store.method_19132(pos).orElse(null);
                if (poiType == null) {
                    return Value.NULL;
                }
                class_4156 poi = store.method_19125(poiType.method_19164(), pos, 1, class_4153.class_4155.field_18489).filter(p -> p.method_19141().equals((Object)pos)).findFirst().orElse(null);
                if (poi == null) {
                    return Value.NULL;
                }
                return ListValue.of(new StringValue(poi.method_19142().toString()), new NumericValue(poiType.method_19161() - ((PoiRecord_scarpetMixin)poi).getFreeTickets()));
            }
            int radius = NumericValue.asNumber((Value)lv.get(locator.offset + 0)).getInt();
            if (radius < 0) {
                return ListValue.of(new Value[0]);
            }
            Predicate<class_4158> condition = class_4158.field_18501;
            class_4153.class_4155 status = class_4153.class_4155.field_18489;
            boolean inColumn = false;
            if (locator.offset + 1 < lv.size()) {
                String poiType = ((Value)lv.get(locator.offset + 1)).getString().toLowerCase(Locale.ROOT);
                if (!"any".equals(poiType)) {
                    class_4158 type = (class_4158)class_2378.field_18792.method_17966(InputValidator.identifierOf(poiType)).orElseThrow(() -> new ThrowStatement(poiType, Throwables.UNKNOWN_POI));
                    condition = tt -> tt == type;
                }
                if (locator.offset + 2 < lv.size()) {
                    String statusString = ((Value)lv.get(locator.offset + 2)).getString().toLowerCase(Locale.ROOT);
                    if ("occupied".equals(statusString)) {
                        status = class_4153.class_4155.field_18488;
                    } else if ("available".equals(statusString)) {
                        status = class_4153.class_4155.field_18487;
                    } else if (!"any".equals(statusString)) {
                        throw new InternalExpressionException("Incorrect POI occupation status " + status + " use `any`, `occupied` or `available`");
                    }
                    if (locator.offset + 3 < lv.size()) {
                        inColumn = ((Value)lv.get(locator.offset + 3)).getBoolean();
                    }
                }
            }
            Stream pois = inColumn ? store.method_22383((Predicate)condition, pos, radius, status) : store.method_19125((Predicate)condition, pos, radius, status);
            return ListValue.wrap(pois.sorted(Comparator.comparingDouble(p -> p.method_19141().method_10262((class_2382)pos))).map(p -> ListValue.of(new StringValue(p.method_19142().toString()), new NumericValue(p.method_19142().method_19161() - ((PoiRecord_scarpetMixin)p).getFreeTickets()), ListValue.of(new NumericValue(p.method_19141().method_10263()), new NumericValue(p.method_19141().method_10264()), new NumericValue(p.method_19141().method_10260())))).collect(Collectors.toList()));
        });
        expression.addContextFunction("set_poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'set_poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            class_2338 pos = locator.block.getPos();
            if (lv.size() < locator.offset) {
                throw new InternalExpressionException("'set_poi' requires the new poi type or null, after position argument");
            }
            Value poi = (Value)lv.get(locator.offset + 0);
            class_4153 store = cc.s.method_9225().method_19494();
            if (poi.isNull()) {
                if (!store.method_19132(pos).isPresent()) {
                    return Value.FALSE;
                }
                store.method_19112(pos);
                return Value.TRUE;
            }
            String poiTypeString = poi.getString().toLowerCase(Locale.ROOT);
            class_4158 type = (class_4158)class_2378.field_18792.method_17966(InputValidator.identifierOf(poiTypeString)).orElseThrow(() -> new ThrowStatement(poiTypeString, Throwables.UNKNOWN_POI));
            int occupancy = 0;
            if (locator.offset + 1 < lv.size() && (occupancy = (int)NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getLong()) < 0) {
                throw new InternalExpressionException("Occupancy cannot be negative");
            }
            if (store.method_19132(pos).isPresent()) {
                store.method_19112(pos);
            }
            store.method_19115(pos, type);
            if (occupancy > 0) {
                int finalO = occupancy;
                store.method_22383(tt -> tt == type, pos, 1, class_4153.class_4155.field_18489).filter(p -> p.method_19141().equals((Object)pos)).findFirst().ifPresent(p -> {
                    for (int i = 0; i < finalO; ++i) {
                        ((PoiRecord_scarpetMixin)p).callAcquireTicket();
                    }
                });
            }
            return Value.TRUE;
        });
        expression.addContextFunction("weather", -1, (c, t, lv) -> {
            class_3218 world = ((CarpetContext)c).s.method_9225();
            if (lv.size() == 0) {
                return new StringValue(world.method_8546() ? "thunder" : (world.method_8419() ? "rain" : "clear"));
            }
            Value weather = (Value)lv.get(0);
            class_5268 worldProperties = ((ServerWorldInterface)world).getWorldPropertiesCM();
            if (lv.size() == 1) {
                return new NumericValue(switch (weather.getString().toLowerCase(Locale.ROOT)) {
                    case "clear" -> worldProperties.method_155();
                    case "rain" -> world.method_8419() ? worldProperties.method_190() : 0;
                    case "thunder" -> world.method_8546() ? worldProperties.method_145() : 0;
                    default -> throw new InternalExpressionException("Weather can only be 'clear', 'rain' or 'thunder'");
                });
            }
            if (lv.size() == 2) {
                int ticks = NumericValue.asNumber((Value)lv.get(1), "tick_time in 'weather'").getInt();
                switch (weather.getString().toLowerCase(Locale.ROOT)) {
                    case "clear": {
                        world.method_27910(ticks, 0, false, false);
                        break;
                    }
                    case "rain": {
                        world.method_27910(0, ticks, true, false);
                        break;
                    }
                    case "thunder": {
                        world.method_27910(0, ticks, true, true);
                        break;
                    }
                    default: {
                        throw new InternalExpressionException("Weather can only be 'clear', 'rain' or 'thunder'");
                    }
                }
                return NumericValue.of(ticks);
            }
            throw new InternalExpressionException("'weather' requires 0, 1 or 2 arguments");
        });
        expression.addUnaryFunction("pos", v -> {
            if (v instanceof BlockValue) {
                class_2338 pos = ((BlockValue)v).getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Cannot fetch position of an unrealized block");
                }
                return ListValue.of(new NumericValue(pos.method_10263()), new NumericValue(pos.method_10264()), new NumericValue(pos.method_10260()));
            }
            if (v instanceof EntityValue) {
                class_1297 e = ((EntityValue)v).getEntity();
                if (e == null) {
                    throw new InternalExpressionException("Null entity");
                }
                return ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321()));
            }
            throw new InternalExpressionException("'pos' works only with a block or an entity type");
        });
        expression.addContextFunction("pos_offset", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2338 pos = locator.block.getPos();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'pos_offset' needs at least position, and direction");
            }
            String directionString = ((Value)lv.get(locator.offset)).getString();
            class_2350 dir = DIRECTION_MAP.get(directionString);
            if (dir == null) {
                throw new InternalExpressionException("Unknown direction: " + directionString);
            }
            int howMuch = 1;
            if (lv.size() > locator.offset + 1) {
                howMuch = (int)NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getLong();
            }
            class_2338 retpos = pos.method_10079(dir, howMuch);
            return ListValue.of(new NumericValue(retpos.method_10263()), new NumericValue(retpos.method_10264()), new NumericValue(retpos.method_10260()));
        });
        expression.addContextFunction("solid", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "solid", lv, (s, p, w) -> BooleanValue.of(s.method_26212((class_1922)w, p))));
        expression.addContextFunction("air", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "air", lv, (s, p) -> s.method_26215()));
        expression.addContextFunction("liquid", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "liquid", lv, (s, p) -> !s.method_26227().method_15769()));
        expression.addContextFunction("flammable", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "flammable", lv, (s, p) -> s.method_26207().method_15802()));
        expression.addContextFunction("transparent", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "transparent", lv, (s, p) -> !s.method_26207().method_15799()));
        expression.addContextFunction("emitted_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "emitted_light", lv, (s, p, w) -> new NumericValue(s.method_26213())));
        expression.addContextFunction("light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "light", lv, (s, p, w) -> new NumericValue(Math.max(w.method_8314(class_1944.field_9282, p), w.method_8314(class_1944.field_9284, p)))));
        expression.addContextFunction("block_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "block_light", lv, (s, p, w) -> new NumericValue(w.method_8314(class_1944.field_9282, p))));
        expression.addContextFunction("sky_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "sky_light", lv, (s, p, w) -> new NumericValue(w.method_8314(class_1944.field_9284, p))));
        expression.addContextFunction("see_sky", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "see_sky", lv, (s, p, w) -> BooleanValue.of(w.method_8311(p))));
        expression.addContextFunction("brightness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "brightness", lv, (s, p, w) -> new NumericValue(w.method_22349(p))));
        expression.addContextFunction("hardness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "hardness", lv, (s, p, w) -> new NumericValue(s.method_26214((class_1922)w, p))));
        expression.addContextFunction("blast_resistance", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "blast_resistance", lv, (s, p, w) -> new NumericValue(s.method_26204().method_9520())));
        expression.addContextFunction("in_slime_chunk", -1, (c, t, lv) -> {
            class_2338 pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            class_1923 chunkPos = new class_1923(pos);
            return BooleanValue.of(class_2919.method_12662((int)chunkPos.field_9181, (int)chunkPos.field_9180, (long)((CarpetContext)c).s.method_9225().method_8412(), (long)987234911L).nextInt(10) == 0);
        });
        expression.addContextFunction("top", -1, (c, t, lv) -> {
            String type;
            class_2902.class_2903 htype = switch (type = ((Value)lv.get(0)).getString().toLowerCase(Locale.ROOT)) {
                case "motion" -> class_2902.class_2903.field_13197;
                case "terrain" -> class_2902.class_2903.field_13203;
                case "ocean_floor" -> class_2902.class_2903.field_13200;
                case "surface" -> class_2902.class_2903.field_13202;
                default -> throw new InternalExpressionException("Unknown heightmap type: " + type);
            };
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 1);
            class_2338 pos = locator.block.getPos();
            int x = pos.method_10263();
            int z = pos.method_10260();
            return new NumericValue(((CarpetContext)c).s.method_9225().method_8497(x >> 4, z >> 4).method_12005(htype, x & 0xF, z & 0xF) + 1);
        });
        expression.addContextFunction("loaded", -1, (c, t, lv) -> BooleanValue.of(((CarpetContext)c).s.method_9225().method_22340(BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos())));
        expression.addContextFunction("loaded_ep", -1, (c, t, lv) -> {
            c.host.issueDeprecation("loaded_ep(...)");
            class_2338 pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            return BooleanValue.of(((CarpetContext)c).s.method_9225().method_37118(pos));
        });
        expression.addContextFunction("loaded_status", -1, (c, t, lv) -> {
            class_2338 pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            class_2818 chunk = ((CarpetContext)c).s.method_9225().method_14178().method_12126(pos.method_10263() >> 4, pos.method_10260() >> 4, false);
            if (chunk == null) {
                return Value.ZERO;
            }
            return new NumericValue(chunk.method_12225().ordinal());
        });
        expression.addContextFunction("is_chunk_generated", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2338 pos = locator.block.getPos();
            boolean force = false;
            if (lv.size() > locator.offset) {
                force = ((Value)lv.get(locator.offset)).getBoolean();
            }
            return BooleanValue.of(WorldTools.canHasChunk(((CarpetContext)c).s.method_9225(), new class_1923(pos), null, force));
        });
        expression.addContextFunction("generation_status", -1, (c, t, lv) -> {
            class_2791 chunk;
            BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2338 pos = blockArgument.block.getPos();
            boolean forceLoad = false;
            if (lv.size() > blockArgument.offset) {
                forceLoad = ((Value)lv.get(blockArgument.offset)).getBoolean();
            }
            if ((chunk = ((CarpetContext)c).s.method_9225().method_8402(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_12798, forceLoad)) == null) {
                return Value.NULL;
            }
            return new StringValue(chunk.method_12009().method_12172());
        });
        expression.addContextFunction("chunk_tickets", -1, (c, t, lv) -> {
            class_3218 world = ((CarpetContext)c).s.method_9225();
            Long2ObjectOpenHashMap<class_4706<class_3228<?>>> levelTickets = ((ChunkTicketManagerInterface)((ServerChunkManagerInterface)world.method_14178()).getCMTicketManager()).getTicketsByPosition();
            ArrayList<Value> res = new ArrayList<Value>();
            if (lv.size() == 0) {
                LongIterator longIterator = levelTickets.keySet().iterator();
                while (longIterator.hasNext()) {
                    long key = (Long)longIterator.next();
                    class_1923 chpos = new class_1923(key);
                    for (class_3228 ticket : (class_4706)levelTickets.get(key)) {
                        res.add(ListValue.of(new StringValue(ticket.method_14281().toString()), new NumericValue(33 - ticket.method_14283()), new NumericValue(chpos.field_9181), new NumericValue(chpos.field_9180)));
                    }
                }
            } else {
                BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
                class_2338 pos = blockArgument.block.getPos();
                class_4706 tickets = (class_4706)levelTickets.get(new class_1923(pos).method_8324());
                if (tickets != null) {
                    for (class_3228 ticket : tickets) {
                        res.add(ListValue.of(new StringValue(ticket.method_14281().toString()), new NumericValue(33 - ticket.method_14283())));
                    }
                }
            }
            res.sort(Comparator.comparing(e -> ((ListValue)e).getItems().get(1)).reversed());
            return ListValue.wrap(res);
        });
        expression.addContextFunction("suffocates", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "suffocates", lv, (s, p, w) -> BooleanValue.of(s.method_26228((class_1922)w, p))));
        expression.addContextFunction("power", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "power", lv, (s, p, w) -> new NumericValue(w.method_8482(p))));
        expression.addContextFunction("ticks_randomly", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "ticks_randomly", lv, (s, p) -> s.method_26229()));
        expression.addContextFunction("update", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "update", lv, (s, p) -> {
            ((CarpetContext)c).s.method_9225().method_8492(p, s.method_26204(), p);
            return true;
        }));
        expression.addContextFunction("block_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "block_tick", lv, (s, p) -> {
            class_3218 w = ((CarpetContext)c).s.method_9225();
            s.method_26199(w, p, w.field_9229);
            return true;
        }));
        expression.addContextFunction("random_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "random_tick", lv, (s, p) -> {
            class_3218 w = ((CarpetContext)c).s.method_9225();
            if (s.method_26229() || s.method_26227().method_15773()) {
                s.method_26199(w, p, w.field_9229);
            }
            return true;
        }));
        expression.addLazyFunction("without_updates", 1, (c, t, lv) -> {
            boolean previous = CarpetSettings.impendingFillSkipUpdates.get();
            if (previous) {
                return (LazyValue)lv.get(0);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                try {
                    CarpetSettings.impendingFillSkipUpdates.set(true);
                    result[0] = ((LazyValue)lv.get(0)).evalValue((Context)c, (Context.Type)((Object)t));
                }
                finally {
                    CarpetSettings.impendingFillSkipUpdates.set(previous);
                }
            });
            return (cc, tt) -> result[0];
        });
        expression.addContextFunction("set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            BlockArgument targetLocator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument sourceLocator = BlockArgument.findIn(cc, lv, targetLocator.offset, true);
            class_2680 sourceBlockState = sourceLocator.block.getBlockState();
            class_2680 targetBlockState = world.method_8320(targetLocator.block.getPos());
            class_2487 data = null;
            if (lv.size() > sourceLocator.offset) {
                Value dataValue;
                List<Object> args = new ArrayList<Value>();
                int m = lv.size();
                for (int i = sourceLocator.offset; i < m; ++i) {
                    args.add((Value)lv.get(i));
                }
                if (args.get(0) instanceof ListValue) {
                    Value dataValue2;
                    if (args.size() == 2 && (dataValue2 = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                        data = ((NBTSerializableValue)dataValue2).getCompoundTag();
                    }
                    args = ((ListValue)args.get(0)).getItems();
                } else if (args.get(0) instanceof MapValue) {
                    Value dataValue3;
                    if (args.size() == 2 && (dataValue3 = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                        data = ((NBTSerializableValue)dataValue3).getCompoundTag();
                    }
                    Map<Value, Value> state = ((MapValue)args.get(0)).getMap();
                    ArrayList mapargs = new ArrayList();
                    state.forEach((k, v) -> {
                        mapargs.add(k);
                        mapargs.add(v);
                    });
                    args = mapargs;
                } else if ((args.size() & 1) == 1 && (dataValue = NBTSerializableValue.fromValue((Value)args.get(args.size() - 1))) instanceof NBTSerializableValue) {
                    data = ((NBTSerializableValue)dataValue).getCompoundTag();
                }
                class_2689 states = sourceBlockState.method_26204().method_9595();
                for (int i = 0; i < args.size() - 1; i += 2) {
                    String paramString = ((Value)args.get(i)).getString();
                    class_2769 property = states.method_11663(paramString);
                    if (property == null) {
                        throw new InternalExpressionException("Property " + paramString + " doesn't apply to " + sourceLocator.block.getString());
                    }
                    String paramValue = ((Value)args.get(i + 1)).getString();
                    sourceBlockState = WorldAccess.setProperty(property, paramString, paramValue, sourceBlockState);
                }
            }
            if (data == null) {
                data = sourceLocator.block.getData();
            }
            class_2487 finalData = data;
            if (sourceBlockState == targetBlockState && data == null) {
                return Value.FALSE;
            }
            class_2680 finalSourceBlockState = sourceBlockState;
            class_2338 targetPos = targetLocator.block.getPos();
            Boolean[] result = new Boolean[]{true};
            cc.s.method_9211().method_19537(() -> {
                class_2586 be;
                class_3829.method_16825((Object)world.method_8321(targetPos));
                boolean success = world.method_8652(targetPos, finalSourceBlockState, 2);
                if (finalData != null && (be = world.method_8321(targetPos)) != null) {
                    class_2487 destTag = finalData.method_10553();
                    destTag.method_10569("x", targetPos.method_10263());
                    destTag.method_10569("y", targetPos.method_10264());
                    destTag.method_10569("z", targetPos.method_10260());
                    be.method_11014(destTag);
                    be.method_5431();
                    success = true;
                }
                result[0] = success;
            });
            if (!result[0].booleanValue()) {
                return Value.FALSE;
            }
            return new BlockValue(finalSourceBlockState, world, targetLocator.block.getPos());
        });
        expression.addContextFunction("destroy", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2680 state = locator.block.getBlockState();
            if (state.method_26215()) {
                return Value.FALSE;
            }
            class_2338 where = locator.block.getPos();
            class_2586 be = world.method_8321(where);
            long how = 0L;
            class_1792 item = class_1802.field_8377;
            boolean playerBreak = false;
            if (lv.size() > locator.offset) {
                Value val = (Value)lv.get(locator.offset);
                if (val instanceof NumericValue) {
                    how = ((NumericValue)val).getLong();
                } else {
                    playerBreak = true;
                    String itemString = val.getString();
                    item = (class_1792)class_2378.field_11142.method_17966(InputValidator.identifierOf(itemString)).orElseThrow(() -> new ThrowStatement(itemString, Throwables.UNKNOWN_ITEM));
                }
            }
            class_2487 tag = null;
            if (lv.size() > locator.offset + 1) {
                if (!playerBreak) {
                    throw new InternalExpressionException("tag is not necessary with 'destroy' with no item");
                }
                Value tagValue = (Value)lv.get(locator.offset + 1);
                if (tagValue.isNull()) {
                    tag = null;
                } else if (tagValue instanceof NBTSerializableValue) {
                    tag = ((NBTSerializableValue)tagValue).getCompoundTag();
                } else {
                    NBTSerializableValue readTag = NBTSerializableValue.parseString(tagValue.getString(), true);
                    tag = readTag.getCompoundTag();
                }
            }
            class_1799 tool = new class_1799((class_1935)item, 1);
            if (tag != null) {
                tool.method_7980(tag);
            }
            if (playerBreak && (double)state.method_26214((class_1922)world, where) < 0.0) {
                return Value.FALSE;
            }
            boolean removed = world.method_8650(where, false);
            if (!removed) {
                return Value.FALSE;
            }
            world.method_8444(null, 2001, where, class_2248.method_9507((class_2680)state));
            boolean toolBroke = false;
            boolean dropLoot = true;
            if (playerBreak) {
                boolean isUsingEffectiveTool = !state.method_29291() || tool.method_7951(state);
                float hardness = state.method_26214((class_1922)world, where);
                int damageAmount = 0;
                if (item instanceof class_1766 && (double)hardness > 0.0 || item instanceof class_1820) {
                    damageAmount = 1;
                } else if (item instanceof class_1835 || item instanceof class_1829) {
                    damageAmount = 2;
                }
                boolean bl = toolBroke = damageAmount > 0 && tool.method_7970(damageAmount, world.method_8409(), null);
                if (!isUsingEffectiveTool) {
                    dropLoot = false;
                }
            }
            if (dropLoot) {
                if (how < 0L || tag != null && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)tool) > 0) {
                    class_2248.method_9577((class_1937)world, (class_2338)where, (class_1799)new class_1799((class_1935)state.method_26204()));
                } else {
                    if (how > 0L) {
                        tool.method_7978(class_1893.field_9130, (int)how);
                    }
                    if (DUMMY_ENTITY == null) {
                        DUMMY_ENTITY = new class_1540(class_1299.field_6089, null);
                    }
                    class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)where, (class_2586)be, (class_1297)DUMMY_ENTITY, (class_1799)tool);
                }
            }
            if (!playerBreak) {
                return Value.TRUE;
            }
            if (toolBroke) {
                return Value.NULL;
            }
            class_2487 outtag = tool.method_7969();
            if (outtag == null) {
                return Value.TRUE;
            }
            return new NBTSerializableValue(() -> WorldAccess.lambda$apply$71((class_2520)outtag));
        });
        expression.addContextFunction("harvest", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'harvest' takes at least 2 parameters: entity and block, or position, to harvest");
            }
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            Value entityValue = (Value)lv.get(0);
            if (!(entityValue instanceof EntityValue)) {
                return Value.FALSE;
            }
            class_1297 e = ((EntityValue)entityValue).getEntity();
            if (!(e instanceof class_3222)) {
                return Value.FALSE;
            }
            class_3222 player = (class_3222)e;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 1);
            class_2338 where = locator.block.getPos();
            class_2680 state = locator.block.getBlockState();
            class_2248 block = state.method_26204();
            boolean success = false;
            if (block != class_2246.field_9987 && block != class_2246.field_10499 || !player.field_13974.method_14267()) {
                success = player.field_13974.method_14266(where);
            }
            if (success) {
                world.method_8444(null, 2001, where, class_2248.method_9507((class_2680)state));
            }
            return BooleanValue.of(success);
        });
        expression.addContextFunction("create_explosion", -1, (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'create_explosion' requires at least a position to explode");
            }
            CarpetContext cc = (CarpetContext)c;
            float powah = 4.0f;
            class_1927.class_4179 mode = class_1927.class_4179.field_18686;
            boolean createFire = false;
            class_1297 source = null;
            class_1309 attacker = null;
            Vector3Argument location = Vector3Argument.findIn(lv, 0, false, true);
            class_243 pos = location.vec;
            if (lv.size() > location.offset) {
                powah = NumericValue.asNumber((Value)lv.get(location.offset), "explosion power").getFloat();
                if (powah < 0.0f) {
                    throw new InternalExpressionException("Explosion power cannot be negative");
                }
                if (lv.size() > location.offset + 1) {
                    String strval = ((Value)lv.get(location.offset + 1)).getString();
                    try {
                        mode = class_1927.class_4179.valueOf((String)strval.toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ile) {
                        throw new InternalExpressionException("Illegal explosions block behaviour: " + strval);
                    }
                    if (lv.size() > location.offset + 2) {
                        createFire = ((Value)lv.get(location.offset + 2)).getBoolean();
                        if (lv.size() > location.offset + 3) {
                            Value enVal = (Value)lv.get(location.offset + 3);
                            if (!enVal.isNull()) {
                                if (!(enVal instanceof EntityValue)) throw new InternalExpressionException("Fourth parameter of the explosion has to be an entity, not " + enVal.getTypeString());
                                source = ((EntityValue)enVal).getEntity();
                            }
                            if (lv.size() > location.offset + 4 && !(enVal = (Value)lv.get(location.offset + 4)).isNull()) {
                                if (!(enVal instanceof EntityValue)) throw new InternalExpressionException("Fifth parameter of the explosion has to be a living entity, not " + enVal.getTypeString());
                                class_1297 attackingEntity = ((EntityValue)enVal).getEntity();
                                if (!(attackingEntity instanceof class_1309)) throw new InternalExpressionException("Attacking entity needs to be a living thing, " + ValueConversions.of(class_2378.field_11145.method_10221((Object)attackingEntity.method_5864())).getString() + " ain't it.");
                                attacker = (class_1309)attackingEntity;
                            }
                        }
                    }
                }
            }
            final class_1309 theAttacker = attacker;
            float thePowah = powah;
            class_1927 explosion = new class_1927((class_1937)cc.s.method_9225(), source, null, null, pos.field_1352, pos.field_1351, pos.field_1350, powah, createFire, mode){

                @Nullable
                public class_1309 method_8347() {
                    return theAttacker;
                }
            };
            explosion.method_8348();
            explosion.method_8350(false);
            if (mode == class_1927.class_4179.field_18685) {
                explosion.method_8352();
            }
            cc.s.method_9225().method_18456().forEach(spe -> {
                if (spe.method_5707(pos) < 4096.0) {
                    spe.field_13987.method_14364((class_2596)new class_2664(pos.field_1352, pos.field_1351, pos.field_1350, thePowah, explosion.method_8346(), (class_243)explosion.method_8351().get(spe)));
                }
            });
            return Value.TRUE;
        });
        expression.addContextFunction("place_item", -1, (c, t, lv) -> {
            BlockValue.PlacementContext ctx;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'place_item' takes at least 2 parameters: item and block, or position, to place onto");
            }
            CarpetContext cc = (CarpetContext)c;
            String itemString = ((Value)lv.get(0)).getString();
            Vector3Argument locator = Vector3Argument.findIn(lv, 1);
            class_2290 stackArg = NBTSerializableValue.parseItem(itemString);
            class_2338 where = new class_2338(locator.vec);
            String facing = lv.size() > locator.offset ? ((Value)lv.get(locator.offset)).getString() : (stackArg.method_9785() != class_1802.field_8892 ? "up" : "north");
            boolean sneakPlace = false;
            if (lv.size() > locator.offset + 1) {
                sneakPlace = ((Value)lv.get(locator.offset + 1)).getBoolean();
            }
            try {
                ctx = BlockValue.PlacementContext.from((class_1937)cc.s.method_9225(), where, facing, sneakPlace, stackArg.method_9781(1, false));
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException(e.getMessage());
            }
            if (!(stackArg.method_9785() instanceof class_1747)) {
                class_1269 useResult = ctx.method_8041().method_7981((class_1838)ctx);
                if (useResult == class_1269.field_21466 || useResult == class_1269.field_5812) {
                    return Value.TRUE;
                }
            } else {
                class_1747 blockItem = (class_1747)stackArg.method_9785();
                if (!ctx.method_7716()) {
                    return Value.FALSE;
                }
                class_2680 placementState = blockItem.method_7711().method_9605((class_1750)ctx);
                if (placementState != null && placementState.method_26184((class_4538)cc.s.method_9225(), where)) {
                    cc.s.method_9225().method_8652(where, placementState, 2);
                    class_2498 blockSoundGroup = placementState.method_26231();
                    cc.s.method_9225().method_8396(null, where, blockSoundGroup.method_10598(), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
                    return Value.TRUE;
                }
            }
            return Value.FALSE;
        });
        expression.addContextFunction("blocks_movement", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "blocks_movement", lv, (s, p) -> !s.method_26171((class_1922)((CarpetContext)c).s.method_9225(), p, class_10.field_50)));
        expression.addContextFunction("block_sound", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "block_sound", lv, (s, p) -> BlockInfo.soundName.get(s.method_26231())));
        expression.addContextFunction("material", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "material", lv, (s, p) -> BlockInfo.materialName.get(s.method_26207())));
        expression.addContextFunction("map_colour", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "map_colour", lv, (s, p) -> BlockInfo.mapColourName.get(s.method_26205((class_1922)((CarpetContext)c).s.method_9225(), p))));
        expression.addContextFunction("property", -1, (c, t, lv) -> {
            c.host.issueDeprecation("property(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2680 state = locator.block.getBlockState();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'property' requires to specify a property to query");
            }
            String tag = ((Value)lv.get(locator.offset)).getString();
            class_2689 states = state.method_26204().method_9595();
            class_2769 property = states.method_11663(tag);
            if (property == null) {
                return Value.NULL;
            }
            return new StringValue(state.method_11654(property).toString().toLowerCase(Locale.ROOT));
        });
        expression.addContextFunction("block_properties", -1, (c, t, lv) -> {
            c.host.issueDeprecation("block_properties(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            class_2680 state = locator.block.getBlockState();
            class_2689 states = state.method_26204().method_9595();
            return ListValue.wrap(states.method_11659().stream().map(p -> new StringValue(p.method_11899())).collect(Collectors.toList()));
        });
        expression.addContextFunction("block_state", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0, true);
            class_2680 state = locator.block.getBlockState();
            class_2689 states = state.method_26204().method_9595();
            if (locator.offset == lv.size()) {
                HashMap<Value, Value> properties = new HashMap<Value, Value>();
                for (class_2769 p : states.method_11659()) {
                    properties.put(StringValue.of(p.method_11899()), ValueConversions.fromProperty(state, p));
                }
                return MapValue.wrap(properties);
            }
            String tag = ((Value)lv.get(locator.offset)).getString();
            class_2769 property = states.method_11663(tag);
            if (property == null) {
                return Value.NULL;
            }
            return ValueConversions.fromProperty(state, property);
        });
        expression.addContextFunction("block_list", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                return ListValue.wrap(class_2378.field_11146.method_10235().stream().map(ValueConversions::of).collect(Collectors.toList()));
            }
            CarpetContext cc = (CarpetContext)c;
            class_2960 tag = InputValidator.identifierOf(((Value)lv.get(0)).getString());
            class_2378 blocks = cc.s.method_9211().method_30611().method_30530(class_2378.field_25105);
            Optional tagset = blocks.method_40266(class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)tag));
            if (tagset.isEmpty()) {
                return Value.NULL;
            }
            return ListValue.wrap(((class_6885.class_6888)tagset.get()).method_40239().map(b -> ValueConversions.of(blocks.method_10221((Object)((class_2248)b.comp_349())))).collect(Collectors.toList()));
        });
        expression.addContextFunction("block_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2378 blocks = cc.s.method_9211().method_30611().method_30530(class_2378.field_25105);
            if (lv.size() == 0) {
                return ListValue.wrap(blocks.method_40273().map(ValueConversions::of).collect(Collectors.toList()));
            }
            BlockArgument blockLocator = BlockArgument.findIn(cc, lv, 0, true);
            if (blockLocator.offset == lv.size()) {
                class_2248 target = blockLocator.block.getBlockState().method_26204();
                return ListValue.wrap(blocks.method_40272().filter(e -> ((class_6885.class_6888)e.getSecond()).method_40239().anyMatch(h -> h.comp_349() == target)).map(e -> ValueConversions.of((class_6862)e.getFirst())).collect(Collectors.toList()));
            }
            String tag = ((Value)lv.get(blockLocator.offset)).getString();
            Optional tagSet = blocks.method_40266(class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)InputValidator.identifierOf(tag)));
            if (tagSet.isEmpty()) {
                return Value.NULL;
            }
            return BooleanValue.of(blockLocator.block.getBlockState().method_40143((class_6885)tagSet.get()));
        });
        expression.addContextFunction("biome", -1, (c, t, lv) -> {
            class_1959 biome;
            Object patt57175$temp;
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            if (lv.size() == 0) {
                return ListValue.wrap(world.method_30349().method_30530(class_2378.field_25114).method_10235().stream().map(ValueConversions::of));
            }
            class_1966 biomeSource = world.method_14178().method_12129().method_12098();
            if (lv.size() == 1 && (patt57175$temp = lv.get(0)) instanceof MapValue) {
                MapValue map = (MapValue)patt57175$temp;
                if (biomeSource instanceof class_4766) {
                    class_4766 mnbs = (class_4766)biomeSource;
                    Value temperature = map.get(new StringValue("temperature"));
                    WorldAccess.nullCheck(temperature, "temperature");
                    Value humidity = map.get(new StringValue("humidity"));
                    WorldAccess.nullCheck(humidity, "humidity");
                    Value continentalness = map.get(new StringValue("continentalness"));
                    WorldAccess.nullCheck(continentalness, "continentalness");
                    Value erosion = map.get(new StringValue("erosion"));
                    WorldAccess.nullCheck(erosion, "erosion");
                    Value depth = map.get(new StringValue("depth"));
                    WorldAccess.nullCheck(depth, "depth");
                    Value weirdness = map.get(new StringValue("weirdness"));
                    WorldAccess.nullCheck(weirdness, "weirdness");
                    class_6544.class_6553 point = new class_6544.class_6553(class_6544.method_38665((float)WorldAccess.numberGetOrThrow(temperature)), class_6544.method_38665((float)WorldAccess.numberGetOrThrow(humidity)), class_6544.method_38665((float)WorldAccess.numberGetOrThrow(continentalness)), class_6544.method_38665((float)WorldAccess.numberGetOrThrow(erosion)), class_6544.method_38665((float)WorldAccess.numberGetOrThrow(depth)), class_6544.method_38665((float)WorldAccess.numberGetOrThrow(weirdness)));
                    class_1959 biome2 = (class_1959)mnbs.method_38167(point).comp_349();
                    class_2960 biomeId = cc.s.method_9211().method_30611().method_30530(class_2378.field_25114).method_10221((Object)biome2);
                    return new StringValue(NBTSerializableValue.nameFromRegistryId(biomeId));
                }
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false, false, true);
            if (locator.replacement != null) {
                biome = (class_1959)world.method_30349().method_30530(class_2378.field_25114).method_10223(InputValidator.identifierOf(locator.replacement));
                if (biome == null) {
                    throw new ThrowStatement(locator.replacement, Throwables.UNKNOWN_BIOME);
                }
            } else {
                class_2338 pos = locator.block.getPos();
                biome = (class_1959)world.method_23753(pos).comp_349();
            }
            if (locator.offset == lv.size()) {
                class_2960 biomeId = cc.s.method_9211().method_30611().method_30530(class_2378.field_25114).method_10221((Object)biome);
                return new StringValue(NBTSerializableValue.nameFromRegistryId(biomeId));
            }
            String biomeFeature = ((Value)lv.get(locator.offset)).getString();
            BiFunction<class_3218, class_1959, Value> featureProvider = BiomeInfo.biomeFeatures.get(biomeFeature);
            if (featureProvider == null) {
                throw new InternalExpressionException("Unknown biome feature: " + biomeFeature);
            }
            return featureProvider.apply(world, biome);
        });
        expression.addContextFunction("set_biome", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_biome' needs a biome name as an argument");
            }
            String biomeName = ((Value)lv.get(locator.offset + 0)).getString();
            class_6880 biome = (class_6880)cc.s.method_9211().method_30611().method_30530(class_2378.field_25114).method_40264(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)InputValidator.identifierOf(biomeName))).orElseThrow(() -> new ThrowStatement(biomeName, Throwables.UNKNOWN_BIOME));
            boolean doImmediateUpdate = true;
            if (lv.size() > locator.offset + 1) {
                doImmediateUpdate = ((Value)lv.get(locator.offset + 1)).getBoolean();
            }
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            class_2791 chunk = world.method_22350(pos);
            int biomeX = class_5742.method_33100((int)pos.method_10263());
            int biomeY = class_5742.method_33100((int)pos.method_10264());
            int biomeZ = class_5742.method_33100((int)pos.method_10260());
            try {
                int i = class_5742.method_33100((int)chunk.method_31607());
                int j = i + class_5742.method_33100((int)chunk.method_31605()) - 1;
                int k = class_3532.method_15340((int)biomeY, (int)i, (int)j);
                int l = chunk.method_31602(class_5742.method_33101((int)k));
                chunk.method_38259(l).method_38294().method_35321(biomeX & 3, k & 3, biomeZ & 3, (Object)biome);
            }
            catch (Throwable var8) {
                return Value.FALSE;
            }
            if (doImmediateUpdate) {
                WorldTools.forceChunkUpdate(pos, world);
            }
            chunk.method_12008(true);
            return Value.TRUE;
        });
        expression.addContextFunction("reload_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2338 pos = BlockArgument.findIn((CarpetContext)cc, (List<Value>)lv, (int)0).block.getPos();
            class_3218 world = cc.s.method_9225();
            cc.s.method_9211().method_19537(() -> WorldTools.forceChunkUpdate(pos, world));
            return Value.TRUE;
        });
        expression.addContextFunction("structure_references", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            Map references = world.method_22342(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_16422).method_12179();
            class_2378 reg = cc.s.method_9211().method_30611().method_30530(class_2378.field_25915);
            if (lv.size() == locator.offset) {
                return ListValue.wrap(references.entrySet().stream().filter(e -> e.getValue() != null && !((LongSet)e.getValue()).isEmpty()).map(e -> new StringValue(NBTSerializableValue.nameFromRegistryId(reg.method_10221((Object)((class_5312)e.getKey()))))).collect(Collectors.toList()));
            }
            String simpleStructureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            class_5312 structureName = (class_5312)reg.method_10223(InputValidator.identifierOf(simpleStructureName));
            if (structureName == null) {
                return Value.NULL;
            }
            LongSet structureReferences = (LongSet)references.get(structureName);
            if (structureReferences == null || structureReferences.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            return ListValue.wrap(structureReferences.longStream().mapToObj(l -> ListValue.of(new NumericValue(16 * class_1923.method_8325((long)l)), Value.ZERO, new NumericValue(16 * class_1923.method_8332((long)l)))).collect(Collectors.toList()));
        });
        expression.addContextFunction("structure_eligibility", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            WorldAccess.BooYah(world.method_14178().method_12129());
            class_2338 pos = locator.block.getPos();
            ArrayList<class_5312> structure = new ArrayList<class_5312>();
            boolean needSize = false;
            boolean singleOutput = false;
            class_2378 reg = cc.s.method_9211().method_30611().method_30530(class_2378.field_25915);
            if (lv.size() > locator.offset) {
                Value requested = (Value)lv.get(locator.offset + 0);
                if (!requested.isNull()) {
                    String reqString = requested.getString();
                    class_2960 id = InputValidator.identifierOf(reqString);
                    class_5312 requestedStructure = (class_5312)reg.method_10223(id);
                    if (requestedStructure != null) {
                        singleOutput = true;
                        structure.add(requestedStructure);
                    } else {
                        class_2378 reg1 = cc.s.method_9211().method_30611().method_30530(class_2378.field_25077);
                        class_3195 sss = (class_3195)reg1.method_10223(id);
                        reg.method_29722().stream().filter(e -> ((class_5312)e.getValue()).field_24835 == sss).forEach(e -> structure.add((class_5312)e.getValue()));
                    }
                    if (structure.isEmpty()) {
                        throw new ThrowStatement(reqString, Throwables.UNKNOWN_STRUCTURE);
                    }
                } else {
                    structure.addAll(reg.method_29722().stream().map(Map.Entry::getValue).toList());
                }
                if (lv.size() > locator.offset + 1) {
                    needSize = ((Value)lv.get(locator.offset + 1)).getBoolean();
                }
            } else {
                structure.addAll(reg.method_29722().stream().map(Map.Entry::getValue).toList());
            }
            if (singleOutput) {
                class_3449 start = FeatureGenerator.shouldStructureStartAt(world, pos, (class_5312)structure.get(0), needSize);
                if (start == null) {
                    return Value.NULL;
                }
                if (!needSize) {
                    return Value.TRUE;
                }
                return ValueConversions.of(start);
            }
            HashMap<Value, Value> ret = new HashMap<Value, Value>();
            for (class_5312 str : structure) {
                class_3449 start;
                try {
                    start = FeatureGenerator.shouldStructureStartAt(world, pos, str, needSize);
                }
                catch (NullPointerException npe) {
                    CarpetSettings.LOG.error("Failed to detect structure: " + reg.method_10221((Object)str));
                    start = null;
                }
                if (start == null) continue;
                StringValue key = new StringValue(NBTSerializableValue.nameFromRegistryId(reg.method_10221((Object)str)));
                ret.put(key, !needSize ? Value.NULL : ValueConversions.of(start));
            }
            return MapValue.wrap(ret);
        });
        expression.addContextFunction("structures", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            Map structures = world.method_22342(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_16423).method_12016();
            class_2378 reg = cc.s.method_9211().method_30611().method_30530(class_2378.field_25915);
            if (lv.size() == locator.offset) {
                HashMap<Value, Value> structureList = new HashMap<Value, Value>();
                for (Map.Entry entry : structures.entrySet()) {
                    class_3449 start = (class_3449)entry.getValue();
                    if (start == class_3449.field_16713) continue;
                    class_3341 box = start.method_14969();
                    structureList.put(new StringValue(NBTSerializableValue.nameFromRegistryId(reg.method_10221((Object)((class_5312)entry.getKey())))), ListValue.of(ListValue.fromTriple(box.method_35415(), box.method_35416(), box.method_35417()), ListValue.fromTriple(box.method_35418(), box.method_35419(), box.method_35420())));
                }
                return MapValue.wrap(structureList);
            }
            String structureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            return ValueConversions.of((class_3449)structures.get(reg.method_10223(InputValidator.identifierOf(structureName))));
        });
        expression.addContextFunction("set_structure", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_3218 world = cc.s.method_9225();
            class_2338 pos = locator.block.getPos();
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_structure requires at least position and a structure name");
            }
            String structureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            class_5312<?, ?> configuredStructure = FeatureGenerator.resolveConfiguredStructure(structureName, world, pos);
            if (configuredStructure == null) {
                throw new ThrowStatement(structureName, Throwables.UNKNOWN_STRUCTURE);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                Map structures = world.method_22350(pos).method_12016();
                if (lv.size() == locator.offset + 1) {
                    Boolean res = FeatureGenerator.plopGrid(configuredStructure, ((CarpetContext)c).s.method_9225(), locator.block.getPos());
                    if (res == null) {
                        return;
                    }
                    result[0] = res != false ? Value.TRUE : Value.FALSE;
                    return;
                }
                Value newValue = (Value)lv.get(locator.offset + 1);
                if (newValue.isNull()) {
                    class_5312 structure = configuredStructure;
                    if (!structures.containsKey(structure)) {
                        return;
                    }
                    class_3449 start = (class_3449)structures.get(structure);
                    class_1923 structureChunkPos = start.method_34000();
                    class_3341 box = start.method_14969();
                    for (int chx = box.method_35415() / 16; chx <= box.method_35418() / 16; ++chx) {
                        for (int chz = box.method_35417() / 16; chz <= box.method_35420() / 16; ++chz) {
                            class_1923 chpos = new class_1923(chx, chz);
                            Map references = world.method_22350(chpos.method_8323()).method_12179();
                            if (!references.containsKey(structure) || references.get(structure) == null) continue;
                            ((LongSet)references.get(structure)).remove(structureChunkPos.method_8324());
                        }
                    }
                    structures.remove(structure);
                    result[0] = Value.TRUE;
                }
            });
            return result[0];
        });
        expression.addContextFunction("custom_dimension", -1, (c, t, lv) -> {
            boolean success;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'custom_dimension' requires at least one argument");
            }
            CarpetContext cc = (CarpetContext)c;
            cc.host.issueDeprecation("custom_dimension()");
            String worldKey = ((Value)lv.get(0)).getString();
            Long seed = null;
            if (lv.size() > 1) {
                String seedKey = ((Value)lv.get(1)).getString();
                try {
                    seed = Long.parseLong(seedKey);
                }
                catch (NumberFormatException ignored) {
                    throw new InternalExpressionException("Incorrect number format for seed: " + seedKey);
                }
            }
            if (!(success = WorldTools.createWorld(cc.s.method_9211(), worldKey, seed))) {
                return Value.FALSE;
            }
            CarpetServer.settingsManager.notifyPlayersCommandsChanged();
            return Value.TRUE;
        });
        expression.addContextFunction("reset_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ArrayList<class_1923> requestedChunks = new ArrayList<class_1923>();
            if (lv.size() == 1) {
                Value first = (Value)lv.get(0);
                if (first instanceof ListValue) {
                    List<Value> listVal = ((ListValue)first).getItems();
                    BlockArgument locator = BlockArgument.findIn(cc, listVal, 0);
                    requestedChunks.add(new class_1923(locator.block.getPos()));
                    while (listVal.size() > locator.offset) {
                        locator = BlockArgument.findIn(cc, listVal, locator.offset);
                        requestedChunks.add(new class_1923(locator.block.getPos()));
                    }
                } else {
                    BlockArgument locator = BlockArgument.findIn(cc, Collections.singletonList(first), 0);
                    requestedChunks.add(new class_1923(locator.block.getPos()));
                }
            } else {
                BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
                class_1923 from = new class_1923(locator.block.getPos());
                if (lv.size() > locator.offset) {
                    locator = BlockArgument.findIn(cc, lv, locator.offset);
                    class_1923 to = new class_1923(locator.block.getPos());
                    int xmax = Math.max(from.field_9181, to.field_9181);
                    int zmax = Math.max(from.field_9180, to.field_9180);
                    for (int x = Math.min(from.field_9181, to.field_9181); x <= xmax; ++x) {
                        for (int z = Math.min(from.field_9180, to.field_9180); z <= zmax; ++z) {
                            requestedChunks.add(new class_1923(x, z));
                        }
                    }
                } else {
                    requestedChunks.add(from);
                }
            }
            class_3218 world = cc.s.method_9225();
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).s.method_9211().method_19537(() -> {
                Map<String, Integer> report = ((ThreadedAnvilChunkStorageInterface)world.method_14178().field_17254).regenerateChunkRegion(requestedChunks);
                result[0] = MapValue.wrap(report.entrySet().stream().collect(Collectors.toMap(e -> new StringValue((String)e.getKey()), e -> new NumericValue(((Integer)e.getValue()).intValue()))));
            });
            return result[0];
        });
        expression.addContextFunction("inhabited_time", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            return new NumericValue(cc.s.method_9225().method_22350(pos).method_12033());
        });
        expression.addContextFunction("spawn_potential", -1, (c, t, lv) -> {
            class_1948.class_5262 charger;
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            double required_charge = 1.0;
            if (lv.size() > locator.offset) {
                required_charge = NumericValue.asNumber((Value)lv.get(locator.offset)).getDouble();
            }
            if ((charger = cc.s.method_9225().method_14178().method_27908()) == null) {
                return Value.NULL;
            }
            return new NumericValue(((SpawnHelperInnerInterface)charger).getPotentialCalculator().method_27832(pos, required_charge));
        });
        expression.addContextFunction("add_chunk_ticket", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            class_2338 pos = locator.block.getPos();
            if (lv.size() != locator.offset + 2) {
                throw new InternalExpressionException("'add_chunk_ticket' requires block position, ticket type and radius");
            }
            String type = ((Value)lv.get(locator.offset)).getString();
            class_3230<?> ticket = ticketTypes.get(type.toLowerCase(Locale.ROOT));
            if (ticket == null) {
                throw new InternalExpressionException("Unknown ticket type: " + type);
            }
            int radius = NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getInt();
            if (radius < 1 || radius > 32) {
                throw new InternalExpressionException("Ticket radius should be between 1 and 32 chunks");
            }
            class_1923 target = new class_1923(pos);
            if (ticket == class_3230.field_19280) {
                cc.s.method_9225().method_14178().method_17297(class_3230.field_19280, target, radius, (Object)pos);
            } else if (ticket == class_3230.field_19347) {
                cc.s.method_9225().method_14178().method_17297(class_3230.field_19347, target, radius, (Object)1);
            } else {
                cc.s.method_9225().method_14178().method_17297(class_3230.field_14032, target, radius, (Object)target);
            }
            return new NumericValue(ticket.method_20629());
        });
    }

    @ScarpetFunction(maxParams=-1)
    public Value sample_noise(Context c, @Locator.Block class_2338 pos, String ... noiseQueries) {
        return Value.NULL;
    }

    private static /* synthetic */ class_2520 lambda$apply$71(class_2520 outtag) {
        return outtag;
    }

    static {
        DIRECTION_MAP.put("y", class_2350.field_11036);
        DIRECTION_MAP.put("z", class_2350.field_11035);
        DIRECTION_MAP.put("x", class_2350.field_11034);
        ticketTypes = new HashMap<String, class_3230<?>>(){
            {
                this.put("portal", class_3230.field_19280);
                this.put("teleport", class_3230.field_19347);
                this.put("unknown", class_3230.field_14032);
            }
        };
        DUMMY_ENTITY = null;
    }
}

