/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.exception;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.Tokenizer;
import carpet.script.exception.ResolvedException;
import carpet.script.value.FunctionValue;
import carpet.utils.Messenger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public class ExpressionException
extends RuntimeException
implements ResolvedException {
    public final Context context;
    public final Tokenizer.Token token;
    public final List<FunctionValue> stack = new ArrayList<FunctionValue>();
    private final Supplier<String> lazyMessage;
    private String cachedMessage = null;
    private static final Fluff.TriFunction<Expression, Tokenizer.Token, String, List<String>> errorMaker = (expr, token, errmessage) -> {
        ArrayList<Object> errMsg = new ArrayList<Object>();
        errmessage = (String)errmessage + (String)(expr.getModuleName() == null ? "" : " in " + expr.getModuleName());
        if (token != null) {
            List<String> snippet = expr.getExpressionSnippet((Tokenizer.Token)token);
            errMsg.addAll(snippet);
            errmessage = snippet.size() != 1 ? (String)errmessage + " at line " + (token.lineno + 1) + ", pos " + (token.linepos + 1) : (String)errmessage + " at pos " + (token.pos + 1);
        }
        errMsg.add(errmessage);
        return errMsg;
    };

    public static void prepareForDoom() {
        Messenger.c("foo bar");
    }

    public ExpressionException(Context c, Expression e, String message) {
        this(c, e, Tokenizer.Token.NONE, message);
    }

    public ExpressionException(Context c, Expression e, Tokenizer.Token t, String message) {
        this(c, e, t, message, Collections.emptyList());
    }

    public ExpressionException(Context c, Expression e, Tokenizer.Token t, String message, List<FunctionValue> stack) {
        super("Error");
        this.stack.addAll(stack);
        this.lazyMessage = () -> ExpressionException.makeMessage(c, e, t, message);
        this.token = t;
        this.context = c;
    }

    public ExpressionException(Context c, Expression e, Tokenizer.Token t, Supplier<String> messageSupplier, List<FunctionValue> stack) {
        super("Error");
        this.stack.addAll(stack);
        this.lazyMessage = () -> ExpressionException.makeMessage(c, e, t, (String)messageSupplier.get());
        this.token = t;
        this.context = c;
    }

    static synchronized String makeMessage(Context c, Expression e, Tokenizer.Token t, String message) throws ExpressionException {
        List<String> alternative;
        if (c.getErrorSnooper() != null && (alternative = c.getErrorSnooper().apply(e, t, c, message)) != null) {
            return String.join((CharSequence)"\n", alternative);
        }
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)errorMaker.apply(e, t, message));
    }

    @Override
    public String getMessage() {
        if (this.cachedMessage == null) {
            this.cachedMessage = this.lazyMessage.get();
        }
        return this.cachedMessage;
    }
}

