/*
 * Decompiled with CFR 0.152.
 */
package org.cloudwarp.doodads.entities;

import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2643;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import org.cloudwarp.doodads.registry.DDamageSource;
import org.cloudwarp.doodads.registry.DParticles;
import org.jetbrains.annotations.Nullable;

public abstract class SlingShotProjectileEntity
extends class_1676 {
    private static final class_2940<Byte> PROJECTILE_FLAGS = class_2945.method_12791(SlingShotProjectileEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(SlingShotProjectileEntity.class, (class_2941)class_2943.field_13322);
    private static final int CRITICAL_FLAG = 1;
    private double damage = 2.0;
    private int punch;
    private int life;
    private class_3414 sound = this.getHitSound();

    public SlingShotProjectileEntity(class_1299<? extends SlingShotProjectileEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SlingShotProjectileEntity(class_1299<? extends SlingShotProjectileEntity> entityType, class_1309 owner, class_1937 world) {
        this(entityType, owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321(), world);
        this.method_7432((class_1297)owner);
    }

    public SlingShotProjectileEntity(class_1299<? extends SlingShotProjectileEntity> entityType, double x, double y, double z, class_1937 world) {
        this(entityType, world);
        this.method_5814(x, y, z);
    }

    public void setSound(class_3414 sound) {
        this.sound = sound;
    }

    public boolean method_5640(double distance) {
        double d = this.method_5829().method_995() * 10.0;
        if (Double.isNaN(d)) {
            d = 1.0;
        }
        return distance < (d *= 64.0 * SlingShotProjectileEntity.method_5824()) * d;
    }

    protected void method_5693() {
        this.field_6011.method_12784(PROJECTILE_FLAGS, (Object)0);
        this.method_5841().method_12784(ITEM, (Object)class_1799.field_8037);
    }

    public void method_7485(double x, double y, double z, float speed, float divergence) {
        super.method_7485(x, y, z, speed, divergence);
        this.life = 0;
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    public void method_5750(double x, double y, double z) {
        super.method_5750(x, y, z);
        this.life = 0;
    }

    public void method_5773() {
        float h;
        int i;
        super.method_5773();
        class_239 hitResult = class_1675.method_18074((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        boolean bl = false;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockPos = ((class_3965)hitResult).method_17777();
            class_2680 blockState = this.field_6002.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_10316)) {
                this.method_5717(blockPos);
                bl = true;
            } else if (blockState.method_27852(class_2246.field_10613)) {
                class_2586 blockEntity = this.field_6002.method_8321(blockPos);
                if (blockEntity instanceof class_2643 && class_2643.method_30276((class_1297)this)) {
                    class_2643.method_11409((class_1937)this.field_6002, (class_2338)blockPos, (class_2680)blockState, (class_1297)this, (class_2643)((class_2643)blockEntity));
                }
                bl = true;
            } else if (blockState.method_26164(ConventionalBlockTags.GLASS_BLOCKS) || blockState.method_26164(ConventionalBlockTags.GLASS_PANES)) {
                this.field_6002.method_8651(blockPos, false, (class_1297)this);
                bl = false;
            } else if (blockState.method_27852(class_2246.field_27879)) {
                this.method_5646();
                bl = true;
            }
        }
        if (this.method_5721()) {
            this.method_5646();
        }
        if (hitResult.method_17783() != class_239.class_240.field_1333 && !bl) {
            this.method_7488(hitResult);
        }
        this.method_5852();
        class_243 vec3d = this.method_18798();
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_23318() + vec3d.field_1351;
        double f = this.method_23321() + vec3d.field_1350;
        this.method_26962();
        if (this.isCritical()) {
            for (i = 0; i < 4; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11205, this.method_23317() + d * (double)i / 4.0, this.method_23318() + e * (double)i / 4.0, this.method_23321() + f * (double)i / 4.0, -d, -e + 0.2, -f);
            }
        }
        if (this.method_5799()) {
            for (i = 0; i < 4; ++i) {
                float g = 0.25f;
                this.field_6002.method_8406((class_2394)class_2398.field_11247, d - vec3d.field_1352 * 0.25, e - vec3d.field_1351 * 0.25, f - vec3d.field_1350 * 0.25, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            }
            h = 0.8f;
        } else {
            h = 0.99f;
        }
        this.method_18799(vec3d.method_1021((double)h));
        if (!this.method_5740()) {
            class_243 vec3d2 = this.method_18798();
            this.method_18800(vec3d2.field_1352, vec3d2.field_1351 - (double)this.getGravity(), vec3d2.field_1350);
        }
        this.method_5814(d, e, f);
    }

    protected void method_7454(class_3966 entityHitResult) {
        DDamageSource.DProjectileDamageSource damageSource;
        class_1297 entity2;
        super.method_7454(entityHitResult);
        class_1297 entity = entityHitResult.method_17782();
        float f = (float)this.method_18798().method_1033();
        int i = class_3532.method_15384((double)class_3532.method_15350((double)((double)f * this.damage), (double)0.0, (double)2.147483647E9));
        if (this.isCritical()) {
            long l = this.field_5974.nextInt(i / 2 + 2);
            i = (int)Math.min(l + (long)i, Integer.MAX_VALUE);
        }
        if ((entity2 = this.method_24921()) == null) {
            damageSource = new DDamageSource.DProjectileDamageSource("pebble", (class_1297)this, (class_1297)this);
        } else {
            damageSource = new DDamageSource.DProjectileDamageSource("pebble", (class_1297)this, entity2);
            if (entity2 instanceof class_1309) {
                ((class_1309)entity2).method_6114(entity);
            }
        }
        boolean bl = entity.method_5864() == class_1299.field_6091;
        int j = entity.method_20802();
        if (this.method_5809() && !bl) {
            entity.method_5639(5);
        }
        if (entity.method_5643((class_1282)damageSource, (float)i)) {
            if (bl) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (this.punch > 0) {
                    double d = Math.max(0.0, 1.0 - livingEntity.method_26825(class_5134.field_23718));
                    class_243 vec3d = this.method_18798().method_18805(1.0, 0.0, 1.0).method_1029().method_1021((double)this.punch * 0.6 * d);
                    if (vec3d.method_1027() > 0.0) {
                        livingEntity.method_5762(vec3d.field_1352, 0.1, vec3d.field_1350);
                    }
                }
                if (!this.field_6002.field_9236 && entity2 instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingEntity, (class_1297)entity2);
                    class_1890.method_8213((class_1309)((class_1309)entity2), (class_1297)livingEntity);
                }
                this.onHit(livingEntity);
                if (entity2 != null && livingEntity != entity2 && livingEntity instanceof class_1657 && entity2 instanceof class_3222 && !this.method_5701()) {
                    ((class_3222)entity2).field_13987.method_14364((class_2596)new class_2668(class_2668.field_25651, 0.0f));
                }
                this.method_5783(this.sound, 0.7f, 1.4f / (this.field_5974.nextFloat() * 0.2f + 0.9f));
            }
            this.method_31472();
        } else {
            entity.method_20803(j);
            this.method_18799(this.method_18798().method_1021(-0.1));
            this.method_36456(this.method_36454() + 180.0f);
            this.field_5982 += 180.0f;
            if (!this.field_6002.field_9236 && this.method_18798().method_1027() < 1.0E-7) {
                this.method_31472();
            }
        }
    }

    protected float getGravity() {
        return 0.04f;
    }

    protected void onHit(class_1309 target) {
    }

    protected class_3414 getHitSound() {
        return class_3417.field_15026;
    }

    protected final class_3414 getSound() {
        return this.sound;
    }

    @Nullable
    protected class_3966 getEntityCollision(class_243 currentPosition, class_243 nextPosition) {
        return class_1675.method_18077((class_1937)this.field_6002, (class_1297)this, (class_243)currentPosition, (class_243)nextPosition, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
    }

    public void setItem(class_1799 item) {
        if (!item.method_31574(this.getDefaultItem()) || item.method_7985()) {
            this.method_5841().method_12778(ITEM, (Object)((class_1799)class_156.method_654((Object)item.method_7972(), stack -> stack.method_7939(1))));
        }
    }

    protected abstract class_1792 getDefaultItem();

    protected class_1799 getItem() {
        return (class_1799)this.method_5841().method_12789(ITEM);
    }

    public class_1799 getStack() {
        class_1799 itemStack = this.getItem();
        return itemStack.method_7960() ? new class_1799((class_1935)this.getDefaultItem()) : itemStack;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10549("damage", this.damage);
        nbt.method_10556("crit", this.isCritical());
        nbt.method_10582("SoundEvent", class_2378.field_11156.method_10221((Object)this.sound).toString());
        class_1799 itemStack = this.getItem();
        if (!itemStack.method_7960()) {
            nbt.method_10566("Item", (class_2520)itemStack.method_7953(new class_2487()));
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("damage", 99)) {
            this.damage = nbt.method_10574("damage");
        }
        this.setCritical(nbt.method_10577("crit"));
        if (nbt.method_10573("SoundEvent", 8)) {
            this.sound = class_2378.field_11156.method_17966(new class_2960(nbt.method_10558("SoundEvent"))).orElse(this.getHitSound());
        }
        class_1799 itemStack = class_1799.method_7915((class_2487)nbt.method_10562("Item"));
        this.setItem(itemStack);
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setPunch(int punch) {
        this.punch = punch;
    }

    public int getPunch() {
        return this.punch;
    }

    public boolean method_5732() {
        return false;
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return 0.13f;
    }

    public void setCritical(boolean critical) {
        this.setProjectileFlag(1, critical);
    }

    private void setProjectileFlag(int index, boolean flag) {
        byte b = (Byte)this.field_6011.method_12789(PROJECTILE_FLAGS);
        if (flag) {
            this.field_6011.method_12778(PROJECTILE_FLAGS, (Object)((byte)(b | index)));
        } else {
            this.field_6011.method_12778(PROJECTILE_FLAGS, (Object)((byte)(b & ~index)));
        }
    }

    public boolean isCritical() {
        byte b = (Byte)this.field_6011.method_12789(PROJECTILE_FLAGS);
        return (b & 1) != 0;
    }

    public void applyEnchantmentEffects(class_1309 entity, float damageModifier) {
        int i = class_1890.method_8203((class_1887)class_1893.field_9103, (class_1309)entity);
        int j = class_1890.method_8203((class_1887)class_1893.field_9116, (class_1309)entity);
        this.setDamage((double)(damageModifier * 2.0f) + this.field_5974.nextGaussian() * 0.25 + (double)((float)this.field_6002.method_8407().method_5461() * 0.11f));
        if (i > 0) {
            this.setDamage(this.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.setPunch(j);
        }
        if (class_1890.method_8203((class_1887)class_1893.field_9126, (class_1309)entity) > 0) {
            this.method_5639(100);
        }
    }

    protected float getDragInWater() {
        return 0.6f;
    }

    public void setNoClip(boolean noClip) {
        this.field_5960 = noClip;
        this.setProjectileFlag(2, noClip);
    }

    public boolean isNoClip() {
        if (!this.field_6002.field_9236) {
            return this.field_5960;
        }
        return ((Byte)this.field_6011.method_12789(PROJECTILE_FLAGS) & 2) != 0;
    }

    public class_2596<?> method_18002() {
        class_1297 entity = this.method_24921();
        return new class_2604((class_1297)this, entity == null ? 0 : entity.method_5628());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        class_1297 entity = this.field_6002.method_8469(packet.method_11166());
        if (entity != null) {
            this.method_7432(entity);
        }
    }

    private class_2394 getParticleParameters() {
        class_1799 itemStack = this.getItem();
        return itemStack.method_7960() ? DParticles.PEBBLE_PARTICLE : new class_2392(class_2398.field_11218, itemStack);
    }

    public void method_5711(byte status) {
        if (status == 3) {
            class_2394 particleEffect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                this.field_6002.method_8406(particleEffect, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!this.field_6002.field_9236) {
            this.field_6002.method_8421((class_1297)this, (byte)3);
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_5783(this.getSound(), 1.0f, 1.2f / (this.field_5974.nextFloat() * 0.2f + 0.9f));
    }
}

