/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.fabric;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1273;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2595;
import net.minecraft.class_2609;
import net.minecraft.class_2611;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import snownee.jade.Jade;
import snownee.jade.JadeCommonConfig;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum BlockInventoryProvider implements IBlockComponentProvider,
IServerDataProvider<class_2586>
{
    INSTANCE;

    public static final Set<String> INVENTORY_IGNORE;

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof class_2609) {
            return;
        }
        BlockInventoryProvider.append(tooltip, accessor);
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor) {
        if (accessor.getServerData().method_10577("Loot")) {
            tooltip.add((class_2561)new class_2588("jade.not_generated"));
            return;
        }
        if (accessor.getServerData().method_10577("Locked")) {
            tooltip.add((class_2561)new class_2588("jade.locked"));
            return;
        }
        if (accessor.getServerData().method_10545("JadeHandler")) {
            class_1799 stack;
            class_2499 list = accessor.getServerData().method_10554("JadeHandler", 10);
            class_1277 container = new class_1277(list.size());
            container.method_7659(list);
            int drawnCount = 0;
            int realSize = container.method_5439();
            boolean showName = realSize < 5;
            IElementHelper helper = tooltip.getElementHelper();
            ArrayList elements = Lists.newArrayList();
            for (int i = 0; i < realSize && !(stack = container.method_5438(i)).method_7960(); ++i) {
                if (i > 0 && (showName || drawnCount >= JadeCommonConfig.inventoryShowItemPreLine)) {
                    tooltip.add(elements);
                    elements.clear();
                    drawnCount = 0;
                }
                if (showName) {
                    class_1799 copy = stack.method_7972();
                    copy.method_7939(1);
                    elements.add(Jade.smallItem(helper, copy).clearCachedMessage());
                    elements.add(helper.text((class_2561)new class_2585(Integer.toString(stack.method_7947())).method_27693("\u00d7 ").method_10852(stack.method_7964())).message(null));
                } else {
                    elements.add(helper.item(stack));
                }
                ++drawnCount;
            }
            if (!elements.isEmpty()) {
                tooltip.add(elements);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void appendServerData(class_2487 tag, class_3222 player, class_1937 world, class_2586 te, boolean showDetails) {
        if (te == null || JadeCommonConfig.shouldIgnoreTE(tag.method_10558("id")) || te instanceof class_2609) {
            return;
        }
        v0 = size = showDetails != false ? JadeCommonConfig.inventoryDetailedShowAmount : JadeCommonConfig.inventoryNormalShowAmount;
        if (size == 0) {
            return;
        }
        if (te instanceof class_2621 && ((class_2621)te).field_12037 != null) {
            tag.method_10556("Loot", true);
            return;
        }
        if (!JadeCommonConfig.bypassLockedContainer && !player.method_7337() && !player.method_7325() && te instanceof class_2624) {
            lockableBlockEntity = (class_2624)te;
            if (lockableBlockEntity.field_12045 != class_1273.field_5817) {
                tag.method_10556("Locked", true);
                return;
            }
        }
        container = null;
        state = te.method_11010();
        var11_9 = state.method_26204();
        if (!(var11_9 instanceof class_2281)) ** GOTO lbl-1000
        chestBlock = (class_2281)var11_9;
        if (te instanceof class_2595) {
            chest = (class_2595)te;
            container = class_2281.method_17458((class_2281)chestBlock, (class_2680)state, (class_1937)world, (class_2338)te.method_11016(), (boolean)true);
        } else if (te instanceof class_1263) {
            container = (class_1263)te;
        } else if (te instanceof class_2611) {
            container = player.method_7274();
        }
        BlockInventoryProvider.putInvData(tag, container, size, 0);
    }

    public static void putInvData(class_2487 tag, class_1263 container, int size, int start) {
        if (container == null || size == 0) {
            return;
        }
        class_1277 merged = new class_1277(size + 1);
        boolean empty = true;
        int maxSlot = Math.min(container.method_5439(), start + 162);
        block0: for (int slot = start; slot < maxSlot; ++slot) {
            class_1799 stack = container.method_5438(slot);
            if (stack.method_7985() && stack.method_7969().method_10545("CustomModelData")) {
                for (String key : stack.method_7969().method_10541()) {
                    if (!key.toLowerCase(Locale.ENGLISH).endsWith("clear") || !stack.method_7969().method_10577(key)) continue;
                    continue block0;
                }
            }
            if (stack.method_7960()) continue;
            empty = false;
            merged.method_5491(stack.method_7972());
            if (!merged.method_5438(size - 1).method_7960()) break;
        }
        if (!empty) {
            tag.method_10566("JadeHandler", (class_2520)merged.method_7660());
        }
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.FABRIC_BLOCK_INVENTORY;
    }

    @Override
    public int getDefaultPriority() {
        return 2000;
    }

    static {
        INVENTORY_IGNORE = Collections.synchronizedSet(Sets.newHashSet());
    }
}

