/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5223;
import snownee.jade.Jade;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.ui.IBorderStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.overlay.DisplayHelper;

public class Tooltip
implements ITooltip {
    public final List<Line> lines = new ArrayList<Line>();
    public boolean sneakyDetails;
    private static final IBorderStyle RED = new BorderStyle().color(-1996554240);
    private static final IBorderStyle BLUE = new BorderStyle().color(-2013265665);

    @Override
    public void clear() {
        this.lines.clear();
    }

    @Override
    public void append(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        if (this.isEmpty() || index == this.size()) {
            this.add(element);
        } else {
            Line lastLine = this.lines.get(index);
            lastLine.getAlignedElements(element.getAlignment()).add(element);
        }
    }

    @Override
    public IElementHelper getElementHelper() {
        return ElementHelper.INSTANCE;
    }

    @Override
    public int size() {
        return this.lines.size();
    }

    @Override
    public void add(int index, IElement element) {
        if (element.getTag() == null) {
            element.tag(ElementHelper.INSTANCE.currentUid());
        }
        Line line = new Line();
        line.getAlignedElements(element.getAlignment()).add(element);
        this.lines.add(index, line);
    }

    @Override
    public List<IElement> get(class_2960 tag) {
        ArrayList elements = Lists.newArrayList();
        for (Line line : this.lines) {
            line.left.stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
            line.right.stream().filter(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag())).forEach(elements::add);
        }
        return elements;
    }

    @Override
    public List<IElement> get(int index, IElement.Align align) {
        Line line = this.lines.get(index);
        return line.getAlignedElements(align);
    }

    @Override
    public void remove(class_2960 tag) {
        Iterator<Line> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = iterator.next();
            line.left.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()));
            line.right.removeIf(e -> com.google.common.base.Objects.equal((Object)tag, (Object)e.getTag()));
            if (!line.left.isEmpty() || !line.right.isEmpty()) continue;
            iterator.remove();
        }
    }

    public static void drawBorder(class_4587 matrixStack, float x, float y, IElement element) {
        if (Jade.CONFIG.get().getGeneral().isDebug()) {
            class_241 translate = element.getTranslation();
            class_241 size = element.getCachedSize();
            DisplayHelper.INSTANCE.drawBorder(matrixStack, x, y, x + size.field_1343, y + size.field_1342, RED);
            if (!class_241.field_1340.method_1016(translate)) {
                DisplayHelper.INSTANCE.drawBorder(matrixStack, x + translate.field_1343, y + translate.field_1342, x + translate.field_1343 + size.field_1343, y + translate.field_1342 + size.field_1342, BLUE);
            }
        }
    }

    @Override
    public String getMessage() {
        ArrayList msgs = Lists.newArrayList();
        for (Line line : this.lines) {
            msgs.add(Joiner.on((char)' ').join(Stream.concat(line.left.stream(), line.right.stream()).filter(e -> !Identifiers.CORE_MOD_NAME.equals((Object)e.getTag())).map(IElement::getCachedMessage).filter(Objects::nonNull).map(class_5223::method_31402).toList()));
        }
        return Joiner.on((char)'\n').join((Iterable)msgs);
    }

    public static class Line {
        private final List<IElement> left = new ArrayList<IElement>();
        private final List<IElement> right = new ArrayList<IElement>();
        private class_241 size;

        public List<IElement> getAlignedElements(IElement.Align align) {
            return align == IElement.Align.LEFT ? this.left : this.right;
        }

        public class_241 getSize() {
            if (this.size == null) {
                class_241 elementSize;
                float width = 0.0f;
                float height = 0.0f;
                for (IElement element : this.left) {
                    elementSize = element.getCachedSize();
                    width += elementSize.field_1343;
                    height = Math.max(height, elementSize.field_1342);
                }
                for (IElement element : this.right) {
                    elementSize = element.getCachedSize();
                    width += elementSize.field_1343;
                    height = Math.max(height, elementSize.field_1342);
                }
                this.size = new class_241(width, height);
            }
            return this.size;
        }

        public void render(class_4587 matrixStack, float x, float y, float maxWidth, float y2) {
            class_241 size;
            class_241 translate;
            float ox = maxWidth;
            float oy = y;
            for (int i = this.right.size() - 1; i >= 0; --i) {
                IElement element = this.right.get(i);
                translate = element.getTranslation();
                size = element.getCachedSize();
                Tooltip.drawBorder(matrixStack, ox -= size.field_1343, oy, element);
                element.render(matrixStack, ox + translate.field_1343, oy + translate.field_1342, x + maxWidth, y + y2);
            }
            maxWidth = ox;
            ox = x;
            for (IElement element : this.left) {
                translate = element.getTranslation();
                size = element.getCachedSize();
                Tooltip.drawBorder(matrixStack, ox, oy, element);
                element.render(matrixStack, ox + translate.field_1343, oy + translate.field_1342, maxWidth, y + y2);
                ox += size.field_1343;
            }
        }
    }
}

