/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.IconUI;
import snownee.jade.overlay.OverlayRenderer;

public class ArmorElement
extends Element {
    private final float armor;

    public ArmorElement(float armor) {
        this.armor = armor;
    }

    @Override
    public class_241 getSize() {
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (this.armor > (float)config.getMaxHealthForRender()) {
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            class_327 font = class_310.method_1551().field_1772;
            return new class_241((float)(8 + font.method_1727(text)), 10.0f);
        }
        int maxHearts = config.getMaxHeartsPerLine();
        int lineCount = (int)Math.ceil(this.armor / (float)maxHearts * 0.5f);
        return new class_241((float)(8 * maxHearts), (float)(10 * lineCount));
    }

    @Override
    public void render(class_4587 matrixStack, float x, float y, float maxX, float maxY) {
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (this.armor > (float)config.getMaxHealthForRender()) {
            DisplayHelper.renderIcon(matrixStack, x, y, 8, 8, IconUI.ARMOR);
            String text = "  " + DisplayHelper.dfCommas.format(this.armor);
            DisplayHelper.INSTANCE.drawText(matrixStack, text, x + 8.0f, y, OverlayRenderer.normalTextColorRaw);
        } else {
            float armor = this.armor * 0.5f;
            int maxHearts = config.getMaxHeartsPerLine();
            int lineCount = (int)Math.ceil(armor / (float)maxHearts);
            int armorCount = lineCount * maxHearts;
            int xOffset = 0;
            for (int i = 1; i <= armorCount; ++i) {
                if (i <= class_3532.method_15375((float)armor)) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.ARMOR);
                    xOffset += 8;
                }
                if ((float)i > armor && (float)i < armor + 1.0f) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HALF_ARMOR);
                    xOffset += 8;
                }
                if ((float)i >= armor + 1.0f) {
                    DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_ARMOR);
                    xOffset += 8;
                }
                if (i % maxHearts != 0) continue;
                y += 10.0f;
                xOffset = 0;
            }
        }
    }

    @Override
    @Nullable
    public class_2561 getMessage() {
        return new class_2588("narration.jade.armor", new Object[]{DisplayHelper.dfCommas.format(this.armor)});
    }
}

