/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.ui.Element;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.IconUI;
import snownee.jade.overlay.OverlayRenderer;

public class HealthElement
extends Element {
    private final float maxHealth;
    private final float health;
    private String text;

    public HealthElement(float maxHealth, float health) {
        this.maxHealth = maxHealth;
        this.health = health;
        this.text = String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
    }

    @Override
    public class_241 getSize() {
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (this.maxHealth > (float)config.getMaxHealthForRender()) {
            class_327 font = class_310.method_1551().field_1772;
            return new class_241((float)(8 + font.method_1727(this.text)), 10.0f);
        }
        float maxHearts = config.getMaxHeartsPerLine();
        float maxHealth = this.maxHealth * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(maxHealth));
        int lineCount = (int)Math.ceil(maxHealth / maxHearts);
        return new class_241((float)(8 * heartsPerLine), (float)(10 * lineCount));
    }

    @Override
    public void render(class_4587 matrixStack, float x, float y, float maxX, float maxY) {
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        float maxHearts = config.getMaxHeartsPerLine();
        int heartCount = this.maxHealth > (float)config.getMaxHealthForRender() ? 1 : class_3532.method_15386((float)(this.maxHealth * 0.5f));
        float health = this.maxHealth > (float)config.getMaxHealthForRender() ? 1.0f : this.health * 0.5f;
        int heartsPerLine = (int)Math.min((double)maxHearts, Math.ceil(this.maxHealth));
        int xOffset = 0;
        for (int i = 1; i <= heartCount; ++i) {
            if (i <= class_3532.method_15375((float)health)) {
                DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HEART);
                xOffset += 8;
            }
            if ((float)i > health && (float)i < health + 1.0f) {
                DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.HALF_HEART);
                xOffset += 8;
            }
            if ((float)i >= health + 1.0f) {
                DisplayHelper.renderIcon(matrixStack, x + (float)xOffset, y, 8, 8, IconUI.EMPTY_HEART);
                xOffset += 8;
            }
            if (i % heartsPerLine != 0) continue;
            y += 10.0f;
            xOffset = 0;
        }
        if (this.maxHealth > (float)config.getMaxHealthForRender()) {
            DisplayHelper.INSTANCE.drawText(matrixStack, this.text, x + 8.0f, y, OverlayRenderer.normalTextColorRaw);
        }
    }

    @Override
    @Nullable
    public class_2561 getMessage() {
        return new class_2588("narration.jade.health", new Object[]{DisplayHelper.dfCommas.format(this.health)});
    }
}

