/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.ui.IBorderStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.impl.ui.BorderStyle;
import snownee.jade.overlay.IconUI;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final class_1160 DIFFUSE_LIGHT_0 = new class_1160(-0.5f, -0.1f, -0.1f);
    private static final class_1160 DIFFUSE_LIGHT_1 = new class_1160(0.0f, -1.0f, 0.0f);
    private static final class_310 CLIENT = class_310.method_1551();
    private static float blitOffset;
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    public static DecimalFormat dfCommas;

    @Override
    public void drawItem(class_4587 matrixStack, float x, float y, class_1799 stack, float scale, @Nullable String text) {
        matrixStack.method_22903();
        RenderSystem.enableDepthTest();
        DisplayHelper.tryRenderGuiItem(matrixStack, stack, x, y, scale);
        DisplayHelper.renderGuiItemDecorations(matrixStack, DisplayHelper.CLIENT.field_1772, stack, x, y, text);
        RenderSystem.disableDepthTest();
        matrixStack.method_22909();
    }

    private static void renderGuiItemDecorations(class_4587 posestack, class_327 font, class_1799 stack, float p_115177_, float p_115178_, @Nullable String p_115179_) {
        class_746 localplayer;
        float f;
        if (stack.method_7960()) {
            return;
        }
        class_918 renderer = CLIENT.method_1480();
        if (stack.method_7947() != 1 || p_115179_ != null) {
            String s = p_115179_ == null ? String.valueOf(stack.method_7947()) : p_115179_;
            posestack.method_22904(0.0, 0.0, (double)(renderer.field_4730 + 200.0f));
            class_4597.class_4598 multibuffersource$buffersource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            font.method_27521(s, p_115177_ + 19.0f - 2.0f - (float)font.method_1727(s), p_115178_ + 6.0f + 3.0f, 0xFFFFFF, true, posestack.method_23760().method_23761(), (class_4597)multibuffersource$buffersource, false, 0, 0xF000F0);
            multibuffersource$buffersource.method_22993();
        }
        if (stack.method_31578()) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.disableBlend();
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            double health = stack.method_31579();
            int i = Math.round(13.0f - (float)health * 13.0f);
            int j = stack.method_31580();
            DisplayHelper.draw(posestack, bufferbuilder, p_115177_ + 2.0f, p_115178_ + 13.0f, 13, 2, 0, 0, 0, 255);
            DisplayHelper.draw(posestack, bufferbuilder, p_115177_ + 2.0f, p_115178_ + 13.0f, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            RenderSystem.enableBlend();
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
        float f2 = f = (localplayer = class_310.method_1551().field_1724) == null ? 0.0f : localplayer.method_7357().method_7905(stack.method_7909(), class_310.method_1551().method_1488());
        if (f > 0.0f) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_289 tesselator1 = class_289.method_1348();
            class_287 bufferbuilder1 = tesselator1.method_1349();
            DisplayHelper.draw(posestack, bufferbuilder1, p_115177_, p_115178_ + (float)class_3532.method_15375((float)(16.0f * (1.0f - f))), 16, class_3532.method_15386((float)(16.0f * f)), 255, 255, 255, 127);
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
    }

    private static void draw(class_4587 ms, class_287 renderer, float x, float y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.setShader(class_757::method_34540);
        class_1159 matrix = ms.method_23760().method_23761();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22918(matrix, x, y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(matrix, x, y + (float)height, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(matrix, x + (float)width, y + (float)height, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(matrix, x + (float)width, y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_1326();
        class_286.method_1309((class_287)renderer);
    }

    public static void tryRenderGuiItem(class_4587 matrixStack, class_1799 stack, float x, float y, float scale) {
        class_918 renderer = CLIENT.method_1480();
        DisplayHelper.renderGuiItem(matrixStack, stack, x, y, renderer.method_4019(stack, null, null, 0), scale);
    }

    private static void renderGuiItem(class_4587 posestack, class_1799 p_115128_, float p_115129_, float p_115130_, class_1087 p_115131_, float scale) {
        boolean flag;
        class_918 renderer = CLIENT.method_1480();
        class_1060 textureManager = CLIENT.method_1531();
        textureManager.method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        posestack.method_22903();
        RenderSystem.setShaderLights((class_1160)DIFFUSE_LIGHT_0, (class_1160)DIFFUSE_LIGHT_1);
        posestack.method_22904((double)p_115129_, (double)p_115130_, (double)(150.0f + blitOffset));
        posestack.method_22904(8.0 * (double)scale, 8.0 * (double)scale, 0.0);
        posestack.method_22905(scale, -scale, scale);
        posestack.method_22905(16.0f, 16.0f, 16.0f);
        class_4597.class_4598 multibuffersource$buffersource = class_310.method_1551().method_22940().method_23000();
        boolean bl = flag = !p_115131_.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        renderer.method_23179(p_115128_, class_809.class_811.field_4317, false, posestack, (class_4597)multibuffersource$buffersource, 0xF000F0, class_4608.field_21444, p_115131_);
        multibuffersource$buffersource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        posestack.method_22909();
    }

    @Override
    public void drawGradientRect(class_4587 matrixStack, float left, float top, float right, float bottom, int startColor, int endColor) {
        this.drawGradientRect(matrixStack, left, top, right, bottom, startColor, endColor, false);
    }

    public void drawGradientRect(class_4587 matrixStack, float left, float top, float right, float bottom, int startColor, int endColor, boolean vertical) {
        float zLevel = 0.0f;
        class_1159 matrix = matrixStack.method_23760().method_23761();
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        if (vertical) {
            buffer.method_22918(matrix, left + right, top, zLevel).method_22915(f5, f6, f7, f4).method_1344();
            buffer.method_22918(matrix, left, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top + bottom, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left + right, top + bottom, zLevel).method_22915(f5, f6, f7, f4).method_1344();
        } else {
            buffer.method_22918(matrix, left + right, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top, zLevel).method_22915(f1, f2, f3, f).method_1344();
            buffer.method_22918(matrix, left, top + bottom, zLevel).method_22915(f5, f6, f7, f4).method_1344();
            buffer.method_22918(matrix, left + right, top + bottom, zLevel).method_22915(f5, f6, f7, f4).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    @Override
    public void drawBorder(class_4587 matrixStack, float minX, float minY, float maxX, float maxY, IBorderStyle border0) {
        BorderStyle border = (BorderStyle)border0;
        DisplayHelper.fill(matrixStack, minX + (float)border.width, minY, maxX - (float)border.width, minY + (float)border.width, border.color);
        DisplayHelper.fill(matrixStack, minX + (float)border.width, maxY - (float)border.width, maxX - (float)border.width, maxY, border.color);
        DisplayHelper.fill(matrixStack, minX, minY, minX + (float)border.width, maxY, border.color);
        DisplayHelper.fill(matrixStack, maxX - (float)border.width, minY, maxX, maxY, border.color);
    }

    public static void drawTexturedModalRect(class_4587 matrixStack, float x, float y, int textureX, int textureY, int width, int height, int tw, int th) {
        class_1159 matrix = matrixStack.method_23760().method_23761();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(matrix, x, y + (float)height, zLevel).method_22913((float)textureX * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22918(matrix, x + (float)width, y + (float)height, zLevel).method_22913((float)(textureX + tw) * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22918(matrix, x + (float)width, y, zLevel).method_22913((float)(textureX + tw) * f, (float)textureY * f1).method_1344();
        buffer.method_22918(matrix, x, y, zLevel).method_22913((float)textureX * f, (float)textureY * f1).method_1344();
        tessellator.method_1350();
    }

    public static List<class_2561> itemDisplayNameMultiline(class_1799 itemstack) {
        ArrayList<class_2561> namelist = null;
        try {
            namelist = itemstack.method_7950((class_1657)DisplayHelper.CLIENT.field_1724, (class_1836)class_1836.class_1837.field_8934);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<class_2561>();
        }
        if (namelist.isEmpty()) {
            namelist.add((class_2561)new class_2585("Unnamed"));
        }
        namelist.set(0, (class_2561)new class_2585(itemstack.method_7932().field_8908.toString() + namelist.get(0)));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (class_2561)namelist.get(i));
        }
        return namelist;
    }

    public static void renderIcon(class_4587 matrixStack, float x, float y, int sx, int sy, IconUI icon) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        if (icon == null) {
            return;
        }
        if (icon.bu != -1) {
            DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayHelper.drawTexturedModalRect(matrixStack, x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
    }

    public void drawFluid(class_4587 matrixStack, float xPosition, float yPosition, @Nullable class_3610 fluidState, float width, float height, long capacityMb) {
        if (fluidState == null || fluidState.method_15769()) {
            return;
        }
        class_3611 fluid = fluidState.method_15772();
        if (fluid == null) {
            return;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        class_1058 fluidStillSprite = handler.getFluidSprites(null, null, fluidState)[0];
        int fluidColor = handler.getFluidColor(null, null, fluidState);
        long amount = 81000L;
        float scaledAmount = (float)amount * height / (float)capacityMb;
        if (amount > 0L && scaledAmount < 1.0f) {
            scaledAmount = 1.0f;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        this.drawTiledSprite(matrixStack, xPosition, yPosition, width, height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(class_4587 matrixStack, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_1159 matrix = matrixStack.method_23760().method_23761();
        DisplayHelper.setGLColorFromInt(color);
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(class_1159 matrix, float xCoord, float yCoord, class_1058 textureSprite, float maskTop, float maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34542);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        tessellator.method_1350();
    }

    public static void fill(class_4587 matrixStack, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(matrixStack.method_23760().method_23761(), minX, minY, maxX, maxY, color);
    }

    private static void fill(class_1159 matrix, float minX, float minY, float maxX, float maxY, int color) {
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferbuilder.method_22918(matrix, minX, maxY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, maxX, maxY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, maxX, minY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22918(matrix, minX, minY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_1326();
        class_286.method_1309((class_287)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        boolean n;
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        if (number < 1000.0) {
            sb.append(dfCommas.format(number));
            if (milli) {
                sb.append('m');
            }
        } else {
            int exp = (int)(Math.log10(number) / 3.0);
            if (exp > 7) {
                exp = 7;
            }
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(dfCommas.format(number / Math.pow(1000.0, exp)));
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(class_4587 poseStack, String text, float x, float y, int color) {
        boolean shadow = Jade.CONFIG.get().getOverlay().getTheme().textShadow;
        if (shadow) {
            DisplayHelper.CLIENT.field_1772.method_1720(poseStack, text, x, y, color);
        } else {
            DisplayHelper.CLIENT.field_1772.method_1729(poseStack, text, x, y, color);
        }
    }

    @Override
    public void drawText(class_4587 poseStack, class_2561 text, float x, float y, int color) {
        boolean shadow = Jade.CONFIG.get().getOverlay().getTheme().textShadow;
        if (shadow) {
            DisplayHelper.CLIENT.field_1772.method_30881(poseStack, text, x, y, color);
        } else {
            DisplayHelper.CLIENT.field_1772.method_30883(poseStack, text, x, y, color);
        }
    }

    static {
        dfCommas = new DecimalFormat("##.##");
        dfCommas.setRoundingMode(RoundingMode.DOWN);
    }
}

