/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeRenderBackgroundCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.config.Theme;
import snownee.jade.api.ui.IElement;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.Color;

public class OverlayRenderer {
    public static float ticks;
    public static int backgroundColorRaw;
    public static int gradientStartRaw;
    public static int gradientEndRaw;
    public static int stressedTextColorRaw;
    public static int normalTextColorRaw;
    public static boolean shown;

    public static void renderOverlay(class_4587 poseStack) {
        shown = false;
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return;
        }
        if (!Jade.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (Jade.CONFIG.get().getGeneral().getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.method_1434()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        if (mc.field_1755 != null) {
            if (!(mc.field_1755 instanceof BaseOptionsScreen)) {
                return;
            }
            class_768 position = WailaTickHandler.instance().tooltipRenderer.getPosition();
            WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
            class_1041 window = mc.method_22683();
            double x = mc.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
            double y = mc.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507();
            if (position.method_3318((int)(x += (double)((float)position.method_3319() * overlay.tryFlip(overlay.getAnchorX()))), (int)(y += (double)((float)position.method_3320() * overlay.getAnchorY())))) {
                return;
            }
        }
        if (mc.field_1705.method_1750().field_2158 || mc.method_18506() != null || mc.field_1690.field_1842) {
            return;
        }
        if (mc.field_1690.field_1866 && Jade.CONFIG.get().getGeneral().shouldHideFromDebug()) {
            return;
        }
        ticks += mc.method_1534();
        OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltipRenderer, poseStack);
    }

    public static void renderOverlay(TooltipRenderer tooltip, class_4587 matrixStack) {
        class_768 rect;
        IWailaConfig.BossBarOverlapMode mode;
        class_310.method_1551().method_16011().method_15396("Waila Overlay");
        matrixStack.method_22903();
        class_768 position = tooltip.getPosition();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        if (!overlay.getSquare()) {
            position.method_35782(position.method_3319() + 2);
            position.method_35783(position.method_3320() + 2);
            position.method_35779(position.method_3321() + 1, position.method_3322() + 1);
        }
        if ((mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode()) == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (rect = ClientPlatformProxy.getBossBarRect()) != null) {
            int tw = position.method_3319();
            int th = position.method_3320();
            int rw = rect.method_3319();
            int rh = rect.method_3320();
            int tx = position.method_3321();
            int ty = position.method_3322();
            int rx = rect.method_3321();
            int ry = rect.method_3322();
            if ((rw += rx) > tx && (rh += ry) > ty && (tw += tx) > rx && (th += ty) > ry) {
                position.method_35781(rect.method_3320());
            }
        }
        JadeBeforeRenderCallback.ColorSetting colorSetting = new JadeBeforeRenderCallback.ColorSetting();
        colorSetting.alpha = overlay.getAlpha();
        colorSetting.backgroundColor = backgroundColorRaw;
        colorSetting.gradientStart = gradientStartRaw;
        colorSetting.gradientEnd = gradientEndRaw;
        for (JadeBeforeRenderCallback callback : WailaClientRegistration.INSTANCE.beforeRenderCallbacks) {
            if (!callback.beforeRender(tooltip.getTooltip(), position, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            matrixStack.method_22909();
            return;
        }
        matrixStack.method_22904((double)position.method_3321(), (double)position.method_3322(), 1.0);
        float scale = overlay.getOverlayScale();
        class_1041 window = class_310.method_1551().method_22683();
        float thresholdHeight = (float)window.method_4502() * overlay.getAutoScaleThreshold();
        if ((float)position.method_3320() * scale > thresholdHeight) {
            scale = Math.max(scale * 0.5f, thresholdHeight / (float)position.method_3320());
        }
        if (scale != 1.0f) {
            matrixStack.method_22905(scale, scale, 1.0f);
        }
        matrixStack.method_22904((double)((float)(-position.method_3319()) * overlay.tryFlip(overlay.getAnchorX())), (double)((float)(-position.method_3320()) * overlay.getAnchorY()), 0.0);
        boolean doDefault = true;
        for (JadeRenderBackgroundCallback callback : WailaClientRegistration.INSTANCE.renderBackgroundCallbacks) {
            if (!callback.onRender(tooltip, position, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            doDefault = false;
            break;
        }
        if (doDefault && colorSetting.alpha > 0.0f) {
            OverlayRenderer.drawTooltipBox(matrixStack, 0, 0, position.method_3319(), position.method_3320(), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.backgroundColor, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientStart, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientEnd, colorSetting.alpha), overlay.getSquare());
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(matrixStack);
        RenderSystem.disableBlend();
        IElement icon = tooltip.getIcon();
        if (icon != null) {
            class_241 size = tooltip.getIcon().getCachedSize();
            class_241 offset = tooltip.getIcon().getTranslation();
            float offsetY = overlay.getIconMode() == IWailaConfig.IconMode.TOP ? offset.field_1342 + tooltip.getPadding() : ((float)position.method_3320() - size.field_1342) / 2.0f - 1.0f;
            float offsetX = offset.field_1343 + tooltip.getPadding() + 2.0f;
            Tooltip.drawBorder(matrixStack, offsetX, offsetY, icon);
            icon.render(matrixStack, offsetX, offsetY, offsetX + size.field_1343, offsetY + size.field_1342);
        }
        for (JadeAfterRenderCallback callback : WailaClientRegistration.INSTANCE.afterRenderCallbacks) {
            callback.afterRender(tooltip.getTooltip(), position, matrixStack, ObjectDataCenter.get());
        }
        RenderSystem.enableDepthTest();
        matrixStack.method_22909();
        class_310.method_1551().method_16011().method_15407();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech() && class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_8510() % 5L == 0L) {
            WailaTickHandler.narrate(tooltip.getTooltip(), true);
        }
        shown = true;
    }

    public static void drawTooltipBox(class_4587 matrixStack, int x, int y, int w, int h, int bg, int grad1, int grad2, boolean square) {
        if (!square) {
            w -= 2;
            h -= 2;
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + 1, y + 1, w - 2, h - 2, bg, bg);
        if (!square) {
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y - 1, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x - 1, y, 1.0f, h, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w, y, 1.0f, h, bg, bg);
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w - 1, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y, w, 1.0f, grad1, grad1);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h - 1, w, 1.0f, grad2, grad2);
    }

    public static void updateTheme() {
        Theme theme = Jade.CONFIG.get().getOverlay().getTheme();
        backgroundColorRaw = Color.fromString(theme.backgroundColor).toInt();
        gradientEndRaw = Color.fromString(theme.gradientEnd).toInt();
        gradientStartRaw = Color.fromString(theme.gradientStart).toInt();
        normalTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.fromString(theme.normalTextColor).toInt(), 1.0f);
        stressedTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.fromString(theme.stressedTextColor).toInt(), 1.0f);
    }
}

