/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3610;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4013;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_768;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.Identifiers;
import snownee.jade.api.ui.IElement;
import snownee.jade.command.DumpHandlersCommand;
import snownee.jade.compat.REICompat;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.FluidStackElement;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.WailaTickHandler;

public final class ClientPlatformProxy {
    public static void initModNames(Map<String, String> map) {
        ImmutableList mods = ImmutableList.copyOf((Collection)FabricLoader.getInstance().getAllMods());
        for (ModContainer mod : mods) {
            String modid = mod.getMetadata().getId();
            String name = mod.getMetadata().getName();
            if (Strings.isNullOrEmpty((String)name)) {
                StringUtils.capitalize((String)modid);
            }
            map.put(modid, name);
        }
    }

    public static void init() {
        ClientEntityEvents.ENTITY_LOAD.register(ClientPlatformProxy::onEntityJoin);
        ClientEntityEvents.ENTITY_UNLOAD.register(ClientPlatformProxy::onEntityLeave);
        class_2960 lowest = new class_2960("jade", "mod_name");
        ItemTooltipCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, lowest);
        ItemTooltipCallback.EVENT.register(lowest, ClientPlatformProxy::onTooltip);
        ClientTickEvents.END_CLIENT_TICK.register(ClientPlatformProxy::onClientTick);
        HudRenderCallback.EVENT.register(ClientPlatformProxy::onRenderTick);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientPlatformProxy::onPlayerLeave);
        ClientTickEvents.END_CLIENT_TICK.register(ClientPlatformProxy::onKeyPressed);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenEvents.afterRender((class_437)screen).register(ClientPlatformProxy::onGui));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Identifiers.PACKET_RECEIVE_DATA, (client, handler, buf, responseSender) -> {
            class_2487 nbt = buf.method_10798();
            client.execute(() -> ObjectDataCenter.setServerData(nbt));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Identifiers.PACKET_SERVER_PING, (client, handler, buf, responseSender) -> {
            int size = buf.method_10816();
            HashMap forcedKeys = Maps.newHashMap();
            for (int i = 0; i < size; ++i) {
                class_2960 id = new class_2960(buf.method_10800(128));
                boolean value = buf.readBoolean();
                forcedKeys.put(id, value);
            }
            client.execute(() -> {
                ObjectDataCenter.serverConnected = true;
                forcedKeys.forEach(PluginConfig.INSTANCE::set);
                Jade.LOGGER.info("Received config from the server: {}", (Object)new Gson().toJson((Object)forcedKeys));
            });
        });
        DumpHandlersCommand.register((CommandDispatcher<FabricClientCommandSource>)ClientCommandManager.DISPATCHER);
    }

    private static void onEntityJoin(class_1297 entity, class_638 level) {
        DatapackBlockManager.onEntityJoin(entity);
    }

    private static void onEntityLeave(class_1297 entity, class_638 level) {
        DatapackBlockManager.onEntityLeave(entity);
    }

    private static void onTooltip(class_1799 stack, class_1836 context, List<class_2561> lines) {
        JadeClient.onTooltip(lines, stack);
    }

    private static void onRenderTick(class_4587 matrixStack, float tickDelta) {
        if (class_310.method_1551().field_1755 == null) {
            OverlayRenderer.renderOverlay(matrixStack);
        }
    }

    private static void onClientTick(class_310 mc) {
        WailaTickHandler.instance().tickClient();
    }

    private static void onPlayerLeave(class_634 handler, class_310 client) {
        ObjectDataCenter.serverConnected = false;
    }

    private static void onKeyPressed(class_310 mc) {
        JadeClient.onKeyPressed(1);
        if (JadeClient.showUses != null) {
            REICompat.onKeyPressed(1);
        }
    }

    private static void onGui(class_437 screen, class_4587 matrices, int mouseX, int mouseY, float tickDelta) {
        JadeClient.onGui(screen);
    }

    public static class_304 registerKeyBinding(String desc, int defaultKey) {
        class_304 key = new class_304("key.jade." + desc, class_3675.class_307.field_1668, defaultKey, "Jade");
        KeyBindingHelper.registerKeyBinding((class_304)key);
        return key;
    }

    public static boolean shouldRegisterRecipeViewerKeys() {
        return FabricLoader.getInstance().isModLoaded("roughlyenoughitems");
    }

    public static void requestBlockData(class_2586 blockEntity, boolean showDetails) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockEntity.method_11016());
        buf.writeBoolean(showDetails);
        ClientPlayNetworking.send((class_2960)Identifiers.PACKET_REQUEST_TILE, (class_2540)buf);
    }

    public static void requestEntityData(class_1297 entity, boolean showDetails) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(entity.method_5628());
        buf.writeBoolean(showDetails);
        ClientPlayNetworking.send((class_2960)Identifiers.PACKET_REQUEST_ENTITY, (class_2540)buf);
    }

    public static class_1799 getEntityPickedResult(class_1297 entity, class_1657 player, class_3966 hitResult) {
        if (entity instanceof EntityPickInteractionAware) {
            return ((EntityPickInteractionAware)entity).getPickedStack(player, (class_239)hitResult);
        }
        class_1799 stack = entity.method_31480();
        return stack == null ? class_1799.field_8037 : stack;
    }

    public static class_1799 getBlockPickedResult(class_2680 state, class_1657 player, class_3965 hitResult) {
        class_2248 block = state.method_26204();
        if (block instanceof BlockPickInteractionAware) {
            return ((BlockPickInteractionAware)block).getPickedStack(state, (class_1922)player.field_6002, hitResult.method_17777(), player, (class_239)hitResult);
        }
        return block.method_9574((class_1922)player.field_6002, hitResult.method_17777(), state);
    }

    public static IElement elementFromLiquid(class_2404 block) {
        class_3610 fluidState = block.method_9545(block.method_9564());
        return new FluidStackElement(fluidState);
    }

    public static void registerReloadListener(class_4013 listener) {
        class_310.method_1551().execute(() -> {
            class_3304 manager = (class_3304)class_310.method_1551().method_1478();
            manager.method_14477((class_3302)listener);
            listener.method_14491((class_3300)manager);
        });
    }

    @Nullable
    public static class_768 getBossBarRect() {
        class_310 mc = class_310.method_1551();
        int size = mc.field_1705.method_1740().field_2060.size();
        if (size == 0) {
            return null;
        }
        int i = mc.method_22683().method_4486();
        int k = i / 2 - 91;
        Objects.requireNonNull(mc.field_1772);
        return new class_768(k, 12, 182, (10 + 9) * size);
    }
}

