/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Multimap;
import snownee.jade.api.IJadeProvider;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;

public class DumpGenerator {
    public static String generateInfoDump() {
        StringBuilder builder = new StringBuilder("# Jade Handler Dump");
        builder.append("\n## Block");
        DumpGenerator.createSection(builder, "Icon Providers", WailaClientRegistration.INSTANCE.blockIconProviders);
        DumpGenerator.createSection(builder, "Component Providers", WailaClientRegistration.INSTANCE.blockComponentProviders);
        DumpGenerator.createSection(builder, "Data Providers", WailaCommonRegistration.INSTANCE.blockDataProviders);
        builder.append("\n## Entity");
        DumpGenerator.createSection(builder, "Icon Providers", WailaClientRegistration.INSTANCE.entityIconProviders);
        DumpGenerator.createSection(builder, "Component Providers", WailaClientRegistration.INSTANCE.entityComponentProviders);
        DumpGenerator.createSection(builder, "Data Providers", WailaCommonRegistration.INSTANCE.entityDataProviders);
        return builder.toString();
    }

    private static void createSection(StringBuilder builder, String subsection, HierarchyLookup<? extends IJadeProvider> lookup) {
        Multimap<Class<?>, ? extends IJadeProvider> multimap = lookup.getObjects();
        if (multimap.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        multimap.asMap().forEach((k, v) -> {
            builder.append("\n\n#### ").append(k.getName());
            v.stream().distinct().sorted((o1, o2) -> WailaCommonRegistration.INSTANCE.priorities.get((IJadeProvider)o1) - WailaCommonRegistration.INSTANCE.priorities.get((IJadeProvider)o2)).forEach($ -> builder.append("\n* ").append($.getUid()).append(", ").append(WailaCommonRegistration.INSTANCE.priorities.get((IJadeProvider)$)).append(", ").append($.getClass().getName()));
        });
        builder.append("\n\n");
    }
}

