/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;

public class ProcessingRecipeJSNoLiquid
extends RecipeJS {
    public final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
    public final List<FluidStackJS> outputFluids = new ArrayList<FluidStackJS>();

    public void create(ListJS args) {
        for (Object result : ListJS.orSelf((Object)args.get(0))) {
            this.outputItems.add(this.parseResultItem(result));
        }
        for (Object input : ListJS.orSelf((Object)args.get(1))) {
            this.inputItems.add(this.parseIngredientItem(input));
        }
        this.json.addProperty("processingTime", (Number)100);
    }

    public void deserialize() {
        for (JsonElement ingredient : this.json.get("ingredients").getAsJsonArray()) {
            this.inputItems.add(this.parseIngredientItem(ingredient));
        }
        for (JsonElement result : this.json.get("results").getAsJsonArray()) {
            JsonObject resultJson = result.getAsJsonObject();
            this.outputItems.add(this.parseResultItem(result));
        }
    }

    public ProcessingRecipeJSNoLiquid processingTime(int t) {
        this.json.addProperty("processingTime", (Number)t);
        this.save();
        return this;
    }

    public ProcessingRecipeJSNoLiquid waterlogged() {
        this.json.addProperty("waterlogged", Boolean.valueOf(true));
        this.save();
        return this;
    }

    public void serialize() {
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        for (IngredientJS ingredientJS : this.inputItems) {
            for (IngredientJS ingredient : ingredientJS.unwrapStackIngredient()) {
                jsonIngredients.add(ingredient.toJson());
            }
        }
        for (FluidIngredient fluidIngredient : this.inputFluids) {
            jsonIngredients.add((JsonElement)fluidIngredient.serialize());
        }
        for (ItemStackJS itemStackJS : this.outputItems) {
            jsonOutputs.add(itemStackJS.toResultJson());
        }
        for (FluidStackJS fluidStackJS : this.outputFluids) {
            jsonOutputs.add((JsonElement)fluidStackJS.toJson());
        }
        this.json.add("ingredients", (JsonElement)jsonIngredients);
        this.json.add("results", (JsonElement)jsonOutputs);
    }
}

