/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.content.contraptions.components.sifter.FabricRecipeWrapper;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SifterTileEntity
extends KineticTileEntity
implements ItemTransferable {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public SifterInventoryHandler handler = new SifterInventoryHandler();
    public int timer;
    private SiftingRecipe lastRecipe;
    public ItemStackHandler meshInv = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @NotNull ItemVariant stack) {
            return SiftingRecipe.isMeshItemStack(stack.toStack());
        }
    };
    protected CombinedStorage<ItemVariant, ItemStackHandler> inputAndMeshCombined = new CombinedStorage(List.of(this.inputInv, this.meshInv));
    protected int totalTime;

    public SifterTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inputInv.getStackInSlot(0).method_7960()) {
            return;
        }
        float pitch = class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.MILLING, (class_2338)this.field_11867, (float)pitch);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).method_7947() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.field_11863.field_9236) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).method_7960()) {
            return;
        }
        FabricRecipeWrapper inventoryIn = new FabricRecipeWrapper(this.inputAndMeshCombined);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_11863, this.isWaterlogged())) {
            Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((class_1263)inventoryIn, this.field_11863, this.isWaterlogged());
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = recipe.get();
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        this.sendData();
    }

    private void process() {
        FabricRecipeWrapper inventoryIn = new FabricRecipeWrapper(this.inputAndMeshCombined);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_11863, this.isWaterlogged())) {
            Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((class_1263)inventoryIn, this.field_11863, this.isWaterlogged());
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = recipe.get();
        }
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.method_7934(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.lastRecipe.rollResults().forEach(stack -> {
            try (Transaction t = TransferUtil.getTransaction();){
                long inserted = this.outputInv.insert(ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
                t.commit();
                long remainder = (long)stack.method_7947() - inserted;
                if (remainder == 0L) {
                    return;
                }
                stack = stack.method_7972();
                stack.method_7939((int)remainder);
            }
        });
        this.sendData();
        this.method_5431();
    }

    public void spawnParticles() {
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.method_7960()) {
            return;
        }
        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        float angle = this.field_11863.field_9229.nextFloat() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((class_243)offset, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate((class_243)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly((class_243)target.method_1020(offset), (Random)this.field_11863.field_9229, (float)0.0078125f);
        this.field_11863.method_8406((class_2394)data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Timer", this.timer);
        compound.method_10566("InputInventory", (class_2520)this.inputInv.serializeNBT());
        compound.method_10566("OutputInventory", (class_2520)this.outputInv.serializeNBT());
        compound.method_10566("MeshInventory", (class_2520)this.meshInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.timer = compound.method_10550("Timer");
        this.inputInv.deserializeNBT(compound.method_10562("InputInventory"));
        this.outputInv.deserializeNBT(compound.method_10562("OutputInventory"));
        this.meshInv.deserializeNBT(compound.method_10562("MeshInventory"));
        super.read(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public float getProcessingRemainingPercent() {
        return (float)((double)this.timer * 100.0 / (double)this.totalTime);
    }

    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.handler;
    }

    private boolean canProcess(class_1799 stack) {
        ItemStackHandler tester = new ItemStackHandler(2);
        tester.setStackInSlot(0, stack);
        tester.setStackInSlot(1, this.meshInv.getStackInSlot(0));
        RecipeWrapper inventoryIn = new RecipeWrapper(tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.field_11863, this.isWaterlogged())) {
            return true;
        }
        return ModRecipeTypes.SIFTING.find((class_1263)inventoryIn, this.field_11863, this.isWaterlogged()).isPresent();
    }

    public void insertMesh(class_1799 meshStack, class_1657 player) {
        if (this.meshInv.getStackInSlot(0).method_7960()) {
            class_1799 meshToInsert = meshStack.method_7972();
            meshToInsert.method_7939(1);
            meshStack.method_7934(1);
            this.meshInv.setStackInSlot(0, meshToInsert);
            this.method_5431();
        }
    }

    public boolean hasMesh() {
        return !this.meshInv.getStackInSlot(0).method_7960();
    }

    public void removeMesh(class_1657 player) {
        player.method_31548().method_7398(this.meshInv.getStackInSlot(0));
        this.meshInv.setStackInSlot(0, class_1799.field_8037);
    }

    public boolean isWaterlogged() {
        return (Boolean)this.method_11010().method_11654((class_2769)class_2741.field_12508);
    }

    public class_1799 getInputItemStack() {
        return this.inputInv.getStackInSlot(0);
    }

    private class SifterInventoryHandler
    extends CombinedStorage<ItemVariant, ItemStackHandler> {
        public SifterInventoryHandler() {
            super(List.of(SifterTileEntity.this.inputInv, SifterTileEntity.this.outputInv));
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!SifterTileEntity.this.canProcess(resource.toStack((int)maxAmount))) {
                return 0L;
            }
            return SifterTileEntity.this.inputInv.insert(resource, maxAmount, transaction);
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return SifterTileEntity.this.outputInv.extract(resource, maxAmount, transaction);
        }
    }
}

