/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.google.gson.JsonObject;
import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.content.contraptions.components.meshes.BaseMesh;
import com.simibubi.create.content.contraptions.components.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

@ParametersAreNonnullByDefault
public class SiftingRecipe
extends AbstractCrushingRecipe {
    class_1799 meshStack = this.getMeshItemStack();
    class_1799 siftableIngredienStack = this.getSiftableItemStack();
    private boolean waterlogged = false;

    public SiftingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)ModRecipeTypes.SIFTING, params);
    }

    public boolean matches(RecipeWrapper inv, class_1937 worldIn, boolean waterlogged) {
        if (inv.method_5442()) {
            return false;
        }
        if (this.isWaterlogged() != waterlogged) {
            return false;
        }
        return this.getSiftableIngredient().method_8093(inv.method_5438(0)) && this.getMeshIngredient().method_8093(inv.method_5438(1));
    }

    public class_1799 getMeshItemStack() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            class_1799 itemStack = ((class_1856)this.ingredients.get(i)).method_8105()[0];
            if (!SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public class_1799 getSiftableItemStack() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            class_1799 itemStack = ((class_1856)this.ingredients.get(i)).method_8105()[0];
            if (SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public class_1856 getSiftableIngredient() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            class_1799 itemStack = ((class_1856)this.ingredients.get(i)).method_8105()[0];
            if (SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return (class_1856)this.ingredients.get(i);
        }
        return class_1856.field_9017;
    }

    public class_1856 getMeshIngredient() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            class_1799 itemStack = ((class_1856)this.ingredients.get(i)).method_8105()[0];
            if (!SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return (class_1856)this.ingredients.get(i);
        }
        return class_1856.field_9017;
    }

    public static boolean isMeshItemStack(class_1799 itemStack) {
        return itemStack.method_7909() instanceof BaseMesh;
    }

    public String toString() {
        return "createsifter:sifting";
    }

    protected int getMaxInputCount() {
        return 4;
    }

    protected int getMaxOutputCount() {
        return 16;
    }

    public static boolean canHandSift(class_1937 world, class_1799 stack, class_1799 mesh, boolean waterlogged) {
        return SiftingRecipe.getMatchingInHandRecipes(world, stack, mesh, waterlogged);
    }

    public static List<class_1799> applyHandSift(class_1937 world, class_243 position, class_1799 stack, class_1799 mesh, boolean waterlogged) {
        SifterInv inventoryIn = new SifterInv(stack, mesh);
        Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((class_1263)inventoryIn, world, waterlogged);
        if (recipe.isPresent()) {
            return recipe.get().rollResults();
        }
        return Collections.singletonList(stack);
    }

    public List<class_1799> rollResults(List<ProcessingOutput> rollableResults) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ProcessingOutput output = rollableResults.get(i);
            class_1799 stack = output.rollOutput();
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.waterlogged = class_3518.method_15258((JsonObject)json, (String)"waterlogged", (boolean)false);
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        if (this.waterlogged) {
            json.addProperty("waterlogged", Boolean.valueOf(this.waterlogged));
        }
    }

    public void readAdditional(class_2540 buffer) {
        super.readAdditional(buffer);
        this.waterlogged = buffer.readBoolean();
    }

    public void writeAdditional(class_2540 buffer) {
        super.writeAdditional(buffer);
        buffer.writeBoolean(this.waterlogged);
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public static boolean getMatchingInHandRecipes(class_1937 world, class_1799 stack, class_1799 mesh, boolean waterlogged) {
        return ModRecipeTypes.SIFTING.find((class_1263)new SifterInv(stack, mesh), world, waterlogged).isPresent();
    }

    public boolean matches(RecipeWrapper pContainer, class_1937 pLevel) {
        return this.matches(pContainer, pLevel, false);
    }

    public static class SifterInv
    extends RecipeWrapper {
        public SifterInv(class_1799 stack, class_1799 mesh) {
            super(new ItemStackHandler(2));
            this.handler.setStackInSlot(0, stack);
            this.handler.setStackInSlot(1, mesh);
        }
    }
}

