/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos;

import io.github.foundationgames.jsonem.JsonEM;
import io.github.foundationgames.phonos.Phonos;
import io.github.foundationgames.phonos.block.PhonosBlocks;
import io.github.foundationgames.phonos.block.RadioNoteBlock;
import io.github.foundationgames.phonos.block.SoundPlayReceivable;
import io.github.foundationgames.phonos.client.ClientReceiverStorage;
import io.github.foundationgames.phonos.client.render.block.PlayerPianoBlockEntityRenderer;
import io.github.foundationgames.phonos.client.render.block.RadioRecorderBlockEntityRenderer;
import io.github.foundationgames.phonos.entity.SoundPlayEntityReceivable;
import io.github.foundationgames.phonos.item.PhonosItems;
import io.github.foundationgames.phonos.network.ClientPayloadPackets;
import io.github.foundationgames.phonos.resource.PhonosAssets;
import io.github.foundationgames.phonos.screen.CustomMusicDiscGuiDescription;
import io.github.foundationgames.phonos.screen.CustomMusicDiscScreen;
import io.github.foundationgames.phonos.screen.RadioJukeboxGuiDescription;
import io.github.foundationgames.phonos.screen.RadioJukeboxScreen;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PhonosClient
implements ClientModInitializer {
    public static final class_5601 KEYBOARD_MODEL_LAYER = new class_5601(Phonos.id("keyboard"), "main");
    public static final class_5601 PIANO_ROLL_MODEL_LAYER = new class_5601(Phonos.id("piano_roll"), "main");

    public void onInitializeClient() {
        ClientPayloadPackets.initClient();
        PhonosAssets.init();
        ClientReceiverStorage.init();
        ClientReceiverStorage.registerPlaySoundCallback((sound, blocks, entities, channel, volume, pitch, stoppable) -> {
            if (!stoppable) {
                class_746 player = class_310.method_1551().field_1724;
                class_638 world = class_310.method_1551().field_1687;
                if (player != null && world != null) {
                    class_2338 pos = player.method_24515();
                    if (blocks != null) {
                        for (class_2338 receiver : blocks) {
                            if (!pos.method_19771((class_2382)receiver, 30.0) || !(world.method_8320(receiver).method_26204() instanceof SoundPlayReceivable)) continue;
                            ((SoundPlayReceivable)world.method_8320(receiver).method_26204()).onReceivedSoundClient(world, world.method_8320(receiver), receiver, channel, volume, pitch);
                        }
                    }
                    if (entities != null) {
                        for (class_1297 e : entities) {
                            class_2338 receiver = e.method_24515();
                            if (!pos.method_19771((class_2382)receiver, 30.0) || !(e instanceof SoundPlayEntityReceivable)) continue;
                            ((SoundPlayEntityReceivable)e).onRecievedSoundClient(world, e, channel, volume, pitch);
                        }
                    }
                }
            }
        });
        FabricModelPredicateProviderRegistry.register((class_1792)PhonosItems.CHANNEL_TUNER, (class_2960)new class_2960("tuned_channel"), (stack, world, entity, seed) -> (float)stack.method_7911("TunerData").method_10550("Channel") / 19.0f);
        FabricModelPredicateProviderRegistry.register((class_1792)PhonosItems.NOTE_BLOCK_TUNER, (class_2960)new class_2960("tuner_mode"), (stack, world, entity, seed) -> (float)stack.method_7911("TunerData").method_10550("Mode") / 2.0f);
        FabricModelPredicateProviderRegistry.register((class_1792)PhonosItems.BOOMBOX, (class_2960)new class_2960("radio_channel"), (stack, world, entity, seed) -> (float)stack.method_7911("RadioData").method_10550("Channel") / 19.0f);
        FabricModelPredicateProviderRegistry.register((class_1792)PhonosItems.FESTIVE_BOOMBOX, (class_2960)new class_2960("radio_channel"), (stack, world, entity, seed) -> (float)stack.method_7911("RadioData").method_10550("Channel") / 19.0f);
        JsonEM.registerModelLayer((class_5601)KEYBOARD_MODEL_LAYER);
        JsonEM.registerModelLayer((class_5601)PIANO_ROLL_MODEL_LAYER);
        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> world != null && pos != null && state != null ? RadioNoteBlock.getColorFromNote((Integer)state.method_11654((class_2769)RadioNoteBlock.NOTE)) : 0xFFFFFF, (Object[])new class_2248[]{PhonosBlocks.RADIO_NOTE_BLOCK});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            int note = stack.method_7911("TunerData").method_10550("Note");
            return tintIndex > 0 ? -1 : RadioNoteBlock.getColorFromNote(note);
        }, (Object[])new class_1935[]{PhonosItems.NOTE_BLOCK_TUNER});
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            int color = 0;
            String seed = stack.method_7911("MusicData").method_10558("SoundId");
            if (seed != null) {
                color = new Random(PhonosClient.seed(seed)).nextInt(0xFFFFFF);
            }
            return tintIndex > 0 ? -1 : color;
        }, (Object[])new class_1935[]{PhonosItems.CUSTOM_MUSIC_DISC});
        BlockRenderLayerMap.INSTANCE.putBlock(PhonosBlocks.RADIO_NOTE_BLOCK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(PhonosBlocks.BOOMBOX, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(PhonosBlocks.FESTIVE_BOOMBOX, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(PhonosBlocks.RADIO_RECORDER, class_1921.method_23583());
        BlockEntityRendererRegistry.register(PhonosBlocks.PLAYER_PIANO_ENTITY, PlayerPianoBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(PhonosBlocks.RADIO_PLAYER_PIANO_ENTITY, PlayerPianoBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(PhonosBlocks.RADIO_RECORDER_ENTITY, RadioRecorderBlockEntityRenderer::new);
        ScreenRegistry.register(Phonos.RADIO_JUKEBOX_HANDLER, (gui, inventory, title) -> new RadioJukeboxScreen((RadioJukeboxGuiDescription)gui, inventory.field_7546));
        ScreenRegistry.register(Phonos.CUSTOM_DISC_HANDLER, (gui, inventory, title) -> new CustomMusicDiscScreen((CustomMusicDiscGuiDescription)gui, inventory.field_7546));
    }

    private static long seed(String s) {
        if (s == null) {
            return 0L;
        }
        long l = 0L;
        for (char c : s.toCharArray()) {
            l = 31L * l + (long)c;
        }
        return l;
    }
}

