/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.phonos.client;

import io.github.foundationgames.phonos.sound.MultiPositionedSoundInstance;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class ClientReceiverStorage {
    private static final Int2ObjectMap<LinkedHashSet<class_2338>> blockStorage = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<LinkedHashSet<class_1297>> entityStorage = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<Map<class_2338, class_1113>> stoppableSoundStorage = new Int2ObjectOpenHashMap();
    private static final List<SoundConsumer> playSoundCallbacks = new ArrayList<SoundConsumer>();

    public static void addReceiver(int channel, class_2338 pos) {
        blockStorage.putIfAbsent(channel, new LinkedHashSet());
        ((LinkedHashSet)blockStorage.get(channel)).add(pos);
    }

    public static void removeReceiver(int channel, class_2338 pos) {
        blockStorage.putIfAbsent(channel, new LinkedHashSet());
        ((LinkedHashSet)blockStorage.get(channel)).remove(pos);
    }

    public static void addEntityReceiver(int channel, class_1297 ent) {
        if (ent == null) {
            return;
        }
        entityStorage.putIfAbsent(channel, new LinkedHashSet());
        ((LinkedHashSet)entityStorage.get(channel)).add(ent);
    }

    public static void removeEntityReceiver(int channel, class_1297 ent) {
        if (ent == null) {
            return;
        }
        entityStorage.putIfAbsent(channel, new LinkedHashSet());
        ((LinkedHashSet)entityStorage.get(channel)).remove(ent);
    }

    public static void clear() {
        blockStorage.clear();
        entityStorage.clear();
    }

    public static void garbageCollectEntities() {
        HashSet<class_1297> removed = new HashSet<class_1297>();
        IntIterator intIterator = entityStorage.keySet().iterator();
        while (intIterator.hasNext()) {
            int channel = (Integer)intIterator.next();
            removed.clear();
            for (class_1297 entity : (LinkedHashSet)entityStorage.get(channel)) {
                if (entity == null || !entity.method_31481()) continue;
                removed.add(entity);
            }
            for (class_1297 entity : removed) {
                ((LinkedHashSet)entityStorage.get(channel)).remove(entity);
            }
        }
    }

    public static void tick(class_638 world) {
        ClientReceiverStorage.garbageCollectEntities();
    }

    public static void playSound(class_3414 sound, int channel, float volume, float pitch) {
        ClientReceiverStorage.playSound(sound.method_14833(), channel, volume, pitch);
    }

    public static void playSound(class_2960 sound, int channel, float volume, float pitch) {
        blockStorage.putIfAbsent(channel, new LinkedHashSet());
        entityStorage.putIfAbsent(channel, new LinkedHashSet());
        class_310.method_1551().method_1483().method_4873((class_1113)new MultiPositionedSoundInstance((Set<class_2338>)((Set)blockStorage.get(channel)), (Set<class_1297>)((Set)entityStorage.get(channel)), sound, volume, pitch));
        for (SoundConsumer c : playSoundCallbacks) {
            c.apply(sound, (Set)blockStorage.get(channel), (Set)entityStorage.get(channel), channel, volume, pitch, false);
        }
    }

    public static void playStoppableSound(class_2338 pos, class_3414 sound, int channel, float volume, float pitch) {
        ClientReceiverStorage.playStoppableSound(pos, sound.method_14833(), channel, volume, pitch);
    }

    public static void playStoppableSound(class_2338 pos, class_2960 sound, int channel, float volume, float pitch) {
        blockStorage.putIfAbsent(channel, new LinkedHashSet());
        entityStorage.putIfAbsent(channel, new LinkedHashSet());
        class_1144 manager = class_310.method_1551().method_1483();
        ClientReceiverStorage.tryStopSound(pos, channel);
        MultiPositionedSoundInstance instance = new MultiPositionedSoundInstance((Set<class_2338>)((Set)blockStorage.get(channel)), (Set<class_1297>)((Set)entityStorage.get(channel)), sound, volume, pitch);
        manager.method_4873((class_1113)instance);
        if (!stoppableSoundStorage.containsKey(channel)) {
            stoppableSoundStorage.put(channel, new HashMap());
        }
        ((Map)stoppableSoundStorage.get(channel)).put(pos, instance);
        for (SoundConsumer c : playSoundCallbacks) {
            c.apply(sound, (Set)blockStorage.get(channel), (Set)entityStorage.get(channel), channel, volume, pitch, true);
        }
    }

    public static void tryStopSound(class_2338 pos, int channel) {
        class_1144 manager = class_310.method_1551().method_1483();
        if (stoppableSoundStorage.containsKey(channel)) {
            manager.method_4870((class_1113)((Map)stoppableSoundStorage.get(channel)).get(pos));
            ((Map)stoppableSoundStorage.get(channel)).remove(pos);
        }
    }

    public static boolean isStoppablePlaying(class_2338 pos, int channel) {
        class_1144 manager = class_310.method_1551().method_1483();
        return manager.method_4877((class_1113)((Map)stoppableSoundStorage.get(channel)).get(pos));
    }

    public static boolean isChannelPlaying(int channel) {
        class_1144 manager = class_310.method_1551().method_1483();
        if (stoppableSoundStorage.containsKey(channel)) {
            for (class_2338 pos : ((Map)stoppableSoundStorage.get(channel)).keySet()) {
                if (!manager.method_4877((class_1113)((Map)stoppableSoundStorage.get(channel)).get(pos))) continue;
                return true;
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerPlaySoundCallback(SoundConsumer consumer) {
        playSoundCallbacks.add(consumer);
    }

    public static void init() {
        ClientTickEvents.END_WORLD_TICK.register(ClientReceiverStorage::tick);
    }

    @FunctionalInterface
    public static interface SoundConsumer {
        public void apply(class_2960 var1, Set<class_2338> var2, Set<class_1297> var3, int var4, float var5, float var6, boolean var7);
    }
}

